% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx.R
\name{pptx}
\alias{pptx}
\alias{dim.pptx}
\alias{print.pptx}
\title{Create Microsoft PowerPoint document object representation}
\usage{
pptx(title, template,
  list.definition = getOption("ReporteRs-list-definition"))

\method{dim}{pptx}(x)

\method{print}{pptx}(x, ...)
}
\arguments{
\item{title}{\code{"character"} value: title of the document (in the doc properties).}

\item{template}{\code{"character"} value, it represents the filename of the pptx file used as a template.}

\item{list.definition}{a list definition to specify how ordered and unordered
lists have to be formated. See \code{\link{list.settings}}. Default to
\code{getOption("ReporteRs-list-definition")}.}

\item{x}{Object of class \code{pptx}}

\item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{pptx}}.
}
\description{
Create a \code{\link{pptx}} object
}
\details{
To send R output in a pptx document, a slide (see \code{\link{addSlide.pptx}}
have to be added to the object first (because output is beeing written in slides).

Several methods can used to send R output into an object of class \code{\link{pptx}}.

\itemize{
  \item \code{\link{addTitle.pptx}} add titles
  \item \code{\link{addParagraph.pptx}} add text
  \item \code{\link{addPlot.pptx}} add plots
  \item \code{\link{addFlexTable.pptx}} add \code{\link{FlexTable}}
  \item \code{\link{addDate.pptx}} add a date (most often in the bottom left area of the slide)
  \item \code{\link{addFooter.pptx}} add a comment in the footer (most often in the bottom center area of the slide)
  \item \code{\link{addPageNumber.pptx}} add a page number (most often in the bottom right area of the slide)
  \item \code{\link{addImage.pptx}} add external images
}
Once object has content, user can write the pptx into a ".pptx" file, see \code{\link{writeDoc}}.

\code{dim} returns slide width and height, position and
dimension of the next available shape in the current slide.

\code{print} print informations about an object of
class \code{pptx}.
}
\note{
Power Point 2007-2013 (*.pptx) file formats are the only supported files.

Document are manipulated in-memory ; a \code{pptx}'s document is not written to the disk
unless the \code{\link{writeDoc}} method has been called on the object.
}
\examples{
\donttest{
# set default font size to 10
options( "ReporteRs-fontsize" = 11 )

# Word document to write
pptx.file = "presentation_example.pptx"

# Create a new document
doc = pptx( title = "title" )

# display layouts names
slide.layouts( doc )

# add a slide with layout "Title Slide"
doc = addSlide( doc, slide.layout = "Title Slide" )

#set the main title
doc = addTitle( doc, "Presentation title" )
#set the sub-title
doc = addSubtitle( doc , "This document is generated with ReporteRs.")


################ TEXT DEMO ################

# add a slide with layout "Title and Content" then add content
doc = addSlide( doc, slide.layout = "Two Content" )

# add a title
doc = addTitle( doc, "Text demo" )
sometext = c( "Lorem ipsum dolor sit amet, consectetur adipiscing elit."
	, "In sit amet ipsum tellus. Vivamus dignissim sit amet auctor."
	, "Quisque dictum tristique ligula."
)

# add simple text
doc = addParagraph( doc, value = sometext )

# Add "My tailor is rich" and "Cats and Dogs"
# format some of the pieces of text
pot1 = pot("My tailor"
	, textProperties(color="red" ) ) + " is " + pot("rich"
	, textProperties(font.weight="bold") )
pot2 = pot("Cats"
	, textProperties(color="red" )
	) + " and " + pot("Dogs"
	, textProperties(color="blue" ) )
doc = addParagraph(doc, set_of_paragraphs( pot1, pot2 ) )

################ PLOT DEMO ################
if( requireNamespace("ggplot2", quietly = TRUE) ){
  doc = addSlide( doc, slide.layout = "Title and Content" )
  doc = addTitle( doc, "Plot examples" )

  myplot = ggplot2::qplot(Sepal.Length, Petal.Length
    , data = iris, color = Species
    , size = Petal.Width, alpha = I(0.7)
)
  # Add titles and then 'myplot'
  doc = addPlot( doc, function( ) print( myplot ) )
}

################ FLEXTABLE DEMO ################
doc = addSlide( doc, slide.layout = "Title and Content" )
doc = addTitle( doc, "FlexTable example" )

# Create a FlexTable with data.frame mtcars, display rownames
# use different formatting properties for header and body
MyFTable = FlexTable( data = mtcars, add.rownames = TRUE,
	header.cell.props = cellProperties( background.color = "#00557F" ),
	header.text.props = textProperties( color = "white",
		font.size = 11, font.weight = "bold" ),
	body.text.props = textProperties( font.size = 10 )
)
# zebra stripes - alternate colored backgrounds on table rows
MyFTable = setZebraStyle( MyFTable, odd = "#E1EEf4", even = "white" )

# applies a border grid on table
MyFTable = setFlexTableBorders(MyFTable,
	inner.vertical = borderProperties( color="#0070A8", style="solid" ),
	inner.horizontal = borderNone(),
	outer.vertical = borderProperties( color = "#006699",
	  style = "solid", width = 2 ),
	outer.horizontal = borderProperties( color = "#006699",
	  style = "solid", width = 2 )
)

# add MyFTable into document
doc = addFlexTable( doc, MyFTable )

# write the doc
writeDoc( doc, file = pptx.file )
}
\donttest{
# get pptx page dimensions ------
doc = pptx( title = "title" )
doc = addSlide( doc, "Title and Content" )
dim(doc)
}
}
\references{
Wikipedia: Office Open XML\cr\url{http://en.wikipedia.org/wiki/Office_Open_XML}
}
\seealso{
\code{\link{docx}}
}
