#' @title Insert an external image into a html object
#'
#' @description Add an external image into a \code{\link{html}} object.
#' 
#' @param doc \code{\link{html}} object where external image has to be added
#' @param filename \code{"character"} value, complete filename of the external image
#' @param width image width in pixel
#' @param height image height in pixel
#' @param ... further arguments, not used. 
#' @return an object of class \code{\link{html}}.
#' @examples
#' #START_TAG_TEST
#' # Create a new document 
#' doc = html( title = "title" )
#' 
#' # add a page where to add content
#' doc = addPage( doc, title = "page example" )
#' 
#' # the file 'logo.jpg' only exists in R for Windows
#' img.file = file.path( Sys.getenv("R_HOME"), "doc", "html", "logo.jpg" )
#' doc = addImage(doc, img.file, width = 100, height = 76 )
#' 
#' writeDoc( doc, "addImage_example" )
#' #STOP_TAG_TEST
#' @seealso \code{\link{html}}, \code{\link{addPlot.html}}
#' , \code{\link{addImage}}
#' @method addImage html
#' @S3method addImage html

addImage.html = function(doc, filename, width, height, ... ) {

	slide = doc$current_slide 
	if( missing( width ) && missing(height) ){
		stop("width and height cannot be missing")
	}
	
	for( i in 1:length( filename ) ){
		jimg = .jnew(class.Image , filename[i] )
		if( !missing( width ) && !missing(height) )
			.jcall( jimg, "V", "setDim", as.integer(width), as.integer(height) )
		out = .jcall( slide, "I", "add", jimg )
		if( out != 1 )
			stop( "Problem while trying to add image(s)." )
	}
	
	
	doc
}
