/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docs;

import org.docx4j.dml.CTTransform2D;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.lysis.reporters.docs.pptx4R;
import org.lysis.reporters.img.DrawingML;
import org.lysis.reporters.img.Image;
import org.lysis.reporters.pptx4r.elements.Date;
import org.lysis.reporters.pptx4r.elements.Footer;
import org.lysis.reporters.pptx4r.elements.SlideNumber;
import org.lysis.reporters.pptx4r.elements.SubTitle;
import org.lysis.reporters.pptx4r.elements.Title;
import org.lysis.reporters.pptx4r.elements.layouts.SlideLayout;
import org.lysis.reporters.tables.FlexTable;
import org.lysis.reporters.text.ParagraphSet;
import org.lysis.reporters.text.RScript;
import org.lysis.reporters.tools.EMU;
import org.pptx4j.pml.Pic;
import org.pptx4j.pml.Shape;
import org.pptx4j.pml.Sld;

public class SlideContent {
    public static int undefined = -1;
    public static int donotexists = 0;
    public static int isfilled = 1;
    public static int noproblem = 2;
    public static int noroomleft = 3;
    public static int undefdimension = 4;
    private SlidePart slidePart;
    private pptx4R itsPPTX;
    private long uidShape;
    private String layoutName;
    private SlideLayout slideLayout;
    private int slideIndex;
    private long freeshapeid;

    public SlideContent(String masterName, pptx4R doc) throws Exception {
        this.layoutName = masterName;
        this.slidePart = doc.getNewSlide(masterName);
        this.itsPPTX = doc;
        this.uidShape = -1L;
        this.freeshapeid = 0L;
        this.slideLayout = new SlideLayout(doc.getLayoutProperties(masterName), doc.getMasterLayout());
        this.slideIndex = doc.getSlideNumber();
    }

    public SlideContent(String masterName, pptx4R doc, int slideIndex) throws Exception {
        this.layoutName = masterName;
        this.slidePart = doc.getAndReInitExistingSlide(masterName, slideIndex);
        this.itsPPTX = doc;
        this.uidShape = -1L;
        this.slideLayout = new SlideLayout(doc.getLayoutProperties(masterName), doc.getMasterLayout());
        this.slideIndex = slideIndex;
    }

    public int getmax_shape() {
        return this.slideLayout.getContentSize();
    }

    public int getNextShapeID() {
        long idx = this.slideLayout.idContent(this.slideLayout.getContentFilled());
        return (int)idx;
    }

    public int getNextIndex() {
        return this.slideLayout.getContentFilled();
    }

    public int addTitle(String title) {
        boolean isCRT = false;
        if (!this.slideLayout.contains(SlideLayout.TITLE) && this.slideLayout.contains(SlideLayout.CRTTITLE)) {
            isCRT = true;
        }
        if (!isCRT) {
            if (!this.slideLayout.contains(SlideLayout.TITLE)) {
                return donotexists;
            }
            if (this.slideLayout.isFilled(SlideLayout.TITLE)) {
                return isfilled;
            }
            if (this.slideLayout.contains(SlideLayout.TITLE) && !this.slideLayout.isFilled(SlideLayout.TITLE)) {
                try {
                    Shape sTitle = (Shape)Title.getShape(this.slideLayout.id(SlideLayout.TITLE), this.uidShape + 1L, title);
                    ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
                    this.slideLayout.setFilled(SlideLayout.TITLE);
                    ++this.uidShape;
                    return noproblem;
                }
                catch (Exception e) {
                    return undefined;
                }
            }
            return undefined;
        }
        if (this.slideLayout.isFilled(SlideLayout.CRTTITLE)) {
            return isfilled;
        }
        if (this.slideLayout.contains(SlideLayout.CRTTITLE) && !this.slideLayout.isFilled(SlideLayout.CRTTITLE)) {
            try {
                Shape sTitle = (Shape)Title.getShape(this.slideLayout.id(SlideLayout.CRTTITLE), this.uidShape + 1L, title);
                ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
                this.slideLayout.setFilled(SlideLayout.CRTTITLE);
                ++this.uidShape;
                return noproblem;
            }
            catch (Exception e) {
                return undefined;
            }
        }
        return undefined;
    }

    public int addSubTitle(String title) {
        if (!this.slideLayout.contains(SlideLayout.SUBTITLE)) {
            return donotexists;
        }
        if (this.slideLayout.isFilled(SlideLayout.SUBTITLE)) {
            return isfilled;
        }
        if (this.slideLayout.contains(SlideLayout.SUBTITLE) && !this.slideLayout.isFilled(SlideLayout.SUBTITLE)) {
            try {
                Shape sTitle = (Shape)SubTitle.getShape(this.slideLayout.id(SlideLayout.SUBTITLE), this.uidShape + 1L, title);
                ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
                this.slideLayout.setFilled(SlideLayout.SUBTITLE);
                ++this.uidShape;
                return noproblem;
            }
            catch (Exception e) {
                return undefined;
            }
        }
        return undefined;
    }

    public int addDate(String date) {
        if (!this.slideLayout.contains(SlideLayout.DATE)) {
            return donotexists;
        }
        if (this.slideLayout.isFilled(SlideLayout.DATE)) {
            return isfilled;
        }
        if (this.slideLayout.contains(SlideLayout.DATE) && !this.slideLayout.isFilled(SlideLayout.DATE)) {
            try {
                Shape sDate = (Shape)Date.getShape(this.slideLayout.id(SlideLayout.DATE), this.uidShape + 1L, date);
                ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sDate);
                this.slideLayout.setFilled(SlideLayout.DATE);
                ++this.uidShape;
                return noproblem;
            }
            catch (Exception e) {
                return undefined;
            }
        }
        return undefined;
    }

    public int addSlideNumber(String slidenumber) {
        if (!this.slideLayout.contains(SlideLayout.SLIDENUMBER)) {
            return donotexists;
        }
        if (this.slideLayout.isFilled(SlideLayout.SLIDENUMBER)) {
            return isfilled;
        }
        if (this.slideLayout.contains(SlideLayout.SLIDENUMBER) && !this.slideLayout.isFilled(SlideLayout.SLIDENUMBER)) {
            try {
                Shape sSlideNumber = (Shape)SlideNumber.getShape(this.slideLayout.id(SlideLayout.SLIDENUMBER), this.uidShape + 1L, slidenumber);
                ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sSlideNumber);
                this.slideLayout.setFilled(SlideLayout.SLIDENUMBER);
                ++this.uidShape;
                return noproblem;
            }
            catch (Exception e) {
                return undefined;
            }
        }
        return undefined;
    }

    public int addSlideNumber() {
        return this.addSlideNumber(String.valueOf(this.slideIndex));
    }

    public int addFooter(String footer) {
        if (!this.slideLayout.contains(SlideLayout.FOOTER)) {
            return donotexists;
        }
        if (this.slideLayout.isFilled(SlideLayout.FOOTER)) {
            return isfilled;
        }
        if (this.slideLayout.contains(SlideLayout.FOOTER) && !this.slideLayout.isFilled(SlideLayout.FOOTER)) {
            try {
                Shape sFooter = (Shape)Footer.getShape(this.slideLayout.id(SlideLayout.FOOTER), this.uidShape + 1L, footer);
                ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sFooter);
                this.slideLayout.setFilled(SlideLayout.FOOTER);
                ++this.uidShape;
                return noproblem;
            }
            catch (Exception e) {
                return undefined;
            }
        }
        return undefined;
    }

    private CTTransform2D readXrfm() {
        int numContentFilled = this.slideLayout.getContentFilled();
        if (numContentFilled >= this.slideLayout.getContentSize()) {
            return null;
        }
        return this.slideLayout.getXfrmContent(numContentFilled);
    }

    private boolean roomLeft() {
        int numContentFilled = this.slideLayout.getContentFilled();
        return numContentFilled < this.slideLayout.getContentSize();
    }

    private void addIMG(Image img) throws Exception {
        Pic shape = (Pic)img.get_pptx_elt();
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(shape);
    }

    public int add(Image img) throws Exception {
        if (!this.roomLeft()) {
            return noroomleft;
        }
        img.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        img.setPPTXSlidePart(this.slidePart);
        img.setXfrm(this.readXrfm());
        img.setUID(this.uidShape + 1L);
        img.setShapeID(this.uidShape + 1L);
        this.addIMG(img);
        this.uidShape = (int)img.nextUniqueId();
        this.slideLayout.setContentFilled();
        return noproblem;
    }

    public int add(Image img, double offx, double offy) throws Exception {
        ++this.freeshapeid;
        img.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        img.setPPTXSlidePart(this.slidePart);
        img.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        img.setExt(img.getCx(), img.getCy());
        img.setUID(this.freeshapeid + this.uidShape);
        img.setShapeID(this.freeshapeid + this.uidShape);
        this.addIMG(img);
        return noproblem;
    }

    public int add(Image img, double offx, double offy, double width, double height) throws Exception {
        ++this.freeshapeid;
        img.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        img.setPPTXSlidePart(this.slidePart);
        img.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        img.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
        img.setUID(this.freeshapeid + this.uidShape);
        img.setShapeID(this.freeshapeid + this.uidShape);
        this.addIMG(img);
        return noproblem;
    }

    public int add(DrawingML d) throws Exception {
        if (!this.roomLeft()) {
            return noroomleft;
        }
        d.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        d.setPPTXSlidePart(this.slidePart);
        d.setXfrm(this.readXrfm());
        d.setUID(this.uidShape + 1L);
        d.setShapeID(this.uidShape + 1L);
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().addAll(d.get_pptx_elt());
        this.slideLayout.setContentFilled();
        ++this.uidShape;
        return noproblem;
    }

    public int add(DrawingML d, double offx, double offy, double width, double height) throws Exception {
        ++this.freeshapeid;
        d.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        d.setPPTXSlidePart(this.slidePart);
        d.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        d.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
        d.setUID(this.freeshapeid + this.uidShape);
        d.setShapeID(this.freeshapeid + this.uidShape);
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().addAll(d.get_pptx_elt());
        return noproblem;
    }

    public int[] getShapeDimensions() {
        int[] out = new int[]{-1, -1, -1, -1};
        int numContentFilled = this.slideLayout.getContentFilled();
        if (numContentFilled >= this.slideLayout.getContentSize()) {
            return out;
        }
        CTTransform2D xfrm = this.slideLayout.getXfrmContent(numContentFilled);
        out[0] = (int)xfrm.getOff().getX();
        out[1] = (int)xfrm.getOff().getY();
        out[2] = (int)xfrm.getExt().getCx();
        out[3] = (int)xfrm.getExt().getCy();
        return out;
    }

    public int add(FlexTable obj) throws Exception {
        if (!this.roomLeft()) {
            return noroomleft;
        }
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setXfrm(this.readXrfm());
        obj.setUID(this.uidShape + 1L);
        obj.setShapeID(this.uidShape + 1L);
        obj.setTableWidth(obj.getCx());
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
        this.slideLayout.setContentFilled();
        ++this.uidShape;
        return noproblem;
    }

    public int add(FlexTable obj, double offx, double offy, double width, double height) throws Exception {
        ++this.freeshapeid;
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
        obj.setUID(this.freeshapeid + this.uidShape);
        obj.setShapeID(this.freeshapeid + this.uidShape);
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
        return noproblem;
    }

    public int add(ParagraphSet obj) throws Exception {
        if (!this.roomLeft()) {
            return noroomleft;
        }
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setXfrm(this.readXrfm());
        obj.setUID(this.uidShape + 1L);
        obj.setShapeID(this.uidShape + 1L);
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
        this.slideLayout.setContentFilled();
        ++this.uidShape;
        return noproblem;
    }

    public int add(ParagraphSet obj, double offx, double offy, double width, double height) throws Exception {
        ++this.freeshapeid;
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
        obj.setUID(this.freeshapeid + this.uidShape);
        obj.setShapeID(this.freeshapeid + this.uidShape);
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
        return noproblem;
    }

    public int add(RScript obj) throws Exception {
        if (!this.roomLeft()) {
            return noroomleft;
        }
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setXfrm(this.readXrfm());
        obj.setUID(this.uidShape + 1L);
        obj.setShapeID(this.uidShape + 1L);
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
        this.slideLayout.setContentFilled();
        ++this.uidShape;
        return noproblem;
    }

    public int add(RScript obj, double offx, double offy, double width, double height) throws Exception {
        ++this.freeshapeid;
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
        obj.setUID(this.freeshapeid + this.uidShape);
        obj.setShapeID(this.freeshapeid + this.uidShape);
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
        return noproblem;
    }

    public String getLayoutName() {
        return this.layoutName;
    }
}

