test_that("Output of function 'ci2se' stays the same.", {
    # set the length of the sequences
    l <- 5L
    # set lower and upper bounds for ratio = TRUE
    lower_ratio <- seq(1e-5, 10, length.out = l)
    upper_ratio <- lower_ratio + seq(0, 10, length.out = l)
    # set lower and upper bounds for ratio = FALSE
    lower_nonratio <- seq(-10, 10, length.out = l)
    upper_nonratio <- lower_nonratio + seq(0, 10, length.out = l)
    # set conf.level
    conf.level <- seq(1e-6, 1 - 1e-6, length.out = l)
    # construct a parameter grid
    grid <- rbind(
        expand.grid(
            lower = lower_ratio,
            upper = upper_ratio,
            conf.level = conf.level,
            ratio = TRUE,
            stringsAsFactors = FALSE
        ),
        expand.grid(
            lower = lower_nonratio,
            upper = upper_nonratio,
            conf.level = conf.level,
            ratio = FALSE,
            stringsAsFactors = FALSE
        )
    )
    grid <- grid[with(grid, lower <= upper), ]
    # iterate over the grid
    out <- lapply(
        seq_len(nrow(grid)),
        function(i) {
            ci2se(
                lower = grid[i, "lower"],
                upper = grid[i, "upper"],
                conf.level = grid[i, "conf.level"],
                ratio = grid[i, "ratio"]
            )
        }
    )
    res <- list(
        0, 5235066.16771778, 276525.11841561, 0.199470890839573,
        5511591.48560359, 553050.436301412, 276525.517356693, 114768.608488804,
        0.199471090239863, 5673348.5274521, 714807.478149928, 438282.559205209,
        276525.65033732, 161757.241319607, 5788117.00296018, 829575.953658005,
        553051.034713286, 391294.125845397, 276525.716827684, 0,
        20.5912062510812, 1.08766261294129, 7.84583446087584e-07,
        21.6788696486032, 2.17532601046328, 1.08766418210544, 0.451422009355957,
        7.84584230393336e-07, 22.3151123444084, 2.81156870626852,
        1.72390687791068, 1.0876647051612, 0.636243480389471, 22.7665338307082,
        3.26299019256832, 2.17532836421048, 1.539086191461, 1.08766496668927,
        0, 9.72762363963899, 0.513829661875377, 3.70650091323827e-07,
        10.2414536721632, 1.02765969439955, 0.513830403174262, 0.213259162970783,
        3.70650461842731e-07, 10.5420251594668, 1.32823118170315,
        0.814401890477864, 0.513830650274385, 0.300571857954064,
        10.7552840753372, 1.54149009757362, 1.02766080634834, 0.72708956614486,
        0.513830773824539, 0, 5.70364923687938, 0.301276474852418,
        2.17325236752979e-07, 6.00492592905627, 0.602553167029312,
        0.301276909502131, 0.125041377750197, 2.17325454001296e-07,
        6.18116160569173, 0.778788843664773, 0.477512586137592, 0.301277054385658,
        0.176235893960915, 6.30620283855829, 0.903830076531334, 0.602553819004153,
        0.426318287252219, 0.301277126827476, 0, 1.3413056732083,
        0.0708500519826567, 5.11075560368074e-08, 1.41215577629833,
        0.141700155072691, 0.07085015419759, 0.0294055090691173,
        5.11076071262745e-08, 1.45360045549851, 0.183144834272876,
        0.112294833397775, 0.0708501882693025, 0.0414447303077923,
        1.48300593049589, 0.212550309270255, 0.141700308395154, 0.100255663266682,
        0.0708502053051715, 0, 2992067.10259174, 997355.700863912,
        5984134.20518347, 3989422.80345565, 1994711.40172782, 0,
        8976201.30777521, 6981489.90604739, 4986778.50431956, 2992067.10259174,
        997355.700863912, 11968268.4103669, 9973557.00863912, 7978845.6069113,
        5984134.20518347, 3989422.80345565, 0, 11.7687664019346,
        3.92292213397819, 23.5375328038691, 15.6916885359128, 7.84584426795638,
        0, 35.3062992058037, 27.4604549378473, 19.6146106698909,
        11.7687664019346, 3.92292213397819, 47.0750656077383, 39.2292213397819,
        31.3833770718255, 23.5375328038691, 15.6916885359128, 0,
        5.55975831939601, 1.853252773132, 11.119516638792, 7.41301109252801,
        3.70650554626401, 0, 16.679274958188, 12.972769411924, 9.26626386566001,
        5.55975831939601, 1.853252773132, 22.239033277584, 18.53252773132,
        14.826022185056, 11.119516638792, 7.41301109252801, 0, 3.25988262605456,
        1.08662754201819, 6.51976525210913, 4.34651016807275, 2.17325508403638,
        0, 9.77964787816369, 7.60639279412732, 5.43313771009094,
        3.25988262605456, 1.08662754201819, 13.0395305042183, 10.8662754201819,
        8.6930203361455, 6.51976525210913, 4.34651016807275, 0, 0.766614298798019,
        0.25553809959934, 1.53322859759604, 1.02215239839736, 0.51107619919868,
        0, 2.29984289639406, 1.78876669719538, 1.2776904979967, 0.766614298798019,
        0.25553809959934, 3.06645719519208, 2.5553809959934, 2.04430479679472,
        1.53322859759604, 1.02215239839736
    )
    expect_equal(out, res)
})

test_that("Output of function 'ci2estimate' stays the same.", {
    # set the length of the sequences
    l <- 5L
    # set lower and upper bounds for ratio = TRUE
    lower_ratio <- seq(1e-5, 10, length.out = l)
    upper_ratio <- lower_ratio + seq(0, 10, length.out = l)
    #upper_ratio <- lower_ratio + seq(1e-2, 10, length.out = l)
    # set lower and upper bounds for ratio = FALSE
    lower_nonratio <- seq(-10, 10, length.out = l)
    upper_nonratio <- lower_nonratio + seq(0, 10, length.out = l)
    # upper_nonratio <- lower_nonratio + seq(1e-2, 10, length.out = l)
    # set conf.level
    conf.level <- seq(1e-6, 1 - 1e-6, length.out = l)
    # construct a parameter grid
    grid <- rbind(
        expand.grid(
            lower = lower_ratio,
            upper = upper_ratio,
            ratio = TRUE,
            antilog = c(TRUE, FALSE),
            stringsAsFactors = FALSE
        ),
        expand.grid(
            lower = lower_nonratio,
            upper = upper_nonratio,
            ratio = FALSE,
            antilog = FALSE,
            stringsAsFactors = FALSE
        )
    )
    grid <- grid[with(grid, lower <= upper), ]
    # iterate over the grid
    out <- lapply(
        seq_len(nrow(grid)),
        function(i) {
            ci2estimate(
                lower = grid[i, "lower"],
                upper = grid[i, "upper"],
                ratio = grid[i, "ratio"],
                antilog = grid[i, "antilog"]
            )
        }
    )
    res <- list(
        1e-05, 0.00707107311516434, 3.53554186088303, 5.00000624999984,
        0.0100000024999997, 5.00000874999609, 7.07107311516611, 8.66025764628354,
        10.0000024999997, 0.0122474497345366, 6.1237340528487, 8.66025908965849,
        10.6066043694486, 12.2474497345366, 0.0141421356237309, 7.07107841845924,
        10.0000049999987, 12.2474507551572, 14.142135623731, -11.5129254649702,
        -4.95174302626863, 1.26286657215132, 1.60943916243329, -4.60516993598815,
        1.60943966243179, 1.95601225271376, 2.15874447343473, 2.30258534299398,
        -4.40243754860068, 1.81217204981926, 2.15874464010123, 2.3614768608222,
        2.50531773038145, -4.25859659570812, 1.95601300271182, 2.3025855929938,
        2.50531781371477, 2.64915868327402, -10, -6.25, -3.75, -2.5,
        0, 2.5, 5, 1.25, 3.75, 6.25, 8.75, 11.25, 5, 7.5, 10, 12.5,
        15
    )
    expect_equal(out, res)
})

test_that("Output of function 'ci2z' stays the same.", {
    # set the length of the sequences
    l <- 5L
    # set lower and upper bounds for ratio = TRUE
    lower_ratio <- seq(1e-5, 10, length.out = l)
    upper_ratio <- lower_ratio + seq(0, 10, length.out = l)
    # set lower and upper bounds for ratio = FALSE
    lower_nonratio <- seq(-10, 10, length.out = l)
    upper_nonratio <- lower_nonratio + seq(0, 10, length.out = l)
    # set conf.level
    conf.level <- seq(1e-6, 1 - 1e-6, length.out = l)
    # construct a parameter grid
    grid <- rbind(
        expand.grid(
            lower = lower_ratio,
            upper = upper_ratio,
            conf.level = conf.level,
            ratio = TRUE,
            stringsAsFactors = FALSE
        ),
        expand.grid(
            lower = lower_nonratio,
            upper = upper_nonratio,
            conf.level = conf.level,
            ratio = FALSE,
            stringsAsFactors = FALSE
        )
    )
    grid <- grid[with(grid, lower <= upper), ]
    # iterate over the grid
    out <- lapply(
        seq_len(nrow(grid)),
        function(i) {
            tryCatch(
                ci2z(
                    lower = grid[i, "lower"],
                    upper = grid[i, "upper"],
                    conf.level = grid[i, "conf.level"],
                    ratio = grid[i, "ratio"]
                ),
                error = function(e) "error!"
            )
        }
    )

    res <- list("error!", -9.45879740127015e-07, 4.56691449726915e-06, 8.06854150828305,
        -8.35542682729112e-07, 2.91011371981749e-06, 7.07353256730618e-06,
        1.88095377460756e-05, 11.5434539422487, -7.75985738809848e-07,
        2.53518899174018e-06, 4.9254632536963e-06, 8.53981125418763e-06,
        1.54881333901544e-05, -7.35748187801002e-07, 2.35784679399976e-06,
        4.16342335239913e-06, 6.4026461125681e-06, 9.58015302759286e-06,
        "error!", -0.240478530781004, 1.16108300232572, 2051329.49268678,
        -0.212426662950338, 0.73986136086748, 1.79836045435221, 4.78209841056401,
        2934784.12361108, -0.197285027323818, 0.644541264732012,
        1.25223970491815, 2.17114414912656, 3.93767135947365, -0.187055114642177,
        0.599454147047936, 1.05850023880395, 1.62779565408001, 2.43563851407088,
        "error!", -0.509039330642977, 2.45775334873059, 4342206.30213514,
        -0.449659792779736, 1.56612122787609, 3.80672735717896, 10.1226340916028,
        6212282.40630382, -0.417608332555276, 1.3643498773275, 2.65071172518344,
        4.59582716515875, 8.3351706558115, -0.395953892605537, 1.26891052092432,
        2.2406085536878, 3.44567977642472, 5.15570265197593, "error!",
        -0.868171028865348, 4.19171982402522, 7405670.81154337, -0.766898707893287,
        2.67103344650331, 6.49240678930931, 17.264240943885, 10595101.9569951,
        -0.71223466225941, 2.32691064408635, 4.5208120220714, 7.83822341079891,
        14.2157064266208, -0.675302825603641, 2.16413798732887, 3.8213774776157,
        5.87663698374864, 8.79309594847218, "error!", -3.69173345433219,
        17.8244974677005, 31491217.4879616, -3.26109202205697, 11.3580656394212,
        27.6077345895218, 73.412926413232, 45053671.5073522, -3.02864348449235,
        9.89474836685386, 19.2238999318378, 33.330565782637, 60.4496087144379,
        -2.87159781908904, 9.20258836332615, 16.2496865325985, 24.989289702773,
        37.3909810403986, "error!", -2.08885689581836e-06, -3.75994241247304e-06,
        -4.17771379163671e-07, 0, 1.25331413749101e-06, "error!",
        1.3925712638789e-07, 5.37134630353292e-07, 1.25331413749101e-06,
        2.9243996541457e-06, 1.12798272374191e-05, 4.17771379163671e-07,
        7.51988482494608e-07, 1.25331413749101e-06, 2.08885689581836e-06,
        3.75994241247304e-06, "error!", -0.531066705425695, -0.955920069766251,
        -0.106213341085139, 0, 0.318640023255417, "error!", 0.0354044470283797,
        0.136560009966607, 0.318640023255417, 0.743493387595973,
        2.86776020929875, 0.106213341085139, 0.19118401395325, 0.318640023255417,
        0.531066705425695, 0.955920069766251, "error!", -1.12414958366014,
        -2.02346925058824, -0.224829916732027, 0, 0.674489750196082,
        "error!", 0.0749433055773424, 0.289067035798321, 0.674489750196082,
        1.57380941712419, 6.07040775176474, 0.224829916732027, 0.404693850117649,
        0.674489750196082, 1.12414958366014, 2.02346925058824, "error!",
        -1.91724694320187, -3.45104449776337, -0.383449388640374,
        0, 1.15034816592112, "error!", 0.127816462880125, 0.493006356823338,
        1.15034816592112, 2.68414572048262, 10.3531334932901, 0.383449388640374,
        0.690208899552674, 1.15034816592112, 1.91724694320187, 3.45104449776337,
        "error!", -8.15273079278514, -14.6749154270133, -1.63054615855703,
        0, 4.89163847567108, "error!", 0.543515386185676, 2.09641648957332,
        4.89163847567108, 11.4138231098992, 44.0247462810398, 1.63054615855703,
        2.93498308540265, 4.89163847567108, 8.15273079278514, 14.6749154270133)

    expect_equal(out, res)
    # idx <- as.integer(
    #     gsub(
    #         "^Component (\\d+):.+$",
    #         "\\1",
    #         all.equal(out, res)[c(TRUE,FALSE)]
    #     )
    # )
    # out[idx]
    # res[idx]
})

test_that("Output of function 'ci2p' stays the same.", {
    # set the length of the sequences
    l <- 5L
    # set lower and upper bounds for ratio = TRUE
    lower_ratio <- seq(1e-5, 10, length.out = l)
    upper_ratio <- lower_ratio + seq(0, 10, length.out = l)
    # set lower and upper bounds for ratio = FALSE
    lower_nonratio <- seq(-10, 10, length.out = l)
    upper_nonratio <- lower_nonratio + seq(0, 10, length.out = l)
    # set conf.level
    conf.level <- seq(1e-6, 1 - 1e-6, length.out = l)
    # construct a parameter grid
    grid <- rbind(
        expand.grid(
            lower = lower_ratio,
            upper = upper_ratio,
            conf.level = conf.level,
            ratio = TRUE,
            alternative = c("two.sided", "one.sided", "less", "greater"),
            stringsAsFactors = FALSE
        ),
        expand.grid(
            lower = lower_nonratio,
            upper = upper_nonratio,
            conf.level = conf.level,
            ratio = FALSE,
            alternative = c("two.sided", "one.sided", "less", "greater"),
            stringsAsFactors = FALSE
        )
    )
    grid <- grid[with(grid, lower <= upper), ]
    # iterate over the grid
    out <- lapply(
        seq_len(nrow(grid)),
        function(i) {
            tryCatch({
                ci2p(
                    lower = grid[i, "lower"],
                    upper = grid[i, "upper"],
                    conf.level = grid[i, "conf.level"],
                    ratio = grid[i, "ratio"],
                    alternative = grid[i, "alternative"]
                )
            },
            warning = function(w) "warning!",
            error = function(e) "error!"
            )
        }
    )
    res <- list("error!", 0.999999245297159, 0.999996356129432, 7.11428825917605e-16,
    0.999999333333394, 0.999997678065193, 0.999994356137574,
    0.999984992160238, 7.96609798836552e-31, 0.99999938085296,
    0.999997977211845, 0.999996070048915, 0.999993186216448,
    0.999987642257493, 0.99999941295788, 0.999998118710446, 0.999996678068787,
    0.999994891427519, 0.999992356143809, "error!", 0.809959304957256,
    0.245608146469407, 0, 0.83177418638241, 0.459384121898918,
    0.0721199052706156, 1.73474710303411e-06, 0, 0.8436044955564,
    0.51922450819031, 0.210482532111843, 0.0299202776383367,
    8.22761733748553e-05, 0.851617420246171, 0.54887007832661,
    0.28982744195767, 0.10356822235657, 0.0148655319165679, "error!",
    0.61072465593842, 0.0139809158957613, 0, 0.652955767101005,
    0.117320239337576, 0.000140817837711897, 4.38453988778963e-24,
    0, 0.676233503527517, 0.17245747496421, 0.00803223657994017,
    4.31035883888193e-06, 7.73864936562261e-17, 0.692139042593436,
    0.204472979490355, 0.0250514421609833, 0.000569624930429731,
    2.52681597948809e-07, "error!", 0.385300711639438, 2.76847761085069e-05,
    0, 0.443141741967785, 0.00756181116835415, 8.44757857361097e-11,
    8.74460919954519e-67, 0, 0.476319476047964, 0.0199700215751639,
    6.16028725978524e-06, 4.56965460813306e-15, 7.32089269254244e-46,
    0.49948338909474, 0.0304537608539682, 0.000132708341843186,
    4.18684962436485e-09, 1.45494120021732e-18, "error!", 0.00022273082201151,
    4.56171377891061e-71, 0, 0.00110984015883608, 6.76254267699323e-30,
    8.98535452863403e-168, 0, 0, 0.00245654391714464, 4.38712312437943e-23,
    2.33539214174309e-82, 1.39334251767367e-243, 0, 0.00408402363116607,
    3.49429328937378e-20, 2.2450939906964e-59, 7.99334422796047e-138,
    5.47598411060939e-306, "error!", 0.500000377351421, 0.499998178064716,
    3.55714412958803e-16, 0.500000333333303, 0.499998839032596,
    0.499997178068787, 0.499992496080119, 3.98304899418276e-31,
    0.50000030957352, 0.499998988605922, 0.499998035024458, 0.499996593108224,
    0.499993821128746, 0.50000029352106, 0.499999059355223, 0.499998339034394,
    0.499997445713759, 0.499996178071905, "error!", 0.595020347521372,
    0.122804073234704, 0, 0.584112906808795, 0.229692060949459,
    0.0360599526353078, 8.67373551517053e-07, 0, 0.5781977522218,
    0.259612254095155, 0.105241266055922, 0.0149601388191683,
    4.11380866874277e-05, 0.574191289876915, 0.274435039163305,
    0.144913720978835, 0.051784111178285, 0.00743276595828395,
    "error!", 0.69463767203079, 0.00699045794788064, 0, 0.673522116449498,
    0.058660119668788, 7.04089188559486e-05, 2.19226994389481e-24,
    0, 0.661883248236242, 0.0862287374821051, 0.00401611828997009,
    2.15517941944097e-06, 3.8693246828113e-17, 0.653930478703282,
    0.102236489745177, 0.0125257210804917, 0.000284812465214865,
    1.26340798974404e-07, "error!", 0.807349644180281, 1.38423880542534e-05,
    0, 0.778429129016108, 0.00378090558417708, 4.22378928680548e-11,
    4.3723045997726e-67, 0, 0.761840261976018, 0.00998501078758196,
    3.08014362989262e-06, 2.28482730406653e-15, 3.66044634627122e-46,
    0.75025830545263, 0.0152268804269841, 6.63541709215931e-05,
    2.09342481218242e-09, 7.2747060010866e-19, "error!", 0.999888634588994,
    2.2808568894553e-71, 0, 0.999445079920582, 3.38127133849662e-30,
    4.49267726431701e-168, 0, 0, 0.998771728041428, 2.19356156218972e-23,
    1.16769607087155e-82, 6.96671258836834e-244, 0, 0.997957988184417,
    1.74714664468689e-20, 1.1225469953482e-59, 3.99667211398024e-138,
    2.73799205530469e-306, "error!", 0.49999962264858, 0.500001821935284,
    1, 0.499999666666697, 0.500001160967404, 0.500002821931213,
    0.500007503919881, 1, 0.49999969042648, 0.500001011394078,
    0.500001964975543, 0.500003406891776, 0.500006178871254,
    0.49999970647894, 0.500000940644777, 0.500001660965606, 0.500002554286241,
    0.500003821928095, "error!", 0.404979652478628, 0.877195926765296,
    1, 0.415887093191205, 0.770307939050541, 0.963940047364692,
    0.999999132626448, 1, 0.4218022477782, 0.740387745904845,
    0.894758733944078, 0.985039861180832, 0.999958861913313,
    0.425808710123085, 0.725564960836695, 0.855086279021165,
    0.948215888821715, 0.992567234041716, "error!", 0.30536232796921,
    0.993009542052119, 1, 0.326477883550502, 0.941339880331212,
    0.999929591081144, 1, 1, 0.338116751763758, 0.913771262517895,
    0.99598388171003, 0.999997844820581, 1, 0.346069521296718,
    0.897763510254822, 0.987474278919508, 0.999715187534785,
    0.999999873659201, "error!", 0.192650355819719, 0.999986157611946,
    1, 0.221570870983892, 0.996219094415823, 0.999999999957762,
    1, 1, 0.238159738023982, 0.990014989212418, 0.99999691985637,
    0.999999999999998, 1, 0.24974169454737, 0.984773119573016,
    0.999933645829078, 0.999999997906575, 1, "error!", 0.000111365411005755,
    1, 1, 0.00055492007941804, 1, 1, 1, 1, 0.00122827195857232,
    1, 1, 1, 1, 0.00204201181558303, 1, 1, 1, 1, "error!", 0.500000377351421,
    0.499998178064716, 3.55714412958803e-16, 0.500000333333303,
    0.499998839032596, 0.499997178068787, 0.499992496080119,
    3.98304899418276e-31, 0.50000030957352, 0.499998988605922,
    0.499998035024458, 0.499996593108224, 0.499993821128746,
    0.50000029352106, 0.499999059355223, 0.499998339034394, 0.499997445713759,
    0.499996178071905, "error!", 0.595020347521372, 0.122804073234704,
    0, 0.584112906808795, 0.229692060949459, 0.0360599526353078,
    8.67373551517053e-07, 0, 0.5781977522218, 0.259612254095155,
    0.105241266055922, 0.0149601388191683, 4.11380866874277e-05,
    0.574191289876915, 0.274435039163305, 0.144913720978835,
    0.051784111178285, 0.00743276595828395, "error!", 0.69463767203079,
    0.00699045794788064, 0, 0.673522116449498, 0.058660119668788,
    7.04089188559486e-05, 2.19226994389481e-24, 0, 0.661883248236242,
    0.0862287374821051, 0.00401611828997009, 2.15517941944097e-06,
    3.8693246828113e-17, 0.653930478703282, 0.102236489745177,
    0.0125257210804917, 0.000284812465214865, 1.26340798974404e-07,
    "error!", 0.807349644180281, 1.38423880542534e-05, 0, 0.778429129016108,
    0.00378090558417708, 4.22378928680548e-11, 4.3723045997726e-67,
    0, 0.761840261976018, 0.00998501078758196, 3.08014362989262e-06,
    2.28482730406653e-15, 3.66044634627122e-46, 0.75025830545263,
    0.0152268804269841, 6.63541709215931e-05, 2.09342481218242e-09,
    7.2747060010866e-19, "error!", 0.999888634588994, 2.2808568894553e-71,
    0, 0.999445079920582, 3.38127133849662e-30, 4.49267726431701e-168,
    0, 0, 0.998771728041428, 2.19356156218972e-23, 1.16769607087155e-82,
    6.96671258836834e-244, 0, 0.997957988184417, 1.74714664468689e-20,
    1.1225469953482e-59, 3.99667211398024e-138, 2.73799205530469e-306,
    "error!", 0.999998333333333, 0.999997, 0.999999666666667,
    1, 0.999999, "error!", 0.999999888888889, 0.999999571428571,
    0.999999, 0.999997666666666, 0.999990999999999, 0.999999666666667,
    0.9999994, 0.999999, 0.999998333333333, 0.999997, "error!",
    0.595372555275566, 0.339112618462186, 0.915413086167851,
    1, 0.7499995, "error!", 0.971757238720767, 0.891378587713149,
    0.7499995, 0.457183023393886, 0.00413388713086358, 0.915413086167851,
    0.848381427626649, 0.7499995, 0.595372555275566, 0.339112618462186,
    "error!", 0.260949573393078, 0.0430247907383896, 0.822111591639247,
    1, 0.5, "error!", 0.940259820548216, 0.772530078864749, 0.5,
    0.115531516287614, 1.27585887864396e-09, 0.822111591639247,
    0.685702563268241, 0.5, 0.260949573393078, 0.0430247907383896,
    "error!", 0.0552065668628533, 0.000558421492305044, 0.701386589656268,
    1, 0.2500005, "error!", 0.898294221433118, 0.62200809573022,
    0.2500005, 0.00727154048736988, 4.05008926464427e-25, 0.701386589656268,
    0.490062827551949, 0.2500005, 0.0552065668628533, 0.000558421492305044,
    "error!", 3.55797056710891e-16, 9.33318549252553e-49, 0.102986117924711,
    1, 1.00000000013978e-06, "error!", 0.586775000154264, 0.0360452608942343,
    1.00000000013978e-06, 3.56699403639081e-30, 0, 0.102986117924711,
    0.00333565870617901, 1.00000000013978e-06, 3.55797056710891e-16,
    9.33318549252553e-49, "error!", 0.500000833333333, 0.5000015,
    0.500000166666667, 0.5, 0.4999995, "error!", 0.499999944444444,
    0.499999785714286, 0.4999995, 0.499998833333333, 0.499995499999999,
    0.499999833333333, 0.4999997, 0.4999995, 0.499999166666667,
    0.4999985, "error!", 0.702313722362217, 0.830443690768907,
    0.542293456916074, 0.5, 0.37499975, "error!", 0.485878619360384,
    0.445689293856574, 0.37499975, 0.228591511696943, 0.00206694356543179,
    0.457706543083926, 0.424190713813325, 0.37499975, 0.297686277637783,
    0.169556309231093, "error!", 0.869525213303461, 0.978487604630805,
    0.588944204180377, 0.5, 0.25, "error!", 0.470129910274108,
    0.386265039432374, 0.25, 0.0577657581438069, 6.37929439321978e-10,
    0.411055795819623, 0.342851281634121, 0.25, 0.130474786696539,
    0.0215123953691948, "error!", 0.972396716568573, 0.999720789253847,
    0.649306705171866, 0.5, 0.12500025, "error!", 0.449147110716559,
    0.31100404786511, 0.12500025, 0.00363577024368494, 2.02504463232214e-25,
    0.350693294828134, 0.245031413775974, 0.12500025, 0.0276032834314267,
    0.000279210746152522, "error!", 1, 1, 0.948506941037645,
    0.5, 5.0000000006989e-07, "error!", 0.293387500077132, 0.0180226304471171,
    5.0000000006989e-07, 1.78349701819541e-30, 0, 0.0514930589623553,
    0.00166782935308951, 5.0000000006989e-07, 1.77898528355445e-16,
    4.66659274626277e-49, "error!", 0.499999166666667, 0.4999985,
    0.499999833333333, 0.5, 0.5000005, "error!", 0.500000055555556,
    0.500000214285714, 0.5000005, 0.500001166666667, 0.500004500000001,
    0.500000166666667, 0.5000003, 0.5000005, 0.500000833333333,
    0.5000015, "error!", 0.297686277637783, 0.169556309231093,
    0.457706543083926, 0.5, 0.62500025, "error!", 0.514121380639616,
    0.554310706143426, 0.62500025, 0.771408488303057, 0.997933056434568,
    0.542293456916074, 0.575809286186675, 0.62500025, 0.702313722362217,
    0.830443690768907, "error!", 0.130474786696539, 0.0215123953691948,
    0.411055795819623, 0.5, 0.75, "error!", 0.529870089725892,
    0.613734960567626, 0.75, 0.942234241856193, 0.999999999362071,
    0.588944204180377, 0.657148718365879, 0.75, 0.869525213303461,
    0.978487604630805, "error!", 0.0276032834314267, 0.000279210746152522,
    0.350693294828134, 0.5, 0.87499975, "error!", 0.550852889283441,
    0.68899595213489, 0.87499975, 0.996364229756315, 1, 0.649306705171866,
    0.754968586224026, 0.87499975, 0.972396716568573, 0.999720789253847,
    "error!", 1.77898528355445e-16, 4.66659274626277e-49, 0.0514930589623553,
    0.5, 0.9999995, "error!", 0.706612499922868, 0.981977369552883,
    0.9999995, 1, 1, 0.948506941037645, 0.99833217064691, 0.9999995,
    1, 1, "error!", 0.500000833333333, 0.5000015, 0.500000166666667,
    0.5, 0.4999995, "error!", 0.499999944444444, 0.499999785714286,
    0.4999995, 0.499998833333333, 0.499995499999999, 0.499999833333333,
    0.4999997, 0.4999995, 0.499999166666667, 0.4999985, "error!",
    0.702313722362217, 0.830443690768907, 0.542293456916074,
    0.5, 0.37499975, "error!", 0.485878619360384, 0.445689293856574,
    0.37499975, 0.228591511696943, 0.00206694356543179, 0.457706543083926,
    0.424190713813325, 0.37499975, 0.297686277637783, 0.169556309231093,
    "error!", 0.869525213303461, 0.978487604630805, 0.588944204180377,
    0.5, 0.25, "error!", 0.470129910274108, 0.386265039432374,
    0.25, 0.0577657581438069, 6.37929439321978e-10, 0.411055795819623,
    0.342851281634121, 0.25, 0.130474786696539, 0.0215123953691948,
    "error!", 0.972396716568573, 0.999720789253847, 0.649306705171866,
    0.5, 0.12500025, "error!", 0.449147110716559, 0.31100404786511,
    0.12500025, 0.00363577024368494, 2.02504463232214e-25, 0.350693294828134,
    0.245031413775974, 0.12500025, 0.0276032834314267, 0.000279210746152522,
    "error!", 1, 1, 0.948506941037645, 0.5, 5.0000000006989e-07,
    "error!", 0.293387500077132, 0.0180226304471171, 5.0000000006989e-07,
    1.78349701819541e-30, 0, 0.0514930589623553, 0.00166782935308951,
    5.0000000006989e-07, 1.77898528355445e-16, 4.66659274626277e-49)
    expect_equal(out, res)
})

