\name{ppc.step1}
\alias{ppc.step1}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Prior predictive check step 1}
\description{
Samples from the posterior distribution of the data by means of blavaan and simulates data y.s using lavaan simulateData. The data y.s are based on samples from the posterior and represent samples from the predictive distribution.}
\usage{
ppc.step1(y.o, model,
    sample.cov = NULL, sample.mean = NULL, sample.nobs = NULL,
    group = NULL, n.groups, constraints = "", WLS.V = NULL, NACOV = NULL,
    nchains = 2, nadapt = 1000, nburnin=5000, nsample=5000,
    dp = NULL, convergence= "manual",
    imp = NULL, n.r, nsim=5000, post, pT, free.i)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{y.o}{A data frame containing the original data for the replication test.}
  \item{model}{The (b)lavaan model that is to be fitted to the data.}
  \item{sample.cov}{Numeric matrix. A sample variance-covariance matrix. The rownames and/or colnames must contain the observed variable names. For a multiple group analysis, a list with a variance-covariance matrix for each group. Note that if maximum likelihood estimation is used and likelihood="normal", the user provided covariance matrix is internally rescaled by multiplying it with a factor (N-1)/N, to ensure that the covariance matrix has been divided by N. This can be turned off by setting the sample.cov.rescale argument to FALSE.
}
  \item{sample.mean}{A sample mean vector. For a multiple group analysis, a list with a mean vector for each group.}
  \item{sample.nobs}{
Number of observations if the full data frame is missing and only sample moments are given. For a multiple group analysis, a list or a vector with the number of observations for each group.}
  \item{group}{
A variable name in the data frame defining the groups in a multiple group analysis.}
  \item{n.groups}{If applicable, the number of groups.}
  \item{constraints}{
Additional (in)equality constraints not yet included in the model syntax. See model.syntax for more information. Note that the replication hypothesis should not be specified here!}
  \item{WLS.V}{
A user provided weight matrix to be used by estimator "WLS"; if the estimator is "DWLS", only the diagonal of this matrix will be used. For a multiple group analysis, a list with a weight matrix for each group. The elements of the weight matrix should be in the following order (if all data is continuous): first the means (if a meanstructure is involved), then the lower triangular elements of the covariance matrix including the diagonal, ordered column by column. In the categorical case: first the thresholds (including the means for continuous variables), then the slopes (if any), the variances of continuous variables (if any), and finally the lower triangular elements of the correlation/covariance matrix excluding the diagonal, ordered column by column.}
  \item{NACOV}{
A user provided matrix containing the elements of (N times) the asymptotic variance-covariance matrix of the sample statistics. For a multiple group analysis, a list with an asymptotic variance-covariance matrix for each group. See the WLS.V argument for information about the order of the elements.}
  \item{nchains}{A scalar indicating the number of chains to be used in the Bayesian analysis. Default value = 2.}
  \item{nadapt}{The number of blavaan adaptive iterations to use at the start of the simulation. Default value = 1,000}
  \item{nburnin}{A scalar indicating the number of burnin iterations to be used in the Bayesian analysis. Default value = 5,000}
  \item{nsample}{A scalar indicating the number of samples to be taken from the posterior after burnin. Default value = 5,000}
  \item{dp}{blavaan default prior distributions on different types of parameters, typically the result of a call to dpriors(). See the dpriors() help file for more information.}
    \item{convergence}{Default = "manual". If "auto", parameters will be sampled until convergence is achieved (via autorun.jags). In this case, the arguments burnin and sample are passed to autorun.jags as startburnin and startsample, respectively. Otherwise, parameters are sampled as specified by the user (or by the run.jags defaults).}
  \item{imp}{Default = NULL. If imputed data is present, the imputed object of class mids as generated by mice can be included here. }
  \item{n.r}{Sample size for the new data (y.r).}
  \item{nsim}{Number of datasets y.s to be created. Default value = 5,000.}
    \item{post}{Do not use this argument. Matrix with samples from the posterior distribution for the original data y.o}
  \item{pT}{Do not use this argument. The blavaan parameter table. }
  \item{free.i}{Do not use this argument. A vector with indices for the freely estimated parameters as given in pT.}
  }
\value{
\item{pT}{A data.frame containing the parameter table for the fitted model as given by parTable {lavaan}}
\item{y.s}{A list containing all simulated data y.s.}
}
\author{M. A. J. Zondervan-Zwijnenburg}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{bsem}}
}
\examples{
\dontshow{
#step 1 input
data <- data.frame(y=ChickWeight$weight,x=ChickWeight$Time)

model <- '
y ~ x     #regression
y ~1      #intercept not default in lavaan (but is in blavaan)
'

reg.step1 <- ppc.step1(y.o=data, model=model,n.r=10,nadapt=10,nburnin=10,nsample=10,nsim=10)
}
\donttest{
#the following example can be used, but takes >10 seconds

#step 1 input
data <- data.frame(y=ChickWeight$weight,x=ChickWeight$Time)

model <- '
y ~ x     #regression
y ~1      #intercept not default in lavaan (but is in blavaan)
'

reg.step1 <- ppc.step1(y.o=data, model=model,n.r=50)
}
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{htest }% use one of  RShowDoc("KEYWORDS")
\keyword{models }% __ONLY ONE__ keyword per line
