% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuppressDec.R
\name{Z2Yhat}
\alias{Z2Yhat}
\title{Suppressed tabular data: Yhat from X and Z}
\usage{
Z2Yhat(z, x, digits = 9)
}
\arguments{
\item{z}{Z as a matrix}

\item{x}{X as a matrix}

\item{digits}{When non-NULL, output values close to whole numbers will be rounded using 
\code{digits} as input to \code{\link{RoundWhole}}.}
}
\value{
Yhat as a matrix
}
\description{
Implementation of equation 21 in the paper.
}
\details{
Generalized inverse is computed by \code{\link{ginv}}.
In practise, the computations can be speeded up using reduced versions of X and Z. See \code{\link{ReduceX}}.
}
\examples{
# Same data as in the paper
z <- RegSDCdata("sec7z")
x <- RegSDCdata("sec7x")
Z2Yhat(z, x)

# With y known, yHat can be computed in other ways
y <- RegSDCdata("sec7y")  # Now z is t(x) \%*\% y 
fitted(lm(y ~ x - 1))
IpsoExtra(y, x, FALSE, resScale = 0)
}
\seealso{
\code{\link{IpsoExtra}}
}
\author{
Øyvind Langsrud
}
