% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/records.R
\name{records}
\alias{records}
\title{Record values and record times}
\usage{
records(
  X_T,
  plot = TRUE,
  variables = NULL,
  colour = c("black", "skyblue2", "limegreen", "salmon"),
  alpha = c(1, 1, 0.1, 1)
)
}
\arguments{
\item{X_T}{A numeric vector.}

\item{plot}{logical. If \code{TRUE} (the default) the records are plotted.}

\item{variables}{Optional. A matrix, containing other variables related 
to \code{X_T} and measured at the same times. Only used if 
\code{plot = FALSE}.}

\item{colour, alpha}{Character and numeric vectors of length 4, respectively.
This arguments represent respectively the colour and transparency of the
points: trivial record, upper records, observations and lower records, 
respectively.}
}
\value{
If \code{plot = TRUE} a ggplot object, otherwise a list with two 
  data frames where the first column are the record times, the second the 
  record values and, if \code{variables} is not null, the third column are 
  their values at the record times, respectively for upper and lower records.
}
\description{
This function identifies (and plot if argument 
  \code{plot = TRUE}) the record values (\eqn{R_i}), and the record times 
  (\eqn{L_i}) in a vector, for both upper and lower records.
}
\examples{
Y <- c(5, 7, 3, 6, 19, 2, 20)
records(Y, plot = FALSE)

# compute tables
records(TX_Zaragoza$TX, plot = FALSE, variables = TX_Zaragoza$DATE)
# compute plot
records(TX_Zaragoza$TX, alpha = c(1, 1, 0.01, 1))

}
\seealso{
\code{\link{I.record}}, \code{\link{series_double}}, 
  \code{\link{series_rev}}, \code{\link{series_split}}, 
  \code{\link{series_uncor}}, \code{\link{series_untie}}
}
\author{
Jorge Castillo-Mateo
}
