% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N.rec.R
\name{N.rec}
\alias{N.rec}
\alias{N.rec.matrix}
\title{Number of records up to time t}
\usage{
N.rec(X_T, record = "upper")

N.rec.matrix(XM_T, record = "upper")
}
\arguments{
\item{X_T}{A numeric vector.}

\item{record}{A character string indicating the type of record  to be calculated, "upper" or "lower".}

\item{XM_T}{A numeric matrix.}
}
\value{
A numeric vector  with the number of records up to each time (row).
}
\description{
This function calculates  \eqn{N_t},  the number of records  up to time \eqn{t} in a vector.
}
\details{
The function \code{N.rec.matrix} is equivalent to \code{N.rec} but  the input is a matrix, and the previous procedure to obtain
the number of records is applied to each column of the matrix.
In this function, argument \code{X_T} is  a matrix called \code{XM_T}, and
the return value is  a matrix  formed by the output vectors obtained from each column.
}
\examples{
Y1<-c(1,5,3,6,6,9,2)
Y2<-c(10,5,3,6,6,9,2)
Y3<-c(5,7,3,6,19,2,20)
N.rec(Y1)
N.rec.matrix(cbind(Y1,Y2,Y3))

}
\seealso{
\code{\link{Nmean.rec}}, \code{\link{L.rec}}, \code{\link{I.rec}}
}
