% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pcathr.R
\name{est.pcathr}
\alias{est.pcathr}
\title{PCA Thresholding with Accumulated Variance}
\usage{
est.pcathr(X, varratio = 0.95)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{varratio}{target explainability for accumulated variance in \eqn{(0,1)}.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated dimension according to \code{varratio}.}
\item{values}{eigenvalues of sample covariance matrix.}
}
}
\description{
Principal Component Analysis exploits sample covariance matrix whose
eigenvectors and eigenvalues are principal components and projected
variance, correspondingly. Given \code{varratio}, it thresholds the
accumulated variance and selects the estimated dimension. Note that other than
linear submanifold case, the naive selection scheme from this algorithm
lacks flexibility in discovering intrinsic dimension.
}
\examples{
## generate 3-dimensional normal data
X = matrix(rnorm(100*3), nrow=100)

## replicate 3 times with translations
Y = cbind(X-10,X,X+10)

## use PCA thresholding estimation with 95\% variance explainability
## desired return is for dimension 3.
output   = est.pcathr(Y)
pmessage = paste("* estimated dimension is ",output$estdim, sep="")
print(pmessage)

## use screeplot
opar <- par(no.readonly=TRUE)
plot(output$values, main="scree plot", type="b")
par(opar)

}
\seealso{
\code{\link{do.pca}}
}
\author{
Kisung You
}
