% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_ULDA.R
\name{do.ulda}
\alias{do.ulda}
\title{Uncorrelated Linear Discriminant Analysis}
\usage{
do.ulda(
  X,
  label,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "whiten", "decorrelate")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Uncorrelated LDA (ULDA) is an extension of LDA by using the uncorrelated discriminant transformation
and Kahrunen-Loeve expansion of the basis.
}
\examples{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.integer(iris$Species)

## compare with LDA
out1 = do.lda(X, label)
out2 = do.ulda(X, label)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(out1$Y, col=label, main="LDA")
plot(out2$Y, col=label, main="Uncorrelated LDA")
par(opar)

}
\references{
\insertRef{jin_face_2001}{Rdimtools}
}
\seealso{
\code{\link{do.lda}}
}
\author{
Kisung You
}
\concept{linear_methods}
