% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_UDFS.R
\name{do.udfs}
\alias{do.udfs}
\title{Unsupervised Discriminative Features Selection}
\usage{
do.udfs(
  X,
  ndim = 2,
  lbd = 1,
  gamma = 1,
  k = 5,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{lbd}{regularization parameter for local Gram matrix to be invertible.}

\item{gamma}{regularization parameter for row-sparsity via \eqn{\ell_{2,1}} norm.}

\item{k}{size of nearest neighborhood for each data point.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Though it may sound weird, this method aims at finding discriminative features
under the unsupervised learning framework. It assumes that the class label
could be predicted by a linear classifier and iteratively updates its
discriminative nature while attaining row-sparsity scores for selecting features.
}
\examples{
\donttest{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.integer(iris$Species)

#### try different neighborhood size
out1 = do.udfs(X, k=5)
out2 = do.udfs(X, k=10)
out3 = do.udfs(X, k=25)

#### visualize
opar = par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, main="UDFS::k=5")
plot(out2$Y, col=label, main="UDFS::k=10")
plot(out3$Y, col=label, main="UDFS::k=25")
par(opar)
}

}
\references{
\insertRef{yang_l2_2011}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
