% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LSPE.R
\name{do.lspe}
\alias{do.lspe}
\title{Locality and Similarity Preserving Embedding}
\usage{
do.lspe(
  X,
  ndim = 2,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  alpha = 1,
  beta = 1,
  bandwidth = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{alpha}{nonnegative number to control \eqn{\ell_{2,1}} norm of projection.}

\item{beta}{nonnegative number to control the degree of local similarity.}

\item{bandwidth}{positive number for Gaussian kernel bandwidth to define similarity.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Locality and Similarity Preserving Embedding (LSPE) is a feature selection method based on Neighborhood Preserving Embedding (\code{\link{do.npe}}) and
Sparsity Preserving Projection (\code{\link{do.spp}}) by first building a neighborhood graph and
then mapping the locality structure to reconstruct coefficients such that data similarity is preserved.
Use of \eqn{\ell_{2,1}} norm boosts to impose column-sparsity that enables feature selection procedure.
}
\examples{
\donttest{
#### generate R12in72 dataset
X = aux.gensamples(dname="R12in72")

#### try different bandwidth values
out1 = do.lspe(X, bandwidth=0.1)
out2 = do.lspe(X, bandwidth=1)
out3 = do.lspe(X, bandwidth=10)

#### visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="LSPE::bandwidth=0.1")
plot(out2$Y, main="LSPE::bandwidth=1")
plot(out3$Y, main="LSPE::bandwidth=10")
par(opar)
}

}
\references{
\insertRef{fang_locality_2014}{Rdimtools}
}
\seealso{
\code{\link{do.rsr}}
}
\author{
Kisung You
}
