% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createComposeLookup.R
\name{createComposeLookup}
\alias{createComposeLookup}
\title{Creates a set of lookups for SNOMED composition}
\usage{
createComposeLookup(
  decompositions,
  CDB,
  maxcol = 10,
  SNOMED = getSNOMED(),
  ...
)
}
\arguments{
\item{decompositions}{vector of filenames of decompose output (read
by fread) or data.frame containing outputs of decompose function}

\item{CDB}{concept database environment, containing a table called
FINDINGS}

\item{maxcol}{maximum number of attributes columns. If NULL it is
determined from the data. It might be helpful to specify it so that
downstream databases and programs know exactly how many columns to
expect. We suggest setting it to 10 which should handle all 
possible SNOMED CT concept decompositions.}

\item{SNOMED}{environment containing a SNOMED CT dictionary}

\item{...}{other arguments to pass to fread}
}
\value{
data.table
}
\description{
Creates composition lookup table for a set of SNOMED CT concepts
}
\examples{
# Not run

# mylookup <- createComposeLookup(D)
}
\seealso{
decompose, compose, batchDecompose
}
