% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getConfig}
\alias{getConfig}
\title{Return a System Configuration Setting}
\usage{
getConfig(var, path = ".")
}
\arguments{
\item{var}{An character object specifying a value for which configuration
is queried.}

\item{path}{An optional character object specifying a path. Default is the
current directory.}
}
\value{
A result value corresponding to the requested setting. The return
type can be either integer for a numeric value, character for text or NULL
in case to value could be retrieved.
}
\description{
Retrieve one configuration setting
}
\details{
This functions returns the configuration setting for a given input.
in a data.frame object. The system-level functions \code{sysconf},
\code{pathconf} and \code{confstr} provide the underlying information.
}
\examples{
getConfig("_NPROCESSORS_CONF")   # number of processor
getConfig("LEVEL1_ICACHE_SIZE")  # leve1 cache size
getConfig("GNU_LIBC_VERSION")    # libc version
}
\author{
Dirk Eddelbuettel
}
\seealso{
\code{\link{getAll}}
}

