% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_mean_matF.R
\name{cdb_mean_matF}
\alias{cdb_mean_matF}
\title{Calculate a population-specific mean fecundity matrix for each set of
matrices in a COM(P)ADRE database}
\usage{
cdb_mean_matF(
  cdb,
  columns = c("SpeciesAuthor", "MatrixPopulation", "MatrixDimension")
)
}
\arguments{
\item{cdb}{A CompadreDB object}

\item{columns}{Vector of column names from which unique populations should be
identified. Defaults to \code{c("SpeciesAuthor", "MatrixPopulation",
"MatrixDimension")}.}
}
\value{
Returns a list of matrices, representing the mean fecundity matrix
  associated with each row of the database.
}
\description{
Takes a CompadreDB object and calculates a grand mean fecundity matrix for
each unique population (a mean of all population-specific fecundity matrices,
including fecundity matrices for which \code{MatrixComposite == 'Mean'}).

Populations are defined based on unique combinations of the columns
'SpeciesAuthor', 'MatrixPopulation', and 'MatrixDimension', (or optionally, a
different set of columns supplied by the user).

The main purpose of this function is to identify stage classes that are
\emph{potentially} reproductive (i.e. the absence of fecundity in a given
stage class and year does not necessarily indicate that the stage in question
is non-reproductive).
}
\examples{
# print matF associated with row 16 of database
Compadre$mat[[16]]

# create list of meanMatFs
meanF <- cdb_mean_matF(Compadre)

# print meanMatF associated with row 16 of database
meanF[[16]]

}
\seealso{
Other data management: 
\code{\link{cdb_flatten}()},
\code{\link{cdb_id_stages}()},
\code{\link{cdb_id_studies}()},
\code{\link{cdb_id}()},
\code{\link{cdb_rbind}()},
\code{\link{cdb_unflatten}()},
\code{\link{cdb_unnest}()},
\code{\link{mpm_mean}()},
\code{\link{mpm_median}()},
\code{\link{mpm_sd}()},
\code{\link{string_representation}}
}
\author{
Owen R. Jones <jones@biology.sdu.dk>

Danny Buss <dlb50@cam.ac.uk>

Julia Jones <juliajones@biology.sdu.dk>

Iain Stott <stott@biology.sdu.dk>

Patrick Barks <patrick.barks@gmail.com>
}
\concept{data management}
