#' GWRM Plug-In for R Commander
#'
#' @description This package is an R Commander "plug-in" based on the 
#' \code{GWRM} package (see \code{\link{GWRM}}). It provides a GUI for fitting a generalized Waring regression model to a 
#' dataset, together with other common regression functions such as Akaike and 
#' Bayesian information criteria, stepwise model selection or add observation
#' statistics to data. Moreover, it allows for computing the partition of the
#' variance for the selected \code{GW} model and carrying out a graphical diagnosis 
#' by a simulated envelope of the residuals.
#'
#' @details 
#' Package: RcmdrPlugin.GWRM
#' 
#' Type: Package
#' 
#' Title: R Commander Plug-In for Fitting Generalized Waring Regression Models
#' 
#' Version: 1.0.1
#' 
#' Date: 2016-02-18
#' 
#' Depends: R (>= 3.0.0), GWRM (>= 2.1.0.1), RcmdrMisc (>= 1.0-2)
#' 
#' License: GPL (>= 2)
#' 
#' @note Some functions cannot run adequately if there are missing data.
#' 
#' @author Silverio Vilchez-Lopez, Antonio Jose Saez-Castillo and Maria Jose
#' Olmo-Jimenez.
#' Maintainer: Silverio Vilchez-Lopez
#' 
#' @seealso \code{\link{Rcmdr}}
#' 
#' @docType package
#' @name RcmdrPlugin.GWRM
#"_PACKAGE"
#> [1] "_PACKAGE"
NULL
