% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeSpectral.R
\name{spectralEmbeddingNg}
\alias{spectralEmbeddingNg}
\title{Spectral embedding}
\usage{
spectralEmbeddingNg(sim, K)
}
\arguments{
\item{sim}{similarity matrix.}

\item{K}{number of clusters.}
}
\value{
The function returns a list containing:
\item{x}{matrix containing, in columns, the eigenvectors of the similarity matrix.}
\item{eigen.val}{vector containing the eigenvalues of the similarity matrix.}
}
\description{
Build a spectral space from a similarity matrix (according to Ng et al., 2002).
}
\details{
spectralEmbeddingNg returns a spectral space built from a similarity matrix (according to Ng et al., 2002)
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))

sim <- computeGaussianSimilarity(dat, 1)
res <- spectralEmbeddingNg(sim, K=3)

plot(res$x[,2], res$x[,3], type = "p", xlab = "2nd eigenvector", ylab = "3rd eigenvector")
}
\references{
A. Ng, M. Jordan, Y. Weiss, On spectral clustering: Analysis and an algorithm, Neural Inf. Process. Systems NIPS14 (2002), pp. 849-856.
}
\keyword{internal}
