% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean}
\alias{clean}
\title{clean --- Produces more transparent code.
OUTPUT = The essential code needed to produce a result.}
\usage{
clean(result = "Name of desired result", tidy = TRUE)
}
\arguments{
\item{result}{A desired output present in the script.}

\item{tidy}{LOGICAL: should the cleaned script be formatted using syntax best practices?}
}
\value{
Cleaned code as a vector of strings ordered by line number.
}
\description{
Produces simplifed, "cleaned" code that is needed to create a result. 
Make sure that your working directory is set to the location of your script
and that you have loaded data provenance for that script into R's option system, and
Rclean takes care of the rest.
}
\examples{
data(prov_json)
options(prov.json = prov_json)
clean() # Pick from the list of possible results
}
\seealso{
write.code
}
\author{
Matthew K. Lau
}
