% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Rchoice.methods.R
\name{plot.Rchoice}
\alias{plot.Rchoice}
\title{Plot of the distribution of conditional expectation of random parameters.}
\usage{
\method{plot}{Rchoice}(x, par = NULL, effect = c("ce", "cv"), wrt = NULL,
  type = c("density", "histogram"), adjust = 1, main = NULL,
  col = "indianred1", breaks = 10, ylab = NULL, xlab = NULL,
  ind = FALSE, id = NULL, ...)
}
\arguments{
\item{x}{a object of class \code{Rchoice},}

\item{par}{a string giving the name of the variable with random parameter,}

\item{effect}{a string indicating what should be plotted: the conditional expectation of the individual coefficients "\code{ce}", or the conditional expectation of the individual compensating variations "\code{cv}",}

\item{wrt}{a string indicating repect to which variable should be computed the compensating variation,}

\item{type}{a string indicating the type of distribution: it can be a \code{histogram} or a \code{density} of
the conditional expectation,}

\item{adjust}{bandwidth for the kernel density,}

\item{main}{an overall title for the plot,}

\item{col}{color for the graph,}

\item{breaks}{number of breaks for the histrogram if \code{type = "histogram"},}

\item{ylab}{a title for the y axis,}

\item{xlab}{a title for the x axis,}

\item{ind}{a boolean. If \code{TRUE}, a 95% interval of conditional distribution for each individual is plotted.
As default, the conditional expectation of \code{par} for the first 10 individual is plotted,}

\item{id}{only relevant if \code{ind} is not \code{NULL}. This is a vector indicating the individuals for which the confidence intervals are plotted,}

\item{...}{further arguments. Ignored.}
}
\description{
Plot the distribution of the conditional expectation of the random parameters or compensating variations for objects of class \code{Rchoice}.
}
\examples{
\dontrun{
## Probit Model with Random Effects and Random Parameters
data('Unions', package = 'pglm')
Unions$lwage <- log(Unions$wage)
union.ran <- Rchoice(union ~ age + exper + rural + lwage,
                     data = Unions[1:2000, ],
                     family = binomial('probit'),
                     ranp = c(constant = "n", lwage = "t"),
                     R = 10,
                     panel = TRUE,
                     index = "id",
                     print.init = TRUE)

## Plot the distribution of the conditional mean for lwage
plot(union.ran, par = "lwage", type = "density")

## Plot the conditional mean for the first 20 individuals
plot(union.ran, par = "lwage", ind =  TRUE, id = 1:20, col = "blue")

## Plot the compensating variation
plot(union.ran, par = "lwage", effect = "cv", wrt = "rural", type = "histogram")
}
}
\references{
\itemize{
\item Greene, W. H. (2012). Econometric analysis, Seventh Edition. Pearson Hall.
\item Train, K. (2009). Discrete choice methods with simulation. Cambridge university press.
}
}
\seealso{
\code{\link[Rchoice]{Rchoice}} for the estimation of different discrete choice models with individual parameters.
}

