#include "abc_000_warning.h"
#include "abc_001_config.h"
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdio.h>
#ifndef ARM64_OS
	#include <immintrin.h> 
#endif
#include "abc_datatype.h"
#include "abc_blas_lapack_lib.h"
#include "abc_common.h"
#include "abc_ide_util.h"
#include "abc_pthread.h"
#include "abc_timer.h"
#include "beastv2_io.h"
#if !defined(R_RELEASE) && !defined(M_RELEASE) 
#include "mrbeast_header.h"
#include "mrbeast_io.h" 
#include "sbmfast.h"
#include "sbmfast_io.h"
#endif
#include "globalvars.h"
#include "abc_vec.h"
#if   R_INTERFACE==1
	#define IDE_NULL R_NilValue
#elif M_INTERFACE==1
	#define IDE_NULL mxCreateNumericMatrix(0,0,mxSINGLE_CLASS,mxREAL)
#endif
#if defined(WIN64_OS) 
#endif
#include "abc_cpu.h"
#include "abc_timer.h"
#include "abc_rand.h"
#include "math.h"
#ifndef ARM64_OS
	#include "abc_math_avx.h"
#endif
#define IS_STRING_EQUAL(a,b)  (strcicmp(a,b)==0)
#if R_INTERFACE==1 &&  defined(MSVC_COMPILER)
	#include "R_ext\Parse.h"
char R_FUNC[]={ 10,10,112,108,111,116,46,98,101,97,115,116,118,52,32,60,45,32,102,117,110,99,116,105,111,110,40,120,44,32,105,110,100,101,120,49,44,32,105,110,100,101,120,50,44,32,46,46,46,41,32,123,10,32,32,35,115,116,97,99,107,111,118,101,114,102,108,111,119,46,99,111,109,47,113,117,101,115,116,105,111,110,115,47,51,57,54,55,48,54,52,54,47,114,45,103,105,116,104,117,98,45,112,97,99,107,97,103,101,45,119,45,100,101,118,116,111,111,108,115,45,119,97,114,110,105,110,103,45,117,110,107,110,111,119,110,45,109,97,99,114,111,45,105,116,101,109,10,32,32,105,102,32,40,109,105,115,115,105,110,103,40,105,110,100,101,120,49,41,41,32,123,105,110,100,101,120,49,32,61,32,49,59,125,59,10,32,32,105,102,32,40,109,105,115,115,105,110,103,40,105,110,100,101,120,50,41,41,32,123,105,110,100,101,120,50,32,61,32,49,59,125,59,10,32,32,10,32,32,105,110,100,101,120,49,32,61,32,49,59,10,32,32,116,105,100,120,32,32,32,61,32,97,116,116,114,105,98,117,116,101,115,40,120,41,36,119,104,105,99,104,84,105,109,101,59,10,32,32,105,102,32,40,105,115,46,110,117,108,108,40,116,105,100,120,41,41,32,123,116,105,100,120,32,61,32,49,59,125,59,10,32,32,10,32,32,104,97,115,83,101,97,115,111,110,32,61,32,33,105,115,46,110,117,108,108,40,120,36,115,101,97,115,111,110,41,32,38,38,32,33,105,115,46,110,117,108,108,40,120,36,115,101,97,115,111,110,36,89,41,59,10,32,32,10,10,32,32,112,108,111,116,66,69,65,83,84,95,83,84,32,60,45,32,102,117,110,99,116,105,111,110,40,120,44,32,105,110,100,101,120,49,44,32,105,110,100,101,120,50,41,32,123,10,32,32,32,32,10,32,32,32,32,116,105,109,101,32,61,32,120,36,116,105,109,101,91,44,32,49,93,59,10,32,32,32,32,116,50,116,32,32,61,32,99,40,116,105,109,101,44,32,114,101,118,40,116,105,109,101,41,41,59,10,32,32,32,32,78,32,32,32,32,61,32,108,101,110,103,116,104,40,116,105,109,101,41,59,10,32,32,32,32,10,32,32,32,32,108,109,32,61,32,48,46,49,59,32,32,32,114,109,32,61,32,48,46,48,50,59,32,32,116,109,32,61,32,48,46,49,59,32,32,98,109,32,61,32,48,46,49,59,32,32,32,109,109,32,32,61,32,48,46,48,56,59,10,32,32,32,32,119,100,32,61,32,40,49,32,45,32,116,109,32,45,32,98,109,32,45,32,109,109,41,32,47,32,50,59,32,32,119,100,49,32,61,32,119,100,32,42,32,48,46,54,59,32,32,119,100,50,32,61,32,119,100,32,42,32,48,46,52,59,10,32,32,32,32,10,32,32,32,32,35,120,49,49,40,41,32,10,32,32,32,32,35,45,45,84,104,101,32,115,101,97,115,111,110,97,108,32,99,111,109,112,111,101,110,116,45,45,45,35,32,10,32,32,32,32,110,68,105,109,32,61,32,108,101,110,103,116,104,40,100,105,109,40,120,36,116,114,101,110,100,36,89,41,41,59,10,32,32,32,32,105,102,32,40,110,68,105,109,32,61,61,32,50,41,32,123,10,32,32,32,32,32,32,89,32,61,32,120,36,115,101,97,115,111,110,36,89,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,83,68,32,61,32,120,36,115,101,97,115,111,110,36,83,68,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,83,68,91,105,115,46,110,97,110,40,83,68,41,93,32,61,32,48,59,32,32,32,83,68,91,105,115,46,110,97,40,83,68,41,93,32,61,32,48,59,10,32,32,32,32,32,32,89,83,68,32,61,32,99,40,89,32,45,32,83,68,44,32,114,101,118,40,89,32,43,32,83,68,41,41,59,10,32,32,32,32,32,32,80,32,61,32,120,36,115,101,97,115,111,110,36,99,112,79,99,99,80,114,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,99,112,32,61,32,120,36,115,101,97,115,111,110,36,99,112,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,99,112,32,61,32,99,112,91,33,105,115,46,110,97,40,99,112,41,93,59,10,32,32,32,32,32,32,110,99,112,32,61,32,108,101,110,103,116,104,40,99,112,41,59,10,32,32,32,32,125,10,32,32,32,32,101,108,115,101,32,123,10,32,32,32,32,32,32,10,32,32,32,32,125,59,10,32,32,32,32,10,32,32,32,32,10,32,32,32,32,112,97,114,40,112,108,116,32,61,32,99,40,108,109,44,32,49,32,45,32,114,109,44,32,49,32,45,32,116,109,32,45,32,119,100,49,44,32,49,32,45,32,116,109,41,41,59,10,32,32,32,32,112,108,111,116,40,116,50,116,44,32,89,83,68,44,32,116,121,112,101,32,61,32,39,110,39,44,32,97,110,110,32,61,32,70,44,32,120,97,120,116,32,61,32,39,110,39,44,32,121,97,120,116,32,61,32,39,110,39,41,59,10,32,32,32,32,114,101,99,116,40,112,97,114,40,39,117,115,114,39,41,91,49,93,44,32,112,97,114,40,39,117,115,114,39,41,91,51,93,44,32,112,97,114,40,39,117,115,114,39,41,91,50,93,44,32,112,97,114,40,39,117,115,114,39,41,91,52,93,44,32,99,111,108,32,61,32,39,115,107,121,98,108,117,101,39,41,59,10,32,32,32,32,97,120,105,115,40,49,44,32,108,97,98,101,108,115,32,61,32,70,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,97,120,105,115,40,50,44,32,108,97,98,101,108,115,32,61,32,78,85,76,76,44,32,112,97,100,106,32,61,32,49,46,53,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,116,105,116,108,101,40,121,108,97,98,32,61,32,39,83,101,97,115,111,110,97,108,39,44,32,109,103,112,32,61,32,99,40,49,46,50,44,32,48,44,32,48,41,41,59,10,32,32,32,32,112,111,108,121,103,111,110,40,116,50,116,44,32,89,83,68,44,32,99,111,108,32,61,32,39,35,66,52,66,52,66,52,39,44,32,98,111,114,100,101,114,32,61,32,39,35,56,52,56,52,56,52,39,41,59,10,32,32,32,32,35,112,97,114,40,110,101,119,32,61,32,84,82,85,69,41,59,92,110,10,32,32,32,32,112,111,105,110,116,115,40,116,105,109,101,44,32,89,44,32,116,121,112,101,32,61,32,39,108,39,44,32,99,111,108,32,61,32,39,114,101,100,39,44,32,120,108,97,98,32,61,32,78,85,76,76,44,32,108,119,100,32,61,32,50,44,32,97,110,110,32,61,32,70,65,76,83,69,44,32,98,103,32,61,32,39,114,101,100,39,41,59,10,32,32,32,32,35,116,101,120,116,40,109,101,97,110,40,116,105,109,101,41,32,47,32,50,46,48,44,32,39,78,79,32,83,69,65,83,79,78,65,76,32,67,79,77,80,79,78,69,84,46,73,71,78,79,82,69,32,84,72,73,83,32,80,79,76,79,84,39,41,59,92,110,10,32,32,32,32,115,116,114,61,112,97,115,116,101,40,97,115,46,99,104,97,114,97,99,116,101,114,40,97,115,46,105,110,116,101,103,101,114,40,120,36,115,101,97,115,111,110,36,110,99,112,42,49,48,48,41,47,49,48,48,41,44,32,32,97,115,46,99,104,97,114,97,99,116,101,114,40,97,115,46,105,110,116,101,103,101,114,40,120,36,116,114,101,110,100,36,110,99,112,42,49,48,48,41,47,49,48,48,41,41,59,10,32,32,32,32,116,105,116,108,101,40,109,97,105,110,32,61,32,115,116,114,41,59,10,32,32,32,32,10,32,32,32,32,105,102,32,40,110,99,112,32,62,32,48,41,32,123,10,32,32,32,32,32,32,102,111,114,32,40,105,32,105,110,32,49,32,58,32,110,99,112,41,32,123,10,32,32,32,32,32,32,32,32,99,112,116,32,61,32,99,112,91,105,93,59,10,32,32,32,32,32,32,32,32,112,111,105,110,116,115,40,99,40,99,112,116,44,32,99,112,116,41,44,32,99,40,112,97,114,40,39,117,115,114,39,41,91,51,93,44,32,112,97,114,40,39,117,115,114,39,41,91,52,93,41,44,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,116,121,112,101,32,61,32,39,108,39,44,32,108,116,121,32,61,32,39,100,97,115,104,101,100,39,44,32,99,111,108,32,61,32,39,103,114,101,121,49,48,39,44,32,120,108,97,98,32,61,32,78,85,76,76,44,32,108,119,100,32,61,32,50,44,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,97,110,110,32,61,32,70,65,76,83,69,44,32,98,103,32,61,32,39,103,114,101,121,49,48,39,41,59,10,32,32,32,32,32,32,125,10,32,32,32,32,125,59,10,32,32,32,32,10,32,32,32,32,112,97,114,40,112,108,116,32,61,32,99,40,108,109,44,32,49,32,45,32,114,109,44,32,49,32,45,32,116,109,32,45,32,119,100,44,32,49,32,45,32,116,109,32,45,32,119,100,49,41,44,32,110,101,119,32,61,32,84,82,85,69,41,59,10,32,32,32,32,112,108,111,116,40,116,105,109,101,44,32,80,44,32,116,121,112,101,32,61,32,39,110,39,44,32,97,110,110,32,61,32,70,44,32,120,97,120,116,32,61,32,39,110,39,44,32,121,97,120,116,32,61,32,39,110,39,41,59,10,32,32,32,32,114,101,99,116,40,112,97,114,40,39,117,115,114,39,41,91,49,93,44,32,112,97,114,40,39,117,115,114,39,41,91,51,93,44,32,112,97,114,40,39,117,115,114,39,41,91,50,93,44,32,112,97,114,40,39,117,115,114,39,41,91,52,93,44,32,99,111,108,32,61,32,39,115,107,121,98,108,117,101,39,41,59,10,32,32,32,32,112,97,114,40,110,101,119,32,61,32,84,82,85,69,41,59,10,32,32,32,32,112,108,111,116,40,116,105,109,101,44,32,80,44,32,120,108,97,98,32,61,32,39,39,44,32,121,108,97,98,32,61,32,39,39,44,32,116,121,112,101,32,61,32,39,108,39,44,32,99,111,108,32,61,32,39,98,108,97,99,107,39,44,32,108,119,100,32,61,32,50,44,32,120,97,120,116,32,61,32,39,110,39,44,32,121,97,120,116,32,61,32,39,110,39,41,59,10,32,32,32,32,97,120,105,115,40,49,44,32,108,97,98,101,108,115,32,61,32,78,85,76,76,44,32,112,97,100,106,32,61,32,45,49,46,53,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,97,120,105,115,40,50,44,32,108,97,98,101,108,115,32,61,32,78,85,76,76,44,32,112,97,100,106,32,61,32,49,46,53,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,116,105,116,108,101,40,120,108,97,98,32,61,32,39,84,105,109,101,39,44,32,121,108,97,98,32,61,32,39,80,114,111,98,39,44,32,109,103,112,32,61,32,99,40,49,46,50,44,32,49,46,50,44,32,48,41,41,59,10,32,32,32,32,116,101,120,116,40,109,101,97,110,40,116,105,109,101,41,32,47,32,50,46,48,44,32,39,78,79,32,83,69,65,83,79,78,65,76,32,67,79,77,80,79,78,69,84,46,73,71,78,79,82,69,32,84,72,73,83,32,80,79,76,79,84,39,41,59,10,32,32,32,32,10,32,32,32,32,10,32,32,32,32,35,45,45,84,104,101,32,116,114,101,110,100,32,99,111,109,112,111,101,110,116,45,45,45,35,92,110,10,32,32,32,32,10,32,32,32,32,105,102,32,40,110,68,105,109,32,61,61,32,50,41,32,123,10,32,32,32,32,32,32,89,32,61,32,120,36,116,114,101,110,100,36,89,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,83,68,32,61,32,120,36,116,114,101,110,100,36,83,68,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,83,68,91,105,115,46,110,97,110,40,83,68,41,93,32,61,32,48,59,32,32,32,83,68,91,105,115,46,110,97,40,83,68,41,93,32,61,32,48,59,10,32,32,32,32,32,32,89,83,68,32,61,32,99,40,89,32,45,32,83,68,44,32,114,101,118,40,89,32,43,32,83,68,41,41,59,10,32,32,32,32,32,32,80,32,61,32,120,36,116,114,101,110,100,36,99,112,79,99,99,80,114,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,99,112,32,61,32,120,36,116,114,101,110,100,36,99,112,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,99,112,32,61,32,99,112,91,33,105,115,46,110,97,40,99,112,41,93,59,10,32,32,32,32,32,32,110,99,112,32,61,32,108,101,110,103,116,104,40,99,112,41,59,10,32,32,32,32,125,10,32,32,32,32,101,108,115,101,32,123,10,32,32,32,32,32,32,10,32,32,32,32,125,59,10,32,32,32,32,10,32,32,32,32,112,97,114,40,112,108,116,32,61,32,99,40,108,109,44,32,49,32,45,32,114,109,44,32,49,32,45,32,116,109,32,45,32,119,100,32,45,32,109,109,32,45,32,119,100,49,44,32,49,32,45,32,116,109,32,45,32,119,100,32,45,32,109,109,41,44,32,110,101,119,32,61,32,84,82,85,69,41,59,10,32,32,32,32,112,108,111,116,40,116,50,116,44,32,89,83,68,44,32,116,121,112,101,32,61,32,39,110,39,44,32,97,110,110,32,61,32,70,44,32,120,97,120,116,32,61,32,39,110,39,44,32,121,97,120,116,32,61,32,39,110,39,41,59,10,32,32,32,32,114,101,99,116,40,112,97,114,40,39,117,115,114,39,41,91,49,93,44,32,112,97,114,40,39,117,115,114,39,41,91,51,93,44,32,112,97,114,40,39,117,115,114,39,41,91,50,93,44,32,112,97,114,40,39,117,115,114,39,41,91,52,93,44,32,99,111,108,32,61,32,39,100,97,114,107,111,108,105,118,101,103,114,101,101,110,51,39,41,59,10,32,32,32,32,97,120,105,115,40,49,44,32,108,97,98,101,108,115,32,61,32,70,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,97,120,105,115,40,50,44,32,108,97,98,101,108,115,32,61,32,78,85,76,76,44,32,112,97,100,106,32,61,32,49,46,53,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,116,105,116,108,101,40,121,108,97,98,32,61,32,39,84,114,101,110,100,39,44,32,109,103,112,32,61,32,99,40,49,46,50,44,32,48,44,32,48,41,41,59,10,32,32,32,32,112,111,108,121,103,111,110,40,116,50,116,44,32,89,83,68,44,32,99,111,108,32,61,32,39,35,66,52,66,52,66,52,39,44,32,98,111,114,100,101,114,32,61,32,39,35,56,52,56,52,56,52,39,41,59,32,10,32,32,32,32,35,112,97,114,40,110,101,119,32,61,32,84,82,85,69,41,92,110,10,32,32,32,32,112,111,105,110,116,115,40,116,105,109,101,44,32,89,44,32,116,121,112,101,32,61,32,39,108,39,44,32,99,111,108,32,61,32,39,114,101,100,39,44,32,120,108,97,98,32,61,32,78,85,76,76,44,32,108,119,100,32,61,32,50,44,32,97,110,110,32,61,32,70,65,76,83,69,44,32,98,103,32,61,32,39,114,101,100,39,41,59,10,32,32,32,32,10,32,32,32,32,105,102,32,40,110,99,112,32,62,32,48,41,32,123,10,32,32,32,32,32,32,102,111,114,32,40,105,32,105,110,32,49,32,58,32,110,99,112,41,32,123,10,32,32,32,32,32,32,32,32,99,112,116,32,61,32,99,112,91,105,93,59,10,32,32,32,32,32,32,32,32,112,111,105,110,116,115,40,99,40,99,112,116,44,32,99,112,116,41,44,32,99,40,112,97,114,40,39,117,115,114,39,41,91,51,93,44,32,112,97,114,40,39,117,115,114,39,41,91,52,93,41,44,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,116,121,112,101,32,61,32,39,108,39,44,32,108,116,121,32,61,32,39,100,97,115,104,101,100,39,44,32,99,111,108,32,61,32,39,103,114,101,121,49,48,39,44,32,120,108,97,98,32,61,32,78,85,76,76,44,32,108,119,100,32,61,32,50,44,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,97,110,110,32,61,32,70,65,76,83,69,44,32,98,103,32,61,32,39,103,114,101,121,49,48,39,41,59,10,32,32,32,32,32,32,125,10,32,32,32,32,125,59,10,32,32,32,32,10,32,32,32,32,10,32,32,32,32,112,97,114,40,112,108,116,32,61,32,99,40,108,109,44,32,49,32,45,32,114,109,44,32,98,109,44,32,98,109,32,43,32,119,100,50,41,44,32,110,101,119,32,61,32,84,82,85,69,41,59,10,32,32,32,32,112,108,111,116,40,116,105,109,101,44,32,80,44,32,116,121,112,101,32,61,32,39,110,39,44,32,97,110,110,32,61,32,70,44,32,120,97,120,116,32,61,32,39,110,39,44,32,121,97,120,116,32,61,32,39,110,39,41,59,10,32,32,32,32,114,101,99,116,40,112,97,114,40,39,117,115,114,39,41,91,49,93,44,32,112,97,114,40,39,117,115,114,39,41,91,51,93,44,32,112,97,114,40,39,117,115,114,39,41,91,50,93,44,32,112,97,114,40,39,117,115,114,39,41,91,52,93,44,32,99,111,108,32,61,32,39,100,97,114,107,111,108,105,118,101,103,114,101,101,110,51,39,41,59,10,32,32,32,32,112,97,114,40,110,101,119,32,61,32,84,82,85,69,41,59,10,32,32,32,32,112,108,111,116,40,116,105,109,101,44,32,80,44,32,120,108,97,98,32,61,32,39,39,44,121,108,97,98,32,61,32,39,39,44,32,116,121,112,101,32,61,32,39,108,39,44,32,99,111,108,32,61,32,39,98,108,97,99,107,39,44,32,108,119,100,32,61,32,50,44,32,120,97,120,116,32,61,32,39,110,39,44,32,121,97,120,116,32,61,32,39,110,39,41,59,10,32,32,32,32,97,120,105,115,40,49,44,32,108,97,98,101,108,115,32,61,32,78,85,76,76,44,32,112,97,100,106,32,61,32,45,49,46,53,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,97,120,105,115,40,50,44,32,108,97,98,101,108,115,32,61,32,78,85,76,76,44,32,112,97,100,106,32,61,32,49,46,53,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,116,105,116,108,101,40,120,108,97,98,32,61,32,39,84,105,109,101,39,44,32,121,108,97,98,32,61,32,39,80,114,111,98,39,44,32,109,103,112,32,61,32,99,40,49,46,50,44,32,49,46,50,44,32,48,41,41,59,10,32,32,125,59,10,32,32,10,32,32,10,32,32,112,108,111,116,66,69,65,83,84,95,84,32,60,45,32,102,117,110,99,116,105,111,110,40,120,44,32,105,110,100,101,120,49,44,32,105,110,100,101,120,50,41,32,123,10,32,32,32,32,10,32,32,32,32,116,105,109,101,32,61,32,120,36,116,105,109,101,91,44,32,49,93,59,10,32,32,32,32,116,50,116,32,32,61,32,99,40,116,105,109,101,44,32,114,101,118,40,116,105,109,101,41,41,59,10,32,32,32,32,78,32,32,32,32,61,32,108,101,110,103,116,104,40,116,105,109,101,41,59,10,32,32,32,32,10,32,32,32,32,108,109,32,61,32,48,46,49,59,32,32,32,114,109,32,61,32,48,46,48,50,59,32,32,116,109,32,61,32,48,46,49,59,32,32,98,109,32,61,32,48,46,49,59,32,32,32,109,109,32,32,61,32,48,46,48,48,59,10,32,32,32,32,119,100,32,61,32,40,49,45,116,109,45,98,109,45,109,109,41,32,59,32,32,119,100,49,32,61,32,119,100,32,42,32,48,46,54,59,32,32,119,100,50,32,61,32,119,100,32,42,32,48,46,52,59,32,35,77,111,100,102,105,101,100,32,102,111,114,32,116,114,101,110,100,10,32,32,32,32,10,32,32,32,32,35,120,49,49,40,41,32,10,32,32,32,32,110,68,105,109,32,61,32,108,101,110,103,116,104,40,100,105,109,40,120,36,116,114,101,110,100,36,89,41,41,59,10,32,32,32,32,35,45,45,84,104,101,32,116,114,101,110,100,32,99,111,109,112,111,101,110,116,45,45,45,35,92,110,10,32,32,32,32,105,102,32,40,110,68,105,109,32,61,61,32,50,41,32,123,10,32,32,32,32,32,32,89,32,61,32,120,36,116,114,101,110,100,36,89,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,83,68,32,61,32,120,36,116,114,101,110,100,36,83,68,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,83,68,91,105,115,46,110,97,110,40,83,68,41,93,32,61,32,48,59,32,32,32,83,68,91,105,115,46,110,97,40,83,68,41,93,32,61,32,48,59,10,32,32,32,32,32,32,89,83,68,32,61,32,99,40,89,32,45,32,83,68,44,32,114,101,118,40,89,32,43,32,83,68,41,41,59,10,32,32,32,32,32,32,80,32,61,32,120,36,116,114,101,110,100,36,99,112,79,99,99,80,114,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,99,112,32,61,32,120,36,116,114,101,110,100,36,99,112,91,44,32,105,110,100,101,120,49,93,59,10,32,32,32,32,32,32,99,112,32,61,32,99,112,91,33,105,115,46,110,97,40,99,112,41,93,59,10,32,32,32,32,32,32,110,99,112,32,61,32,108,101,110,103,116,104,40,99,112,41,59,10,32,32,32,32,125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,10,32,32,32,32,125,59,10,32,32,32,32,10,32,32,32,32,35,99,40,108,101,102,116,44,32,114,105,103,104,116,44,32,98,111,116,44,32,116,111,112,41,10,32,32,32,32,112,97,114,40,112,108,116,32,61,32,99,40,108,109,44,32,49,32,45,32,114,109,44,32,98,109,43,109,109,43,119,100,50,44,32,49,32,45,32,116,109,41,41,59,32,35,77,111,100,105,102,105,101,100,32,102,111,114,32,116,114,101,110,100,10,32,32,32,32,35,112,97,114,40,112,108,116,32,61,32,99,40,108,109,44,32,49,32,45,32,114,109,44,32,98,109,43,109,109,43,119,100,50,44,32,49,32,45,32,116,109,41,44,32,110,101,119,32,61,32,84,82,85,69,41,59,32,35,77,111,100,105,102,105,101,100,32,102,111,114,32,116,114,101,110,100,10,32,32,32,32,112,108,111,116,40,116,50,116,44,32,89,83,68,44,32,116,121,112,101,32,61,32,39,110,39,44,32,97,110,110,32,61,32,70,44,32,120,97,120,116,32,61,32,39,110,39,44,32,121,97,120,116,32,61,32,39,110,39,41,59,10,32,32,32,32,114,101,99,116,40,112,97,114,40,39,117,115,114,39,41,91,49,93,44,32,112,97,114,40,39,117,115,114,39,41,91,51,93,44,32,112,97,114,40,39,117,115,114,39,41,91,50,93,44,32,112,97,114,40,39,117,115,114,39,41,91,52,93,44,32,99,111,108,32,61,32,39,100,97,114,107,111,108,105,118,101,103,114,101,101,110,51,39,41,59,10,32,32,32,32,97,120,105,115,40,49,44,32,108,97,98,101,108,115,32,61,32,70,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,97,120,105,115,40,50,44,32,108,97,98,101,108,115,32,61,32,78,85,76,76,44,32,112,97,100,106,32,61,32,49,46,53,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,116,105,116,108,101,40,121,108,97,98,32,61,32,39,84,114,101,110,100,39,44,32,109,103,112,32,61,32,99,40,49,46,50,44,32,48,44,32,48,41,41,59,10,32,32,32,32,112,111,108,121,103,111,110,40,116,50,116,44,32,89,83,68,44,32,99,111,108,32,61,32,39,35,66,52,66,52,66,52,39,44,32,98,111,114,100,101,114,32,61,32,39,35,56,52,56,52,56,52,39,41,59,32,10,32,32,32,32,35,112,97,114,40,110,101,119,32,61,32,84,82,85,69,41,92,110,10,32,32,32,32,112,111,105,110,116,115,40,116,105,109,101,44,32,89,44,32,116,121,112,101,32,61,32,39,108,39,44,32,99,111,108,32,61,32,39,114,101,100,39,44,32,120,108,97,98,32,61,32,78,85,76,76,44,32,108,119,100,32,61,32,50,44,32,97,110,110,32,61,32,70,65,76,83,69,44,32,98,103,32,61,32,39,114,101,100,39,41,59,10,32,32,32,32,10,32,32,32,32,105,102,32,40,110,99,112,32,62,32,48,41,32,123,10,32,32,32,32,32,32,102,111,114,32,40,105,32,105,110,32,49,32,58,32,110,99,112,41,32,123,10,32,32,32,32,32,32,32,32,99,112,116,32,61,32,99,112,91,105,93,59,10,32,32,32,32,32,32,32,32,112,111,105,110,116,115,40,99,40,99,112,116,44,32,99,112,116,41,44,32,99,40,112,97,114,40,39,117,115,114,39,41,91,51,93,44,32,112,97,114,40,39,117,115,114,39,41,91,52,93,41,44,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,116,121,112,101,32,61,32,39,108,39,44,32,108,116,121,32,61,32,39,100,97,115,104,101,100,39,44,32,99,111,108,32,61,32,39,103,114,101,121,49,48,39,44,32,120,108,97,98,32,61,32,78,85,76,76,44,32,108,119,100,32,61,32,50,44,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,97,110,110,32,61,32,70,65,76,83,69,44,32,98,103,32,61,32,39,103,114,101,121,49,48,39,41,59,10,32,32,32,32,32,32,125,10,32,32,32,32,125,59,10,32,32,32,32,10,32,32,32,32,10,32,32,32,32,112,97,114,40,112,108,116,32,61,32,99,40,108,109,44,32,49,32,45,32,114,109,44,32,98,109,44,32,98,109,43,119,100,50,41,44,32,110,101,119,32,61,32,84,82,85,69,41,59,10,32,32,32,32,112,108,111,116,40,116,105,109,101,44,32,80,44,32,116,121,112,101,32,61,32,39,110,39,44,32,97,110,110,32,61,32,70,44,32,120,97,120,116,32,61,32,39,110,39,44,32,121,97,120,116,32,61,32,39,110,39,41,59,10,32,32,32,32,114,101,99,116,40,112,97,114,40,39,117,115,114,39,41,91,49,93,44,32,112,97,114,40,39,117,115,114,39,41,91,51,93,44,32,112,97,114,40,39,117,115,114,39,41,91,50,93,44,32,112,97,114,40,39,117,115,114,39,41,91,52,93,44,32,99,111,108,32,61,32,39,100,97,114,107,111,108,105,118,101,103,114,101,101,110,51,39,41,59,10,32,32,32,32,112,97,114,40,110,101,119,32,61,32,84,82,85,69,41,59,10,32,32,32,32,112,108,111,116,40,116,105,109,101,44,32,80,44,32,120,108,97,98,32,61,32,39,39,44,121,108,97,98,32,61,32,39,39,44,32,116,121,112,101,32,61,32,39,108,39,44,32,99,111,108,32,61,32,39,98,108,97,99,107,39,44,32,108,119,100,32,61,32,50,44,32,120,97,120,116,32,61,32,39,110,39,44,32,121,97,120,116,32,61,32,39,110,39,41,59,10,32,32,32,32,97,120,105,115,40,49,44,32,108,97,98,101,108,115,32,61,32,78,85,76,76,44,32,112,97,100,106,32,61,32,45,49,46,53,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,97,120,105,115,40,50,44,32,108,97,98,101,108,115,32,61,32,78,85,76,76,44,32,112,97,100,106,32,61,32,49,46,53,44,32,116,99,108,32,61,32,48,46,50,53,41,59,10,32,32,32,32,116,105,116,108,101,40,120,108,97,98,32,61,32,39,84,105,109,101,39,44,32,121,108,97,98,32,61,32,39,80,114,111,98,39,44,32,109,103,112,32,61,32,99,40,49,46,50,44,32,49,46,50,44,32,48,41,41,59,10,32,32,125,59,32,32,10,32,32,10,32,32,10,32,32,105,102,40,104,97,115,83,101,97,115,111,110,41,123,10,32,32,32,32,112,108,111,116,66,69,65,83,84,95,83,84,40,120,44,105,110,100,101,120,49,44,105,110,100,101,120,50,41,59,10,32,32,125,32,101,108,115,101,123,10,32,32,32,32,112,108,111,116,66,69,65,83,84,95,84,40,120,44,105,110,100,101,120,49,44,105,110,100,101,120,50,41,59,10,32,32,125,10,10,125,59,10,10 };
#endif
static void SetupRoutinesByCPU() {
	if (IS_CPU_INSTRUCTON_SET) return;
	 r_printf("On the first run,check the CPU instruction set ... \n\n");
	 struct cpu_x86 cpuinfo;
	 detect_host(&cpuinfo);
	 printinfo(&cpuinfo);
	 i386_cpuid_caches();
#if !defined(SOLARIS_COMPILER) && defined(TARGET_64) && !defined(ARM64_OS)
		 if (cpuinfo.HW_AVX512_F  && cpuinfo.HW_AVX512_BW && cpuinfo.HW_AVX512_DQ && cpuinfo.HW_AVX512_VL) {
			 SetupVectorFunction_AVX512();
			 SetupPCG_AVX512();
			 r_printf("CPU checking result: The AVX512-enabled library is used ... \n\n");
		 }
		 else if (cpuinfo.HW_AVX &&cpuinfo.HW_AVX2 && cpuinfo.HW_FMA3) {
			 SetupVectorFunction_AVX2();
			 SetupPCG_AVX2();
			 r_printf("CPU checking result: The AVX2-enabled library is used ...\n\n");
		 }
		 else {
			 SetupVectorFunction_Generic();
			 SetupPCG_GENERIC();
			 r_printf("CPU checking result: No AVX2/AVX512 is supported and the default library is used ...\n\n");
		 }
	#else
		 SetupVectorFunction_Generic();
		 SetupPCG_GENERIC();
		 r_printf("No AVX2 is supported and the default library is used ...");	
	#endif
	IS_CPU_INSTRUCTON_SET=1;
}
void TestCode() {
	F32 a[115500];
	F32 b[115500];
	F32 c[115500];
	F32 c1[5500];
	F32 c2[5500];
	I08 c3[5500];
	I32 N=100;
	I32 M=60000;
	void avx2_f32_gemv_Xy1x1(int N,int K,F32PTR X,int lda,F32PTR y,F32PTR C);
	void avx2_f32_gemm_XY1x2(int M,int N,int K,F32PTR A,int lda,F32PTR B,int ldb,F32PTR C,int ldc);	
	I32  gen_f32_scatter_vec_byindex(F32PTR  x,I32PTR indices,F32PTR values,int N);
	I32  avx2_f32_scatter_vec_byindex(F32PTR  x,I32PTR indices,F32PTR values,int N);
	void avx2_f32_gatherVec_scatterVal_byindex(F32PTR  x,I32PTR indices,F32PTR values,F32 newValue,int N);
	void gen_f32_gatherVec_scatterVal_byindex(F32PTR  x,I32PTR indices,F32PTR values,F32 newValue,int N);
	void gen_f32_gather2Vec_scatterVal_byindex(F32PTR  x,F32PTR  y,I32PTR indices,F32PTR values,F32 newValue,int N);
	void avx2_f32_gather2Vec_scatterVal_byindex(F32PTR  x,F32PTR  y,I32PTR indices,F32PTR values,F32 newValue,int N);
	f32_findindex(a,c1,10,1000,CMP_LT);
	void avx2_f32_memcpy(const I32PTR dst,const I32PTR src,const int N);
	F32 res=10;
	I32 idx=0;
	for (int i=0; i <=100; i++) {
		memcpy(a,b,sizeof(F32) * 10000);
	}
	tic();
	for (int i=0; i <=M; i++) {
		memcpy(a,b,sizeof(F32) * 10000);
	}
	I64 t1=toc();
	for (int i=0; i <=100; i++) {
		int m=1000;
		int r=1;
	}
	tic();
	for (int i=0; i <=M; i++) {
	}
	I64 t2=toc();
	for (int i=0; i < 40; i++) {
		r_printf("%d %d|%d\n",c1[i],c2[i],c1[i] - c2[i]);
	}
	r_printf("\nMat %f,%f: %f\n",(F64)t1,(F64)t2,(F64)t1/t2);
	r_printf("\nMat %f,%f: %f\n",(F64)t1,(F64)t2,(F64)t1/t2);
	pcg_set_seed(333,0);
	tic();
	M=2000;
	for (int i=10; i < 1000; i++)	pcg_gauss(a,M);
	t1=toc();
}
void * mainFunction(void *prhs[],int nrhs) {
	#if R_INTERFACE==1 &&  defined(MSVC_COMPILER)
		SEXP tmp,e;
		ParseStatus status;
		PROTECT(tmp=mkString(R_FUNC));
		PROTECT(e=R_ParseVector(tmp,1,&status,R_NilValue));
		UNPROTECT(2);
	#endif
#if !defined(SOLARIS_COMPILER) && defined(TARGET_64) && !defined(ARM64_OS)
		if (nrhs >=7) {
			int avxOption=GetScalar(prhs[nrhs - 1]);
			if (avxOption==1) {
				SetupVectorFunction_Generic();
				SetupPCG_GENERIC();
			}
			else if (avxOption==2) {
				SetupVectorFunction_AVX2();
				SetupPCG_AVX2();
			}
			else if (avxOption==3) {
				SetupVectorFunction_AVX512();
				SetupPCG_AVX512();
			}
			else {
				SetupRoutinesByCPU();
			}
		}
		else {
			SetupRoutinesByCPU();
		}
#else
		SetupVectorFunction_Generic();
		SetupPCG_GENERIC();
#endif
	if (nrhs==0 ) 	{
		r_error("ERROR: Essential input paramaters are missing!\n");
		return IDE_NULL;
	}
	if ( !IsChar(prhs[0]) )	{
		r_error("ERROR: The very first parameter must be a string specifying the algorithm name!\n");
		return IDE_NULL;
	}
	#define STRING_LEN 20
	char  algorithm[STRING_LEN+1];
	GetCharArray(prhs[0],algorithm,STRING_LEN);
	void * ANS=NULL;
	int    nptr=0;
	if      (IS_STRING_EQUAL(algorithm,"beastv4Demo"))
	{
		BEAST2_OPTIONS      option={ {{0,},},}; 
		option.io.out.result=NULL;		
		GLOBAL_OPTIONS=(BEAST2_OPTIONS_PTR)&option;
		if ( BEAST2_GetArgs(prhs,nrhs,&option)==0 ) {
			BEAST2_DeallocateTimeSeriesIO(&(option.io));
			return IDE_NULL;
		}
		#ifdef WIN64_OS
			option.extra.computeCredible=TRUE;
			ANS=PROTECT(BEAST2_Output_AllocMEM(&option)); nptr++;
			void DllExport BEAST2_WinMain(VOID_PTR  option);
			BEAST2_WinMain((BEAST2_OPTIONS_PTR)GLOBAL_OPTIONS);
		#else
			r_printf("WARNING: The GUI interface is supporte only on the Windows 64 operating system.\n");
		#endif	
		BEAST2_DeallocateTimeSeriesIO(&(option.io));
	}
	else if (IS_STRING_EQUAL(algorithm,"beastv4"))
	{
		BEAST2_OPTIONS      option={ {{0,},},}; 
		if (BEAST2_GetArgs(prhs,nrhs,&option)==0) {
			BEAST2_DeallocateTimeSeriesIO(&(option.io));
			return IDE_NULL;
		}		
		option.io.out.result=NULL;		 	
		if (option.io.q==1) {
			ANS=PROTECT(BEAST2_Output_AllocMEM(&option)); nptr++;	
		} else {			
			option.extra.computeSeasonAmp=0;
			option.extra.computeTrendSlope=0;
			option.extra.tallyIncDecTrendJump=0;
			option.extra.tallyPosNegTrendJump=0;
			option.extra.tallyPosNegOutliers=0;
			option.extra.tallyPosNegSeasonJump=0;
			option.extra.computeTrendChngpt=1;
			option.extra.computeSeasonChngpt=1;
			BEAST2_print_options(&option); 
			ANS=PROTECT(BEAST2_Output_AllocMEM(&option)); nptr++;
		}
		GLOBAL_OPTIONS=(BEAST2_OPTIONS_PTR)&option;
		if (option.io.numOfPixels==1) {
			beast2_main_corev4();
			BEAST2_DeallocateTimeSeriesIO(&(option.io));
			r_printf("\n");
		} else {
			I32 NUM_THREADS=option.extra.numParThreads;  
			I32 NUM_CORES=GetNumCores();
			I32 NUM_THREADS_PER_CPU=option.extra.numThreadsPerCPU;
			NUM_CORES=max(NUM_CORES,1L);			
			NUM_THREADS_PER_CPU=max(NUM_THREADS_PER_CPU,1L);
			NUM_THREADS=(NUM_THREADS <=0) ? NUM_CORES * NUM_THREADS_PER_CPU : NUM_THREADS;
			NUM_THREADS=min(NUM_THREADS,option.io.numOfPixels);
			NUM_OF_PROCESSED_PIXELS=0;
			NUM_OF_PROCESSED_GOOD_PIXELS=0;
			NEXT_PIXEL_INDEX=1;
			pthread_mutex_init(&mutex,NULL); 
			pthread_cond_init(&condVar,NULL);
			pthread_attr_t attr;
			pthread_attr_init(&attr);
			pthread_attr_setdetachstate(&attr,PTHREAD_CREATE_JOINABLE);
			thread_id=malloc(sizeof(pthread_t) * NUM_THREADS); 
			extern int beast2_main_corev4_mthrd(void* dummy);
			for (I32 i=0; i < NUM_THREADS; i++) {
             #if defined(LINUX_OS)||defined (WIN32_OS)||defined (WIN64_OS) 
				cpu_set_t cpuset;
				CPU_ZERO(&cpuset);
				CPU_SET(i,&cpuset);
				pthread_attr_setaffinity_np(&attr,sizeof(cpu_set_t),&cpuset);
				pthread_create(&thread_id[i],&attr,beast2_main_corev4_mthrd,(void*)NULL);
			 #elif defined(MAC_OS)
				cpu_set_t cpuset;
				CPU_ZERO(&cpuset);
				CPU_SET(i,&cpuset);
				pthread_create(&thread_id[i],&attr,beast2_main_corev4_mthrd,(void*)NULL);
				pthread_setaffinity_np(thread_id[i],sizeof(cpu_set_t),&cpuset);
		     #elif defined (SOLARIS_OS)
				cpu_set_t cpuset;
				CPU_ZERO(&cpuset);
				CPU_SET(i,&cpuset);
				pthread_create(&thread_id[i],&attr,beast2_main_corev4_mthrd,(void*)NULL);
				sched_getaffinity(thread_id[i],sizeof(cpu_set_t),&cpuset);
			 #else
				pthread_create(&thread_id[i],&attr,beast2_main_corev4_mthrd,(void*)NULL);
			 #endif
				r_printf("Parallel computing: thread#%-02d generated ... \n",i+1);
			}
			r_printf("Rbeast: Waiting on %d threads...\n",NUM_THREADS);
			pthread_attr_destroy(&attr);
			IDE_USER_INTERRUPT=0;
			#if R_INTERACE==1
				r_printf("Press and hold the ESCAPE key or the STOP button to interrupt and quit while running.\n" );
			#elif M_INTERFACE==1
				r_printf("Press and hold CTR+C to interrupt and quit while running.\n");
			#endif
			if (option.extra.printProgressBar) {
				void* BUF=malloc(option.extra.consoleWidth* 3);
				PERCENT_COMPLETED=0;
				REMAINING_TIME=10000;
				printProgress2(PERCENT_COMPLETED,REMAINING_TIME,option.extra.consoleWidth,BUF,1);				
				while (PERCENT_COMPLETED < 1.f && NEXT_PIXEL_INDEX < option.io.numOfPixels && IDE_USER_INTERRUPT==0) {
					printProgress2(PERCENT_COMPLETED,REMAINING_TIME,option.extra.consoleWidth,BUF,0);
					Sleep_ms(2 * 1000);
					if (CheckInterrupt()) {
						ConsumeInterruptSignal();
						IDE_USER_INTERRUPT=1;
						r_printf("Quitting due to unexpected user interruption...\n");
					}
				}
				if (IDE_USER_INTERRUPT==0) printProgress2(1.0,0,option.extra.consoleWidth,BUF,0);				
				free(BUF);
			}  
			r_printf("\nFinalizing ... \n");
			for (I32 i=0; i < NUM_THREADS; i++) {
				I64 ret=0;
				pthread_join(thread_id[i],&ret);
				r_printf("Rbeast: Thread #%-02d finished ... \n",i);
			}
			if (IDE_USER_INTERRUPT==0)
				r_printf("\nRbeast: Waited on %d threads. Done.\n",NUM_THREADS);
			else
				r_printf("\nQuited unexpected upon the user's interruption.\n");
			pthread_mutex_destroy(&mutex);
			pthread_cond_destroy(&condVar);
			free(thread_id);
			BEAST2_DeallocateTimeSeriesIO(&(option.io));
		}
	}
	#if !defined(R_RELEASE) &&  !defined(M_RELEASE)
	else if  (IS_STRING_EQUAL(algorithm,"mrbeast"))
	{
		MV_OPTIONS         option;
		MV_IO              io;
		MV_RESULT          result;
		memset(&io,0,sizeof(MV_IO));
		memset(&result,0,sizeof(MV_RESULT));
		option.io=&io;
		option.io->out.result=&result;
		option.io->isRegularOrdered=1;
		if (!MV_Get1stArg_Data(prhs,nrhs,&option)||
			!MV_Get2ndArg_MetaData(prhs,nrhs,&option)||
			!MV_Get3rdArg_Prior(prhs,nrhs,&option)||
			!MV_Get4thArg_MCMC(prhs,nrhs,&option)||
			!MV_Get5thArg_FLAGS(prhs,nrhs,&option)) {
			return IDE_NULL;
		}
		MV_print_options(&option);
		ANS=PROTECT(MV_AllocateOutput(&option)); nptr++;
		GLOBAL_OPTIONS=(MV_OPTIONS_PTR)&option;
		mrbeast_main_core();
		MV_DeallocateTimeSeriesIO(option.io);
	} 
	#endif
	else if (IS_STRING_EQUAL(algorithm,"tsextract")) {
		extern void* BEAST2_TsExtract(void* o,void* pindex);
		ANS=PROTECT(BEAST2_TsExtract(prhs[1],prhs[2]));
		nptr++;
	}
	else if (IS_STRING_EQUAL(algorithm,"print")) {
		extern void* BEAST2_PrintResult(void* o,void* pindex);
		BEAST2_PrintResult(prhs[1],prhs[2]); 
	}
	UNPROTECT(nptr);
	return ANS==NULL ? IDE_NULL : ANS;	
}
#if R_INTERFACE==1
#include <R_ext/libextern.h>
#include "Rembedded.h"
#if defined(MSVC_COMPILER)
SEXP DllExport rexFunction1(SEXP rList,SEXP dummy)
#else
SEXP DllExport rexFunction(SEXP rList,SEXP dummy)
#endif
{
	if (!isNewList(rList)) 	return R_NilValue;
	SEXP   prhs[10];
	int    nrhs=length(rList);
	nrhs=min(10L,nrhs);
	for (int i=0; i < nrhs; i++) 	
		prhs[i]=VECTOR_ELT(rList,i);
	SEXP ans;
	PROTECT(ans=mainFunction(prhs,nrhs));
	UNPROTECT(1);
	return ans !=NULL ? ans : R_NilValue;
}
#define CALLDEF(name,n) {#name,(DL_FUNC) &name,n}
#if (defined(WIN64_OS)||defined(WIN32_OS)) 
	SEXP TetrisSetTimer(SEXP action,SEXP seconds,SEXP envior);
	static const R_CallMethodDef CallEntries[]={
		#if defined(MSVC_COMPILER)
		CALLDEF(rexFunction1,2),
		#else
		CALLDEF(rexFunction,2),
		#endif
		CALLDEF(TetrisSetTimer,3),
		{ NULL,NULL,0 }
	};
#else
static const R_CallMethodDef CallEntries[]={
				CALLDEF(rexFunction,2),
				{ NULL,NULL,0 }
			};
#endif
void  R_init_Rbeast(DllInfo *dll)
{
	R_registerRoutines(dll,NULL,CallEntries,NULL,NULL);
	R_useDynamicSymbols(dll,FALSE);
}
#elif M_INTERFACE==1
#include "abc_date.h"
void DllExport mexFunction(int nlhs,mxArray* plhs[],int nrhs,const mxArray* prhs[]) {
	mxArray * ans=mainFunction(prhs,nrhs);
	plhs[0]=ans;
	return;
}
#endif
#if R_INTERFACE==11111111111111
SEXP DllExport sbm2(SEXP Y,SEXP opt)
{
	if (!R_sbm_check_input(Y,opt))		 			return R_NilValue;
	char	missing[31];
	BEAST_OPTIONS beastOption;
	R_sbm_read_input(&beastOption,Y,opt,missing);
	if (!sbm_check_options(&beastOption,missing))	return R_NilValue;
	print_options(&beastOption);
	BEAST_RESULT	result;
	SEXP	ANS;
	PROTECT(ANS=R_allocate_output(&result,&beastOption));
	GLOBAL_OPTIONS=(BEAST_OPTIONS_PTR)&beastOption;
	GLOBAL_RESULT=(BEAST_RESULT_PTR)&result;
	sbm();
		UNPROTECT(1);
	return ANS;
}
#endif
#include "abc_000_warning.h"
