% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_annual_volume.R
\name{rvn_annual_volume}
\alias{rvn_annual_volume}
\title{Annual Volume Comparison}
\usage{
rvn_annual_volume(
  sim,
  obs,
  mm = 9,
  dd = 30,
  add_line = TRUE,
  add_r2 = FALSE,
  add_eqn = FALSE,
  add_labels = FALSE
)
}
\arguments{
\item{sim}{time series object of simulated flows}

\item{obs}{time series object of observed flows}

\item{mm}{month of water year ending (default 9)}

\item{dd}{day of water year ending (default 30)}

\item{add_line}{optionally adds a 1:1 line to the plot for reference (default \code{TRUE})}

\item{add_r2}{optionally computes the R2 and adds to plot (default \code{FALSE})}

\item{add_eqn}{optionally adds the equation for a linear regression line through the origin (default \code{FALSE})}

\item{add_labels}{optionally adds year-ending labels to each point on plot using geom_text (default \code{FALSE})}
}
\value{
returns a list with annual volume data in a data frame, and a ggplot object
 \item{df_volume}{data frame of the calculated annual volumes}
 \item{p1}{ggplot object with plotted annual volumes}
}
\description{
Creates a plot of the annual observed and simulated volumes.
}
\details{
Creates a scatterplot of the annual observed and simulated
volumes, calculated for each available water year of data within the two series provided.
The sim and obs should be of time
series (xts) format and are assumed to be of the same length and time
period. Note that missing values in the observed series will impact the
volume estimation, and it is recommended that the NA values are filled in
prior to use of this function.

The R2 diagnostic is calculated for a fit with no intercept (in a perfect
fit the points are identical, and intercept is automatically zero).

Note that a plot title is purposely omitted in order to allow the automatic
generation of plot titles.
}
\examples{

# load sample hydrograph data, two years worth of sim/obs
data(rvn_hydrograph_data)
sim <- rvn_hydrograph_data$hyd$Sub36
obs <- rvn_hydrograph_data$hyd$Sub36_obs

# create a plot of the annual volumes with defaults
rvn_annual_volume(sim,obs)

# create a plot of the annual volumes with r2
rvn_annual_volume(sim,obs,add_r2=TRUE, add_eqn=TRUE)

# create a plot of the annual volumes with year-ending labels
rvn_annual_volume(sim,obs, add_labels=TRUE)

# calculate annual volumes for different water years (e.g. ending Oct 31)
vv <- rvn_annual_volume(sim, obs, mm=10, dd=31)
vv$df.volume
vv$p1

}
\seealso{
\code{\link{rvn_flow_scatterplot}} to create a scatterplot of flow
values
}
