% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_utilities.R
\name{rvn_fortify_xts}
\alias{rvn_fortify_xts}
\title{Fortify xts object to specific format}
\usage{
rvn_fortify_xts(x)
}
\arguments{
\item{x}{xts formatted object to fortify to tibble}
}
\value{
tibble format of the xts data
}
\description{
Applies the fortify function to an xts object and updates the Index character
column to a date column called 'Date'.
}
\details{
This function is useful in preparing data to plotting or other tidy-style analysis.
This function is used internally in many RavenR plotting functions.
}
\examples{
ff <- system.file("extdata","run1_Hydrographs.csv", package="RavenR")
hyd <- rvn_hyd_read(ff)$hyd
hyd_fortified <- rvn_fortify_xts(hyd)
head(hyd_fortified)

}
