% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpm_rearrange.R
\name{mpm_rearrange}
\alias{mpm_rearrange}
\title{Rearrange stages of a matrix population model to segregate reproductive and
non-reproductive stages}
\usage{
mpm_rearrange(matU, matF, matC = NULL, repro_stages, matrix_stages)
}
\arguments{
\item{matU}{The survival component of a matrix population model (i.e., a
square projection matrix reflecting survival-related transitions; e.g., 
progression, stasis, and retrogression)}

\item{matF}{The sexual component of a matrix population model (i.e., a square
projection matrix reflecting transitions due to sexual reproduction)}

\item{matC}{The clonal component of a matrix population model (i.e., a square
projection matrix reflecting transitions due to clonal reproduction).
Defaults to \code{NULL}, indicating no clonal reproduction (i.e., 
\code{matC} is a matrix of zeros).}

\item{repro_stages}{Logical vector of length \code{ncol(matU)} indicating 
which stages are reproductive. Alternatively, a vector of stage indices or 
stage names of the reproductive classes.}

\item{matrix_stages}{A character vector identifying organized matrix stages.}
}
\value{
Returns a list with 6 elements:
\item{matU}{Rearranged survival matrix}
\item{matF}{Rearranged sexual reproduction matrix}
\item{matC}{Rearranged clonal reproduction matrix}
\item{matrix_stages}{Rearranged vector of organized matrix stages}
\item{repro_stages}{Rearranged logical vector of reproductive stages}
\item{nonRepInterRep}{Numeric index for any rearranged inter-reproductive
 stages}
}
\description{
Rearrange stages of a matrix population model so that all inter-reproductive
stages fall in the final rows/columns of the matrix. This is a preparatory
step to collapsing the matrix model into a standardized set of stages (e.g., 
propagule, pre-reproductive, reproductive, and post-reproductive).
}
\examples{
matU <- rbind(c(0.1,   0,   0,   0,   0),
              c(0.5, 0.2, 0.1,   0,   0),
              c(  0, 0.3, 0.3, 0.1,   0),
              c(  0,   0, 0.4, 0.4, 0.1),
              c(  0,   0,   0, 0.1, 0.4))

matF <- rbind(c(  0, 1.1,   0, 1.6,   0),
              c(  0, 0.8,   0, 0.4,   0),
              c(  0,   0,   0,   0,   0),
              c(  0,   0,   0,   0,   0),
              c(  0,   0,   0,   0,   0))

repro_stages <- c(2, 4)
matrix_stages <- c('prop', 'active', 'active', 'active', 'active')

mpm_rearrange(matU, matF, repro_stages = repro_stages,
              matrix_stages = matrix_stages)

}
\seealso{
\code{\link{mpm_standardize}}

Other transformation: 
\code{\link{mpm_collapse}()},
\code{\link{mpm_split}()},
\code{\link{mpm_standardize}()},
\code{\link{name_stages}()},
\code{\link{repro_stages}()},
\code{\link{standard_stages}()}
}
\author{
Rob Salguero-Gómez <rob.salguero@zoo.ox.ac.uk>
}
\concept{transformation}
