% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in.da.R
\name{in.da}
\alias{in.da}
\alias{rv.da}
\title{Optimization functions for Dimensional Anchors in Radviz}
\usage{
in.da(springs, similarity)
rv.da(springs, similarity)
}
\arguments{
\item{springs}{A matrix of 2D dimensional anchor coordinates, as returned by \code{\link{make.S}}}

\item{similarity}{A similarity matrix measuring the correlation between Dimensional Anchors}
}
\value{
A measure of the efficiency of the Radviz projection of the similarity matrix
         onto a set of springs
}
\description{
Visual efficiency of Radviz plots depends heavily on the correct arrangement of Dimensional Anchors.
These functions implement the optimization strategies described in
\href{http://link.springer.com/chapter/10.1007/978-3-642-13672-6_13}{Di Caro et al 2012}
}
\details{
Following the recommendation of de cario et al. we used a cosine function to calculate
           the similarity between Dimensional Anchors (see \code{\link{cosine}} for details).
           The in.da function implements the independent similarity measure,
           where the value increases as the Radviz projection improves.
           The rv.da function implements the radviz-dependent similarity measure,
           where the value decreases as the Radviz projection improves.
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
scaled <- apply(iris[,das],2,do.L)
sim.mat <- cosine(scaled)
in.da(S,sim.mat) # increases with better projections
rv.da(S,sim.mat) # decreases with better projections

}
\author{
Yann Abraham
}

