% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{testPrior}
\alias{testPrior}
\title{Posterior check of the model}
\usage{
testPrior(
  res,
  expData,
  gamma = c(0.2, 0.5, 1, 5, 1000),
  rseed = 12345,
  ngenes = 200,
  pvalue = 0.01,
  minN = 5,
  no_cores = NULL,
  x0 = 0,
  lower = 0,
  upper = 100
)
}
\arguments{
\item{res}{List object with k nearest neighbour information returned by \code{pruneKnn}.}

\item{expData}{Matrix of gene expression values with genes as rows and cells as columns. These values have to correspond to unique molecular identifier counts.}

\item{gamma}{Vector of \code{gamma}-values to test for the Cauchy prior distribution. Default is \code{c(0.2,0.5,1,5,1000)}. Large values correspond to weak priors (\code{gamma=1000} corresponds to a maximum likelihood estimate).}

\item{rseed}{Integer number. Random seed to enforce reproducible gene sampling. Default is 12345.}

\item{ngenes}{Positive integer number. Randomly sampled number of genes (from rownames of \code{expData}) used for noise estimation. Genes are sampled uniformly across the entire expression range. Default is 200.}

\item{pvalue}{Input parameter for \code{compTBNoise}. See \code{help(compTBNoise)}.}

\item{minN}{Input parameter for \code{compTBNoise}. See \code{help(compTBNoise)}.}

\item{no_cores}{Input parameter for \code{compTBNoise}. See \code{help(compTBNoise)}.}

\item{x0}{Input parameter for \code{compTBNoise}. See \code{help(compTBNoise)}.}

\item{lower}{Input parameter for \code{compTBNoise}. See \code{help(compTBNoise)}.}

\item{upper}{Input parameter for \code{compTBNoise}. See \code{help(compTBNoise)}.}
}
\value{
List of three components:
\item{pp.var.ratio}{List of vectors for each gamma value of ratios between predicted and actual variances across all sampled genes and neighbourhoods.}
\item{noise}{List of noise objects obtained from \code{compTBNoise} for each gamma value.}
\item{tc}{Vector of total transcript counts for all cells}
}
\description{
This functions compares variance estimates obtained from the maximum a posterior estimate with a given prior to the data. The ratio between the predicted variance and the actual variance for a random subset of genes is computed across all pruned k nearest neighbourhoods.
}
