% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.RaSE.R
\name{predict.RaSE}
\alias{predict.RaSE}
\title{Predict the outcome of new observations based on the estimated RaSE classifier.}
\usage{
\method{predict}{RaSE}(object, newx, ...)
}
\arguments{
\item{object}{fitted \code{'RaSE'} object using \code{Rase}.}

\item{newx}{a set of new observations. Each row of \code{newx} is a new observation.}

\item{...}{additional arguments.}
}
\value{
The predicted labels for new observations.
}
\description{
Predict the outcome of new observations based on the estimated RaSE classifier.
}
\examples{
\dontrun{
set.seed(0, kind = "L'Ecuyer-CMRG")
train.data <- RaModel(1, n = 100, p = 50)
test.data <- RaModel(1, n = 100, p = 50)
xtrain <- train.data$x
ytrain <- train.data$y
xtest <- test.data$x
ytest <- test.data$y

model.fit <- Rase(xtrain, ytrain, B1 = 100, B2 = 100, iteration = 0, base = 'lda',
cores = 2, criterion = 'ric', ranking = TRUE)
ypred <- predict(model.fit, xtest)
}

}
\references{
Tian, Y. and Feng, Y., 2021. RaSE: Random subspace ensemble classification. Journal of Machine Learning Research, 22(45), pp.1-93.
}
\seealso{
\code{\link{Rase}}.
}
