% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BPSIIDGaussian}
\alias{BPSIIDGaussian}
\title{BPSIIDGaussian}
\usage{
BPSIIDGaussian(variance, dim = 1L, n_iter = -1L, finalTime = -1,
  x0 = numeric(0), v0 = numeric(0), refresh_rate = 1,
  unit_velocity = FALSE)
}
\arguments{
\item{variance}{scalar indicating variance}

\item{dim}{dimension}

\item{n_iter}{Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.}

\item{finalTime}{If provided and nonnegative, run the sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})}

\item{x0}{starting point (optional, if not specified taken to be the origin)}

\item{v0}{starting direction (optional, if not specified taken to be a random vector)}

\item{refresh_rate}{\code{lambda_refresh}}

\item{unit_velocity}{TRUE indicates velocities uniform on unit sphere, FALSE (default) indicates standard normal velocities}
}
\value{
Returns a list with the following objects:

\code{Times}: Vector of switching times

\code{Positions}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.

\code{Velocities}: Matrix whose columns are velocities just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
}
\description{
Applies the Bouncy Particle Sampler to a IID Gaussian distribution
}
\examples{
result <- BPSIIDGaussian(1, 2, 1000)
plot(result$Positions[2,], result$Positions[1,],type='l',asp=1)
}
