/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import weka.classifiers.UpdateableClassifier;
import weka.clusterers.UpdateableClusterer;
import weka.core.Attribute;
import weka.core.CapabilitiesHandler;
import weka.core.CapabilitiesIgnorer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.NoSupportForMissingValuesException;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.UnassignedClassException;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.core.WekaException;
import weka.core.converters.ConverterUtils;

public class Capabilities
implements Cloneable,
Serializable,
RevisionHandler {
    static final long serialVersionUID = -5478590032325567849L;
    public static final String PROPERTIES_FILE = "weka/core/Capabilities.props";
    protected static Properties PROPERTIES;
    protected static HashSet<Class> INTERFACE_DEFINED_CAPABILITIES;
    protected static boolean TEST;
    protected static boolean INSTANCES_TEST;
    protected static boolean ATTRIBUTE_TEST;
    protected static boolean MISSING_VALUES_TEST;
    protected static boolean MISSING_CLASS_VALUES_TEST;
    protected static boolean MINIMUM_NUMBER_INSTANCES_TEST;
    private static final int ATTRIBUTE = 1;
    private static final int CLASS = 2;
    private static final int ATTRIBUTE_CAPABILITY = 4;
    private static final int CLASS_CAPABILITY = 8;
    private static final int OTHER_CAPABILITY = 16;
    protected CapabilitiesHandler m_Owner;
    protected HashSet<Capability> m_Capabilities;
    protected HashSet<Capability> m_Dependencies;
    protected HashSet<Class> m_InterfaceDefinedCapabilities;
    protected Exception m_FailReason = null;
    protected int m_MinimumNumberInstances = 1;
    protected boolean m_Test = TEST;
    protected boolean m_InstancesTest = INSTANCES_TEST;
    protected boolean m_AttributeTest = ATTRIBUTE_TEST;
    protected boolean m_MissingValuesTest = MISSING_VALUES_TEST;
    protected boolean m_MissingClassValuesTest = MISSING_CLASS_VALUES_TEST;
    protected boolean m_MinimumNumberInstancesTest = MINIMUM_NUMBER_INSTANCES_TEST;

    public Capabilities(CapabilitiesHandler owner) {
        this.setOwner(owner);
        this.m_Capabilities = new HashSet();
        this.m_Dependencies = new HashSet();
        if (owner instanceof UpdateableClassifier || owner instanceof UpdateableClusterer) {
            this.setMinimumNumberInstances(0);
        }
    }

    public boolean doNotCheckCapabilities() {
        if (this.getOwner() != null && this.getOwner() instanceof CapabilitiesIgnorer) {
            return ((CapabilitiesIgnorer)((Object)this.getOwner())).getDoNotCheckCapabilities();
        }
        return false;
    }

    public Object clone() {
        Capabilities result = new Capabilities(this.m_Owner);
        result.assign(this);
        return result;
    }

    public void assign(Capabilities c) {
        for (Capability cap : Capability.values()) {
            if (c.handles(cap)) {
                this.enable(cap);
            } else {
                this.disable(cap);
            }
            if (c.hasDependency(cap)) {
                this.enableDependency(cap);
                continue;
            }
            this.disableDependency(cap);
        }
        this.setMinimumNumberInstances(c.getMinimumNumberInstances());
        this.m_InterfaceDefinedCapabilities = new HashSet<Class>(c.m_InterfaceDefinedCapabilities);
    }

    public void and(Capabilities c) {
        for (Capability cap : Capability.values()) {
            if (this.handles(cap) && c.handles(cap)) {
                this.m_Capabilities.add(cap);
            } else {
                this.m_Capabilities.remove((Object)cap);
            }
            if (this.hasDependency(cap) && c.hasDependency(cap)) {
                this.m_Dependencies.add(cap);
                continue;
            }
            this.m_Dependencies.remove((Object)cap);
        }
        if (c.getMinimumNumberInstances() > this.getMinimumNumberInstances()) {
            this.setMinimumNumberInstances(c.getMinimumNumberInstances());
        }
        HashSet<Class> intersection = new HashSet<Class>();
        for (Class cl : c.m_InterfaceDefinedCapabilities) {
            if (!this.m_InterfaceDefinedCapabilities.contains(cl)) continue;
            intersection.add(cl);
        }
        this.m_InterfaceDefinedCapabilities = intersection;
    }

    public void or(Capabilities c) {
        for (Capability cap : Capability.values()) {
            if (this.handles(cap) || c.handles(cap)) {
                this.m_Capabilities.add(cap);
            } else {
                this.m_Capabilities.remove((Object)cap);
            }
            if (this.hasDependency(cap) || c.hasDependency(cap)) {
                this.m_Dependencies.add(cap);
                continue;
            }
            this.m_Dependencies.remove((Object)cap);
        }
        if (c.getMinimumNumberInstances() < this.getMinimumNumberInstances()) {
            this.setMinimumNumberInstances(c.getMinimumNumberInstances());
        }
        this.m_InterfaceDefinedCapabilities.addAll(c.m_InterfaceDefinedCapabilities);
    }

    public boolean supports(Capabilities c) {
        for (Capability cap : Capability.values()) {
            if (!c.handles(cap) || this.handles(cap)) continue;
            return false;
        }
        for (Class cl : c.m_InterfaceDefinedCapabilities) {
            if (this.m_InterfaceDefinedCapabilities.contains(cl)) continue;
            return false;
        }
        return true;
    }

    public boolean supportsMaybe(Capabilities c) {
        for (Capability cap : Capability.values()) {
            if (!c.handles(cap) || this.handles(cap) || this.hasDependency(cap)) continue;
            return false;
        }
        for (Class cl : c.m_InterfaceDefinedCapabilities) {
            if (this.m_InterfaceDefinedCapabilities.contains(cl)) continue;
            return false;
        }
        return true;
    }

    public void setOwner(CapabilitiesHandler value) {
        this.m_Owner = value;
        this.m_InterfaceDefinedCapabilities = new HashSet();
        if (this.m_Owner != null) {
            for (Class c : INTERFACE_DEFINED_CAPABILITIES) {
                if (!c.isInstance(this.m_Owner)) continue;
                this.m_InterfaceDefinedCapabilities.add(c);
            }
        }
    }

    public CapabilitiesHandler getOwner() {
        return this.m_Owner;
    }

    public void setMinimumNumberInstances(int value) {
        if (value >= 0) {
            this.m_MinimumNumberInstances = value;
        }
    }

    public int getMinimumNumberInstances() {
        return this.m_MinimumNumberInstances;
    }

    public Iterator<Capability> capabilities() {
        return this.m_Capabilities.iterator();
    }

    public Iterator<Capability> dependencies() {
        return this.m_Dependencies.iterator();
    }

    public void enable(Capability c) {
        if (c == Capability.NOMINAL_ATTRIBUTES) {
            this.enable(Capability.BINARY_ATTRIBUTES);
        } else if (c == Capability.BINARY_ATTRIBUTES) {
            this.enable(Capability.UNARY_ATTRIBUTES);
        } else if (c == Capability.UNARY_ATTRIBUTES) {
            this.enable(Capability.EMPTY_NOMINAL_ATTRIBUTES);
        } else if (c == Capability.NOMINAL_CLASS) {
            this.enable(Capability.BINARY_CLASS);
        }
        this.m_Capabilities.add(c);
    }

    public void enableDependency(Capability c) {
        if (c == Capability.NOMINAL_ATTRIBUTES) {
            this.enableDependency(Capability.BINARY_ATTRIBUTES);
        } else if (c == Capability.BINARY_ATTRIBUTES) {
            this.enableDependency(Capability.UNARY_ATTRIBUTES);
        } else if (c == Capability.UNARY_ATTRIBUTES) {
            this.enableDependency(Capability.EMPTY_NOMINAL_ATTRIBUTES);
        } else if (c == Capability.NOMINAL_CLASS) {
            this.enableDependency(Capability.BINARY_CLASS);
        }
        this.m_Dependencies.add(c);
    }

    public void enableAllClasses() {
        for (Capability cap : Capability.values()) {
            if (!cap.isClass()) continue;
            this.enable(cap);
        }
    }

    public void enableAllClassDependencies() {
        for (Capability cap : Capability.values()) {
            if (!cap.isClass()) continue;
            this.enableDependency(cap);
        }
    }

    public void enableAllAttributes() {
        for (Capability cap : Capability.values()) {
            if (!cap.isAttribute()) continue;
            this.enable(cap);
        }
    }

    public void enableAllAttributeDependencies() {
        for (Capability cap : Capability.values()) {
            if (!cap.isAttribute()) continue;
            this.enableDependency(cap);
        }
    }

    public void enableAll() {
        this.enableAllAttributes();
        this.enableAllAttributeDependencies();
        this.enableAllClasses();
        this.enableAllClassDependencies();
        this.enable(Capability.MISSING_VALUES);
        this.enable(Capability.MISSING_CLASS_VALUES);
    }

    public void disable(Capability c) {
        if (c == Capability.NOMINAL_ATTRIBUTES) {
            this.disable(Capability.BINARY_ATTRIBUTES);
        } else if (c == Capability.BINARY_ATTRIBUTES) {
            this.disable(Capability.UNARY_ATTRIBUTES);
        } else if (c == Capability.UNARY_ATTRIBUTES) {
            this.disable(Capability.EMPTY_NOMINAL_ATTRIBUTES);
        } else if (c == Capability.NOMINAL_CLASS) {
            this.disable(Capability.BINARY_CLASS);
        } else if (c == Capability.BINARY_CLASS) {
            this.disable(Capability.UNARY_CLASS);
        } else if (c == Capability.UNARY_CLASS) {
            this.disable(Capability.EMPTY_NOMINAL_CLASS);
        }
        this.m_Capabilities.remove((Object)c);
    }

    public void disableDependency(Capability c) {
        if (c == Capability.NOMINAL_ATTRIBUTES) {
            this.disableDependency(Capability.BINARY_ATTRIBUTES);
        } else if (c == Capability.BINARY_ATTRIBUTES) {
            this.disableDependency(Capability.UNARY_ATTRIBUTES);
        } else if (c == Capability.UNARY_ATTRIBUTES) {
            this.disableDependency(Capability.EMPTY_NOMINAL_ATTRIBUTES);
        } else if (c == Capability.NOMINAL_CLASS) {
            this.disableDependency(Capability.BINARY_CLASS);
        } else if (c == Capability.BINARY_CLASS) {
            this.disableDependency(Capability.UNARY_CLASS);
        } else if (c == Capability.UNARY_CLASS) {
            this.disableDependency(Capability.EMPTY_NOMINAL_CLASS);
        }
        this.m_Dependencies.remove((Object)c);
    }

    public void disableAllClasses() {
        for (Capability cap : Capability.values()) {
            if (!cap.isClass()) continue;
            this.disable(cap);
        }
    }

    public void disableAllClassDependencies() {
        for (Capability cap : Capability.values()) {
            if (!cap.isClass()) continue;
            this.disableDependency(cap);
        }
    }

    public void disableAllAttributes() {
        for (Capability cap : Capability.values()) {
            if (!cap.isAttribute()) continue;
            this.disable(cap);
        }
    }

    public void disableAllAttributeDependencies() {
        for (Capability cap : Capability.values()) {
            if (!cap.isAttribute()) continue;
            this.disableDependency(cap);
        }
    }

    public void disableAll() {
        this.disableAllAttributes();
        this.disableAllAttributeDependencies();
        this.disableAllClasses();
        this.disableAllClassDependencies();
        this.disable(Capability.MISSING_VALUES);
        this.disable(Capability.MISSING_CLASS_VALUES);
        this.disable(Capability.NO_CLASS);
    }

    public Capabilities getClassCapabilities() {
        Capabilities result = new Capabilities(this.getOwner());
        for (Capability cap : Capability.values()) {
            if (!cap.isClassCapability() || !this.handles(cap)) continue;
            result.m_Capabilities.add(cap);
        }
        return result;
    }

    public Capabilities getAttributeCapabilities() {
        Capabilities result = new Capabilities(this.getOwner());
        for (Capability cap : Capability.values()) {
            if (!cap.isAttributeCapability() || !this.handles(cap)) continue;
            result.m_Capabilities.add(cap);
        }
        return result;
    }

    public Capabilities getOtherCapabilities() {
        Capabilities result = new Capabilities(this.getOwner());
        for (Capability cap : Capability.values()) {
            if (!cap.isOtherCapability() || !this.handles(cap)) continue;
            result.m_Capabilities.add(cap);
        }
        return result;
    }

    public boolean handles(Capability c) {
        return this.m_Capabilities.contains((Object)c);
    }

    public boolean hasDependency(Capability c) {
        return this.m_Dependencies.contains((Object)c);
    }

    public boolean hasDependencies() {
        return this.m_Dependencies.size() > 0;
    }

    public Exception getFailReason() {
        return this.m_FailReason;
    }

    protected String createMessage(String msg) {
        String result = this.getOwner() != null ? this.getOwner().getClass().getName() : "<anonymous>";
        result = result + ": " + msg;
        return result;
    }

    public boolean test(Attribute att) {
        return this.test(att, false);
    }

    public boolean test(Attribute att, boolean isClass) {
        if (this.doNotCheckCapabilities()) {
            return true;
        }
        boolean result = true;
        if (!this.m_AttributeTest) {
            return result;
        }
        String errorStr = isClass ? "class" : "attributes";
        switch (att.type()) {
            case 1: {
                Capability capEmpty;
                Capability capUnary;
                Capability capBinary;
                Capability cap;
                if (isClass) {
                    cap = Capability.NOMINAL_CLASS;
                    capBinary = Capability.BINARY_CLASS;
                    capUnary = Capability.UNARY_CLASS;
                    capEmpty = Capability.EMPTY_NOMINAL_CLASS;
                } else {
                    cap = Capability.NOMINAL_ATTRIBUTES;
                    capBinary = Capability.BINARY_ATTRIBUTES;
                    capUnary = Capability.UNARY_ATTRIBUTES;
                    capEmpty = Capability.EMPTY_NOMINAL_ATTRIBUTES;
                }
                if (this.handles(cap) && att.numValues() > 2 || this.handles(capBinary) && att.numValues() == 2 || this.handles(capUnary) && att.numValues() == 1 || this.handles(capEmpty) && att.numValues() == 0) break;
                if (att.numValues() == 0) {
                    this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle empty nominal " + errorStr + "!"));
                    result = false;
                }
                if (att.numValues() == 1) {
                    this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle unary " + errorStr + "!"));
                    result = false;
                    break;
                }
                if (att.numValues() == 2) {
                    this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle binary " + errorStr + "!"));
                    result = false;
                    break;
                }
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle multi-valued nominal " + errorStr + "!"));
                result = false;
                break;
            }
            case 0: {
                Capability cap = isClass ? Capability.NUMERIC_CLASS : Capability.NUMERIC_ATTRIBUTES;
                if (this.handles(cap)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle numeric " + errorStr + "!"));
                result = false;
                break;
            }
            case 3: {
                Capability cap = isClass ? Capability.DATE_CLASS : Capability.DATE_ATTRIBUTES;
                if (this.handles(cap)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle date " + errorStr + "!"));
                result = false;
                break;
            }
            case 2: {
                Capability cap = isClass ? Capability.STRING_CLASS : Capability.STRING_ATTRIBUTES;
                if (this.handles(cap)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle string " + errorStr + "!"));
                result = false;
                break;
            }
            case 4: {
                Capability cap = isClass ? Capability.RELATIONAL_CLASS : Capability.RELATIONAL_ATTRIBUTES;
                if (this.handles(cap)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle relational " + errorStr + "!"));
                result = false;
                break;
            }
            default: {
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle unknown attribute type '" + att.type() + "'!"));
                result = false;
            }
        }
        return result;
    }

    public boolean test(Instances data) {
        return this.test(data, 0, data.numAttributes() - 1);
    }

    protected static Class getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception ex) {
            System.err.println("Class: " + name + " not found in Capabilities");
            return new Object().getClass();
        }
    }

    public boolean test(Instances data, int fromIndex, int toIndex) {
        Capabilities cap;
        Attribute att;
        int i;
        if (this.doNotCheckCapabilities()) {
            return true;
        }
        if (!this.m_InstancesTest) {
            return true;
        }
        if (this.m_Capabilities.size() == 0 || this.m_Capabilities.size() == 1 && this.handles(Capability.NO_CLASS)) {
            System.err.println(this.createMessage("No capabilities set!"));
        }
        if (toIndex - fromIndex < 0) {
            this.m_FailReason = new WekaException(this.createMessage("No attributes!"));
            return false;
        }
        boolean testClass = data.classIndex() > -1 && data.classIndex() >= fromIndex && data.classIndex() <= toIndex;
        Class weightedAttributesHandler = Capabilities.getClass("weka.core.WeightedAttributesHandler");
        for (i = fromIndex; i <= toIndex; ++i) {
            att = data.attribute(i);
            if (i == data.classIndex()) continue;
            if (!this.test(att)) {
                return false;
            }
            if (att.weight() == 1.0 || !INTERFACE_DEFINED_CAPABILITIES.contains(weightedAttributesHandler) || this.m_InterfaceDefinedCapabilities.contains(weightedAttributesHandler)) continue;
            this.m_FailReason = new WekaException(this.createMessage("Some attribute weights are not equal to 1 and scheme does not implement the WeightedAttributesHandler interface!"));
            return false;
        }
        if (!this.handles(Capability.NO_CLASS) && data.classIndex() == -1) {
            this.m_FailReason = new UnassignedClassException(this.createMessage("Class attribute not set!"));
            return false;
        }
        if (this.handles(Capability.NO_CLASS) && data.classIndex() > -1) {
            cap = this.getClassCapabilities();
            cap.disable(Capability.NO_CLASS);
            Iterator<Capability> iter = cap.capabilities();
            if (!iter.hasNext()) {
                this.m_FailReason = new WekaException(this.createMessage("Cannot handle any class attribute!"));
                return false;
            }
        }
        if (testClass && !this.handles(Capability.NO_CLASS)) {
            att = data.classAttribute();
            if (!this.test(att, true)) {
                return false;
            }
            if (this.m_MissingClassValuesTest) {
                if (!this.handles(Capability.MISSING_CLASS_VALUES)) {
                    for (i = 0; i < data.numInstances(); ++i) {
                        if (!data.instance(i).classIsMissing()) continue;
                        this.m_FailReason = new WekaException(this.createMessage("Cannot handle missing class values!"));
                        return false;
                    }
                } else if (this.m_MinimumNumberInstancesTest) {
                    int hasClass = 0;
                    for (i = 0; i < data.numInstances(); ++i) {
                        if (data.instance(i).classIsMissing()) continue;
                        ++hasClass;
                    }
                    if (hasClass < this.getMinimumNumberInstances()) {
                        this.m_FailReason = new WekaException(this.createMessage("Not enough training instances with class labels (required: " + this.getMinimumNumberInstances() + ", provided: " + hasClass + ")!"));
                        return false;
                    }
                }
            }
        }
        boolean missing = false;
        Class weightedInstancesHandler = Capabilities.getClass("weka.core.WeightedInstancesHandler");
        for (i = 0; i < data.numInstances(); ++i) {
            int n;
            Instance inst = data.instance(i);
            if (inst.weight() != 1.0 && INTERFACE_DEFINED_CAPABILITIES.contains(weightedInstancesHandler) && !this.m_InterfaceDefinedCapabilities.contains(weightedInstancesHandler)) {
                this.m_FailReason = new WekaException(this.createMessage("Some instance weights are not equal to 1 and scheme does not implement the WeightedInstancesHandler interface!"));
                return false;
            }
            if (!this.m_MissingValuesTest || this.handles(Capability.MISSING_VALUES)) continue;
            if (inst instanceof SparseInstance) {
                for (int m = 0; m < inst.numValues(); ++m) {
                    n = inst.index(m);
                    if (n < fromIndex) continue;
                    if (n > toIndex) break;
                    if (n == inst.classIndex() || !inst.isMissing(n)) continue;
                    missing = true;
                    break;
                }
            } else {
                for (n = fromIndex; n <= toIndex; ++n) {
                    if (n == inst.classIndex() || !inst.isMissing(n)) continue;
                    missing = true;
                    break;
                }
            }
            if (!missing) continue;
            this.m_FailReason = new NoSupportForMissingValuesException(this.createMessage("Cannot handle missing values!"));
            return false;
        }
        if (this.m_MinimumNumberInstancesTest && data.numInstances() < this.getMinimumNumberInstances()) {
            this.m_FailReason = new WekaException(this.createMessage("Not enough training instances (required: " + this.getMinimumNumberInstances() + ", provided: " + data.numInstances() + ")!"));
            return false;
        }
        if (this.handles(Capability.ONLY_MULTIINSTANCE)) {
            if (data.numAttributes() != 3) {
                this.m_FailReason = new WekaException(this.createMessage("Incorrect Multi-Instance format, must be 'bag-id, bag, class'!"));
                return false;
            }
            if (!data.attribute(0).isNominal() || !data.attribute(1).isRelationValued() || data.classIndex() != data.numAttributes() - 1) {
                this.m_FailReason = new WekaException(this.createMessage("Incorrect Multi-Instance format, must be 'NOMINAL att, RELATIONAL att, CLASS att'!"));
                return false;
            }
            if (this.getOwner() instanceof MultiInstanceCapabilitiesHandler) {
                MultiInstanceCapabilitiesHandler handler = (MultiInstanceCapabilitiesHandler)this.getOwner();
                cap = handler.getMultiInstanceCapabilities();
                boolean result = data.numInstances() > 0 && data.attribute(1).numValues() > 0 ? cap.test(data.attribute(1).relation(0)) : cap.test(data.attribute(1).relation());
                if (!result) {
                    this.m_FailReason = cap.m_FailReason;
                    return false;
                }
            }
        }
        return true;
    }

    public void testWithFail(Attribute att) throws Exception {
        this.test(att, false);
    }

    public void testWithFail(Attribute att, boolean isClass) throws Exception {
        if (!this.test(att, isClass)) {
            throw this.m_FailReason;
        }
    }

    public void testWithFail(Instances data, int fromIndex, int toIndex) throws Exception {
        if (!this.test(data, fromIndex, toIndex)) {
            throw this.m_FailReason;
        }
    }

    public void testWithFail(Instances data) throws Exception {
        if (!this.test(data)) {
            throw this.m_FailReason;
        }
    }

    public String listCapabilities() {
        Iterator<Capability> iter = this.capabilities();
        ArrayList<String> caps = new ArrayList<String>();
        while (iter.hasNext()) {
            caps.add(iter.next().toString());
        }
        Collections.sort(caps);
        String s = caps.toString();
        return s.substring(1, s.length() - 1);
    }

    public String addCapabilities(String title) {
        String result = title + "\n";
        String caps = this.getClassCapabilities().listCapabilities();
        if (caps.length() != 0) {
            result = result + "Class -- ";
            result = result + caps;
            result = result + "\n\n";
        }
        if ((caps = this.getAttributeCapabilities().listCapabilities()).length() != 0) {
            result = result + "Attributes -- ";
            result = result + caps;
            result = result + "\n\n";
        }
        if ((caps = this.getOtherCapabilities().listCapabilities()).length() != 0) {
            result = result + "Other -- ";
            result = result + caps;
            result = result + "\n\n";
        }
        ArrayList<String> interfaceNames = new ArrayList<String>();
        for (Class c : this.m_InterfaceDefinedCapabilities) {
            interfaceNames.add(c.getSimpleName());
        }
        Collections.sort(interfaceNames);
        if (interfaceNames.size() > 0) {
            result = result + "Interfaces -- ";
            String s = interfaceNames.toString();
            result = result + s.substring(1, s.length() - 1);
            result = result + "\n\n";
        }
        result = result + "Additional\n";
        result = result + "Minimum number of instances: " + this.getMinimumNumberInstances() + "\n";
        result = result + "\n";
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Vector<Capability> sorted = new Vector<Capability>(this.m_Capabilities);
        Collections.sort(sorted);
        result.append("Capabilities: " + sorted.toString() + "\n");
        sorted = new Vector<Capability>(this.m_Dependencies);
        Collections.sort(sorted);
        result.append("Dependencies: " + sorted.toString() + "\n");
        ArrayList<String> interfaceNames = new ArrayList<String>();
        for (Class c : this.m_InterfaceDefinedCapabilities) {
            interfaceNames.add(c.getSimpleName());
        }
        Collections.sort(interfaceNames);
        result.append("Interfaces: " + interfaceNames.toString() + "\n");
        result.append("Minimum number of instances: " + this.getMinimumNumberInstances() + "\n");
        return result.toString();
    }

    public String toSource(String objectname) {
        return this.toSource(objectname, 0);
    }

    public String toSource(String objectname, int indent) {
        StringBuffer result = new StringBuffer();
        String capsName = Capabilities.class.getName();
        String capName = Capability.class.getName().replaceAll("\\$", ".");
        String indentStr = "";
        for (int i = 0; i < indent; ++i) {
            indentStr = indentStr + " ";
        }
        result.append(indentStr + capsName + " " + objectname + " = new " + capsName + "(this);\n");
        ArrayList<Capability> capsList = new ArrayList<Capability>();
        boolean hasNominalAtt = false;
        boolean hasBinaryAtt = false;
        boolean hasUnaryAtt = false;
        boolean hasNominalClass = false;
        result.append("\n");
        for (Capability cap : Capability.values()) {
            if (!this.handles(cap)) continue;
            if (cap == Capability.NOMINAL_ATTRIBUTES) {
                hasNominalAtt = true;
            }
            if (cap == Capability.NOMINAL_CLASS) {
                hasNominalClass = true;
            }
            if (cap == Capability.BINARY_ATTRIBUTES) {
                hasBinaryAtt = true;
            }
            if (cap == Capability.UNARY_ATTRIBUTES) {
                hasUnaryAtt = true;
            }
            if (cap == Capability.EMPTY_NOMINAL_ATTRIBUTES) {
                // empty if block
            }
            capsList.add(cap);
        }
        for (Capability cap : capsList) {
            if (cap == Capability.BINARY_ATTRIBUTES && hasNominalAtt || cap == Capability.UNARY_ATTRIBUTES && hasBinaryAtt || cap == Capability.EMPTY_NOMINAL_ATTRIBUTES && hasUnaryAtt || cap == Capability.BINARY_CLASS && hasNominalClass) continue;
            result.append(indentStr + objectname + ".enable(" + capName + "." + cap.name() + ");\n");
            if (!this.hasDependency(cap)) continue;
            result.append(indentStr + objectname + ".enableDependency(" + capName + "." + cap.name() + ");\n");
        }
        result.append("\n");
        result.append("\n");
        result.append(indentStr + objectname + ".setMinimumNumberInstances(" + this.getMinimumNumberInstances() + ");\n");
        result.append("\n");
        return result.toString();
    }

    public static Capabilities forInstances(Instances data) throws Exception {
        return Capabilities.forInstances(data, false);
    }

    public static Capabilities forInstances(Instances data, boolean multi) throws Exception {
        int i;
        Capabilities result = new Capabilities(null);
        result.m_InterfaceDefinedCapabilities = new HashSet();
        if (data.classIndex() == -1) {
            result.enable(Capability.NO_CLASS);
        } else {
            switch (data.classAttribute().type()) {
                case 1: {
                    if (data.classAttribute().numValues() == 1) {
                        result.enable(Capability.UNARY_CLASS);
                        break;
                    }
                    if (data.classAttribute().numValues() == 2) {
                        result.enable(Capability.BINARY_CLASS);
                        break;
                    }
                    result.enable(Capability.NOMINAL_CLASS);
                    break;
                }
                case 0: {
                    result.enable(Capability.NUMERIC_CLASS);
                    break;
                }
                case 2: {
                    result.enable(Capability.STRING_CLASS);
                    break;
                }
                case 3: {
                    result.enable(Capability.DATE_CLASS);
                    break;
                }
                case 4: {
                    result.enable(Capability.RELATIONAL_CLASS);
                    break;
                }
                default: {
                    throw new UnsupportedAttributeTypeException("Unknown class attribute type '" + data.classAttribute() + "'!");
                }
            }
            for (i = 0; i < data.numInstances(); ++i) {
                if (!data.instance(i).classIsMissing()) continue;
                result.enable(Capability.MISSING_CLASS_VALUES);
                break;
            }
        }
        Class weightedAttributesHandler = Capabilities.getClass("weka.core.WeightedAttributesHandler");
        block15: for (i = 0; i < data.numAttributes(); ++i) {
            if (i == data.classIndex()) continue;
            if (data.attribute(i).weight() != 1.0) {
                result.m_InterfaceDefinedCapabilities.add(weightedAttributesHandler);
            }
            switch (data.attribute(i).type()) {
                case 1: {
                    result.enable(Capability.UNARY_ATTRIBUTES);
                    if (data.attribute(i).numValues() == 2) {
                        result.enable(Capability.BINARY_ATTRIBUTES);
                        continue block15;
                    }
                    if (data.attribute(i).numValues() <= 2) continue block15;
                    result.enable(Capability.NOMINAL_ATTRIBUTES);
                    continue block15;
                }
                case 0: {
                    result.enable(Capability.NUMERIC_ATTRIBUTES);
                    continue block15;
                }
                case 3: {
                    result.enable(Capability.DATE_ATTRIBUTES);
                    continue block15;
                }
                case 2: {
                    result.enable(Capability.STRING_ATTRIBUTES);
                    continue block15;
                }
                case 4: {
                    result.enable(Capability.RELATIONAL_ATTRIBUTES);
                    continue block15;
                }
                default: {
                    throw new UnsupportedAttributeTypeException("Unknown attribute type '" + data.attribute(i).type() + "'!");
                }
            }
        }
        boolean missing = false;
        Class weightedInstancesHandler = Capabilities.getClass("weka.core.WeightedInstancesHandler");
        for (i = 0; i < data.numInstances(); ++i) {
            int n;
            Instance inst = data.instance(i);
            if (inst.weight() != 1.0) {
                result.m_InterfaceDefinedCapabilities.add(weightedInstancesHandler);
            }
            if (inst instanceof SparseInstance) {
                for (int m = 0; m < inst.numValues(); ++m) {
                    n = inst.index(m);
                    if (n == inst.classIndex() || !inst.isMissing(n)) continue;
                    missing = true;
                    break;
                }
            } else {
                for (n = 0; n < data.numAttributes(); ++n) {
                    if (n == inst.classIndex() || !inst.isMissing(n)) continue;
                    missing = true;
                    break;
                }
            }
            if (!missing) continue;
            result.enable(Capability.MISSING_VALUES);
            break;
        }
        if (multi && data.numAttributes() == 3 && data.attribute(0).isNominal() && data.attribute(1).isRelationValued() && data.classIndex() == data.numAttributes() - 1) {
            Capabilities multiInstance = new Capabilities(null);
            multiInstance.or(result.getClassCapabilities());
            multiInstance.enable(Capability.NOMINAL_ATTRIBUTES);
            multiInstance.enable(Capability.RELATIONAL_ATTRIBUTES);
            multiInstance.enable(Capability.ONLY_MULTIINSTANCE);
            result.assign(multiInstance);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("\nUsage: " + Capabilities.class.getName() + " -file <dataset> [-c <class index>]\n");
            return;
        }
        String tmpStr = Utils.getOption("file", args);
        if (tmpStr.length() == 0) {
            throw new Exception("No file provided with option '-file'!");
        }
        String filename = tmpStr;
        tmpStr = Utils.getOption("c", args);
        int classIndex = tmpStr.length() != 0 ? (tmpStr.equals("first") ? 0 : (tmpStr.equals("last") ? -2 : Integer.parseInt(tmpStr) - 1)) : -3;
        ConverterUtils.DataSource source = new ConverterUtils.DataSource(filename);
        Instances data = classIndex == -3 ? source.getDataSet() : (classIndex == -2 ? source.getDataSet(source.getStructure().numAttributes() - 1) : source.getDataSet(classIndex));
        Capabilities cap = Capabilities.forInstances(data);
        System.out.println("File: " + filename);
        System.out.println("Class index: " + (data.classIndex() == -1 ? "not set" : "" + (data.classIndex() + 1)));
        System.out.println("Capabilities:");
        Iterator<Capability> iter = cap.capabilities();
        while (iter.hasNext()) {
            System.out.println("- " + (Object)((Object)iter.next()));
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14512 $");
    }

    static {
        if (PROPERTIES == null) {
            try {
                PROPERTIES = Utils.readProperties(PROPERTIES_FILE);
                TEST = Boolean.parseBoolean(PROPERTIES.getProperty("Test", "true"));
                INSTANCES_TEST = Boolean.parseBoolean(PROPERTIES.getProperty("InstancesTest", "true")) && TEST;
                ATTRIBUTE_TEST = Boolean.parseBoolean(PROPERTIES.getProperty("AttributeTest", "true")) && TEST;
                MISSING_VALUES_TEST = Boolean.parseBoolean(PROPERTIES.getProperty("MissingValuesTest", "true")) && TEST;
                MISSING_CLASS_VALUES_TEST = Boolean.parseBoolean(PROPERTIES.getProperty("MissingClassValuesTest", "true")) && TEST;
                MINIMUM_NUMBER_INSTANCES_TEST = Boolean.parseBoolean(PROPERTIES.getProperty("MinimumNumberInstancesTest", "true")) && TEST;
                INTERFACE_DEFINED_CAPABILITIES = new HashSet();
                for (String key : PROPERTIES.stringPropertyNames()) {
                    if (!key.endsWith("InterfaceCapability")) continue;
                    INTERFACE_DEFINED_CAPABILITIES.add(Class.forName(PROPERTIES.getProperty(key)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                PROPERTIES = new Properties();
            }
        }
    }

    public static enum Capability {
        NOMINAL_ATTRIBUTES(5, "Nominal attributes"),
        BINARY_ATTRIBUTES(5, "Binary attributes"),
        UNARY_ATTRIBUTES(5, "Unary attributes"),
        EMPTY_NOMINAL_ATTRIBUTES(5, "Empty nominal attributes"),
        NUMERIC_ATTRIBUTES(5, "Numeric attributes"),
        DATE_ATTRIBUTES(5, "Date attributes"),
        STRING_ATTRIBUTES(5, "String attributes"),
        RELATIONAL_ATTRIBUTES(5, "Relational attributes"),
        MISSING_VALUES(4, "Missing values"),
        NO_CLASS(8, "No class"),
        NOMINAL_CLASS(10, "Nominal class"),
        BINARY_CLASS(10, "Binary class"),
        UNARY_CLASS(10, "Unary class"),
        EMPTY_NOMINAL_CLASS(10, "Empty nominal class"),
        NUMERIC_CLASS(10, "Numeric class"),
        DATE_CLASS(10, "Date class"),
        STRING_CLASS(10, "String class"),
        RELATIONAL_CLASS(10, "Relational class"),
        MISSING_CLASS_VALUES(8, "Missing class values"),
        ONLY_MULTIINSTANCE(16, "Only multi-Instance data");

        private int m_Flags = 0;
        private String m_Display;

        private Capability(int flags, String display) {
            this.m_Flags = flags;
            this.m_Display = display;
        }

        public boolean isAttribute() {
            return (this.m_Flags & 1) == 1;
        }

        public boolean isClass() {
            return (this.m_Flags & 2) == 2;
        }

        public boolean isAttributeCapability() {
            return (this.m_Flags & 4) == 4;
        }

        public boolean isOtherCapability() {
            return (this.m_Flags & 0x10) == 16;
        }

        public boolean isClassCapability() {
            return (this.m_Flags & 8) == 8;
        }

        public String toString() {
            return this.m_Display;
        }
    }
}

