/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class MakeIndicator
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = 766001176862773163L;
    private SingleIndex m_AttIndex = new SingleIndex("last");
    private Range m_ValIndex = new Range("last");
    private boolean m_Numeric = true;

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(instanceInfo.numAttributes() - 1);
        this.m_ValIndex.setUpper(instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        if (!instanceInfo.attribute(this.m_AttIndex.getIndex()).isNominal()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not nominal.");
        }
        if (instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() < 2) {
            throw new UnsupportedAttributeTypeException("Chosen attribute has less than two values.");
        }
        this.setOutputFormat();
        return true;
    }

    public boolean input(Instance instance) {
        Instance newInstance;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (!(newInstance = (Instance)instance.copy()).isMissing(this.m_AttIndex.getIndex())) {
            if (this.m_ValIndex.isInRange((int)newInstance.value(this.m_AttIndex.getIndex()))) {
                newInstance.setValue(this.m_AttIndex.getIndex(), 1.0);
            } else {
                newInstance.setValue(this.m_AttIndex.getIndex(), 0.0);
            }
        }
        this.push(newInstance);
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tSets the attribute index.", "C", 1, "-C <col>"));
        newVector.addElement(new Option("\tSpecify the list of values to indicate. First and last are\n\tvalid indexes (default last)", "V", 1, "-V <index1,index2-index4,...>"));
        newVector.addElement(new Option("\tSet if new boolean attribute nominal.", "N", 0, "-N <index>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String attIndex = Utils.getOption('C', options);
        if (attIndex.length() != 0) {
            this.setAttributeIndex(attIndex);
        } else {
            this.setAttributeIndex("last");
        }
        String valIndex = Utils.getOption('V', options);
        if (valIndex.length() != 0) {
            this.setValueIndices(valIndex);
        } else {
            this.setValueIndices("last");
        }
        this.setNumeric(!Utils.getFlag('N', options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] options = new String[5];
        int current = 0;
        options[current++] = "-C";
        options[current++] = "" + this.getAttributeIndex();
        options[current++] = "-V";
        options[current++] = this.getValueIndices();
        if (!this.getNumeric()) {
            options[current++] = "-N";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String globalInfo() {
        return "A filter that creates a new dataset with a boolean attribute replacing a nominal attribute.  In the new dataset, a value of 1 is assigned to an instance that exhibits a particular range of attribute values, a 0 to an instance that doesn't. The boolean attribute is coded as numeric by default.";
    }

    public String attributeIndexTipText() {
        return "Sets which attribute should be replaced by the indicator. This attribute must be nominal.";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String attIndex) {
        this.m_AttIndex.setSingleIndex(attIndex);
    }

    public Range getValueRange() {
        return this.m_ValIndex;
    }

    public String valueIndicesTipText() {
        return "Specify range of nominal values to act on. This is a comma separated list of attribute indices (numbered from 1), with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getValueIndices() {
        return this.m_ValIndex.getRanges();
    }

    public void setValueIndices(String range) {
        this.m_ValIndex.setRanges(range);
    }

    public void setValueIndex(int index) {
        this.setValueIndices("" + (index + 1));
    }

    public void setValueIndicesArray(int[] indices) {
        this.setValueIndices(Range.indicesToRangeList(indices));
    }

    public String numericTipText() {
        return "Determines whether the output indicator attribute is numeric. If this is set to false, the output attribute will be nominal.";
    }

    public void setNumeric(boolean bool) {
        this.m_Numeric = bool;
    }

    public boolean getNumeric() {
        return this.m_Numeric;
    }

    private void setOutputFormat() {
        FastVector<Attribute> newAtts = new FastVector<Attribute>(this.getInputFormat().numAttributes());
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (j != this.m_AttIndex.getIndex()) {
                newAtts.addElement(att);
                continue;
            }
            if (this.m_Numeric) {
                newAtts.addElement(new Attribute(att.name()));
                continue;
            }
            int[] sel = this.m_ValIndex.getSelection();
            String vals = sel.length == 1 ? att.value(sel[0]) : this.m_ValIndex.getRanges().replace(',', '_');
            FastVector<String> newVals = new FastVector<String>(2);
            newVals.addElement("neg_" + vals);
            newVals.addElement("pos_" + vals);
            newAtts.addElement(new Attribute(att.name(), newVals));
        }
        Instances newData = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        newData.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(newData);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] argv) {
        MakeIndicator.runFilter(new MakeIndicator(), argv);
    }
}

