/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.File;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.estimators.Estimator;

public class BIFReader
extends BayesNet
implements TechnicalInformationHandler {
    protected int[] m_nPositionX;
    protected int[] m_nPositionY;
    private int[] m_order;
    static final long serialVersionUID = -8358864680379881429L;
    String m_sFile;

    public String globalInfo() {
        return "Builds a description of a Bayes Net classifier stored in XML BIF 0.3 format.\n\nFor more details on XML BIF see:\n\n" + this.getTechnicalInformation().toString();
    }

    public BIFReader processFile(String sFile) throws Exception {
        this.m_sFile = sFile;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        Document doc = factory.newDocumentBuilder().parse(new File(sFile));
        doc.normalize();
        this.buildInstances(doc, sFile);
        this.buildStructure(doc);
        return this;
    }

    public BIFReader processString(String sStr) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        Document doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(sStr)));
        doc.normalize();
        this.buildInstances(doc, "from-string");
        this.buildStructure(doc);
        return this;
    }

    public String getFileName() {
        return this.m_sFile;
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Fabio Cozman and Marek Druzdzel and Daniel Garcia");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "XML BIF version 0.3");
        result.setValue(TechnicalInformation.Field.URL, "http://www-2.cs.cmu.edu/~fgcozman/Research/InterchangeFormat/");
        return result;
    }

    void buildStructure(Document doc) throws Exception {
        this.m_Distributions = new Estimator[this.m_Instances.numAttributes()][];
        for (int iNode = 0; iNode < this.m_Instances.numAttributes(); ++iNode) {
            String sName = this.m_Instances.attribute(iNode).name();
            Element definition = this.getDefinition(doc, sName);
            FastVector nodelist = this.getParentNodes(definition);
            for (int iParent = 0; iParent < nodelist.size(); ++iParent) {
                Node parentName = ((Node)nodelist.elementAt(iParent)).getFirstChild();
                String sParentName = ((CharacterData)parentName).getData();
                int nParent = this.getNode(sParentName);
                this.m_ParentSets[iNode].addParent(nParent, this.m_Instances);
            }
            int nCardinality = this.m_ParentSets[iNode].getCardinalityOfParents();
            int nValues = this.m_Instances.attribute(iNode).numValues();
            this.m_Distributions[iNode] = new Estimator[nCardinality];
            for (int i = 0; i < nCardinality; ++i) {
                this.m_Distributions[iNode][i] = new DiscreteEstimatorBayes(nValues, 0.0);
            }
            String sTable = this.getTable(definition);
            StringTokenizer st = new StringTokenizer(sTable.toString());
            for (int i = 0; i < nCardinality; ++i) {
                DiscreteEstimatorBayes d = (DiscreteEstimatorBayes)this.m_Distributions[iNode][i];
                for (int iValue = 0; iValue < nValues; ++iValue) {
                    String sWeight = st.nextToken();
                    d.addValue(iValue, new Double(sWeight));
                }
            }
        }
    }

    public void Sync(BayesNet other) throws Exception {
        int nAtts = this.m_Instances.numAttributes();
        if (nAtts != other.m_Instances.numAttributes()) {
            throw new Exception("Cannot synchronize networks: different number of attributes.");
        }
        this.m_order = new int[nAtts];
        int iNode = 0;
        while (iNode < nAtts) {
            String sName = other.getNodeName(iNode);
            this.m_order[this.getNode((String)sName)] = iNode++;
        }
    }

    public String getContent(Element node) {
        String result = "";
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 3) continue;
            result = result + "\n" + item.getNodeValue();
        }
        return result;
    }

    void buildInstances(Document doc, String sName) throws Exception {
        NodeList nodelist = this.selectAllNames(doc);
        if (nodelist.getLength() > 0) {
            sName = ((CharacterData)nodelist.item(0).getFirstChild()).getData();
        }
        nodelist = this.selectAllVariables(doc);
        int nNodes = nodelist.getLength();
        FastVector<Attribute> attInfo = new FastVector<Attribute>(nNodes);
        this.m_nPositionX = new int[nodelist.getLength()];
        this.m_nPositionY = new int[nodelist.getLength()];
        for (int iNode = 0; iNode < nodelist.getLength(); ++iNode) {
            FastVector valueslist = this.selectOutCome(nodelist.item(iNode));
            int nValues = valueslist.size();
            FastVector<String> nomStrings = new FastVector<String>(nValues + 1);
            for (int iValue = 0; iValue < nValues; ++iValue) {
                Node node = ((Node)valueslist.elementAt(iValue)).getFirstChild();
                String sValue = ((CharacterData)node).getData();
                if (sValue == null) {
                    sValue = "Value" + (iValue + 1);
                }
                nomStrings.addElement(sValue);
            }
            FastVector nodelist2 = this.selectName(nodelist.item(iNode));
            if (nodelist2.size() == 0) {
                throw new Exception("No name specified for variable");
            }
            String sNodeName = ((CharacterData)((Node)nodelist2.elementAt(0)).getFirstChild()).getData();
            Attribute att = new Attribute(sNodeName, nomStrings);
            attInfo.addElement(att);
            valueslist = this.selectProperty(nodelist.item(iNode));
            nValues = valueslist.size();
            for (int iValue = 0; iValue < nValues; ++iValue) {
                Node node = ((Node)valueslist.elementAt(iValue)).getFirstChild();
                String sValue = ((CharacterData)node).getData();
                if (!sValue.startsWith("position")) continue;
                int i0 = sValue.indexOf(40);
                int i1 = sValue.indexOf(44);
                int i2 = sValue.indexOf(41);
                String sX = sValue.substring(i0 + 1, i1).trim();
                String sY = sValue.substring(i1 + 1, i2).trim();
                try {
                    this.m_nPositionX[iNode] = Integer.parseInt(sX);
                    this.m_nPositionY[iNode] = Integer.parseInt(sY);
                    continue;
                }
                catch (NumberFormatException e) {
                    System.err.println("Wrong number format in position :(" + sX + "," + sY + ")");
                    this.m_nPositionX[iNode] = 0;
                    this.m_nPositionY[iNode] = 0;
                }
            }
        }
        this.m_Instances = new Instances(sName, attInfo, 100);
        this.m_Instances.setClassIndex(nNodes - 1);
        this.setUseADTree(false);
        this.initStructure();
    }

    NodeList selectAllNames(Document doc) throws Exception {
        NodeList nodelist = doc.getElementsByTagName("NAME");
        return nodelist;
    }

    NodeList selectAllVariables(Document doc) throws Exception {
        NodeList nodelist = doc.getElementsByTagName("VARIABLE");
        return nodelist;
    }

    Element getDefinition(Document doc, String sName) throws Exception {
        NodeList nodelist = doc.getElementsByTagName("DEFINITION");
        for (int iNode = 0; iNode < nodelist.getLength(); ++iNode) {
            Node forNode;
            Node node = nodelist.item(iNode);
            FastVector list = this.selectElements(node, "FOR");
            if (list.size() <= 0 || !this.getContent((Element)(forNode = (Node)list.elementAt(0))).trim().equals(sName)) continue;
            return (Element)node;
        }
        throw new Exception("Could not find definition for ((" + sName + "))");
    }

    FastVector getParentNodes(Node definition) throws Exception {
        FastVector nodelist = this.selectElements(definition, "GIVEN");
        return nodelist;
    }

    String getTable(Node definition) throws Exception {
        FastVector nodelist = this.selectElements(definition, "TABLE");
        String sTable = this.getContent((Element)nodelist.elementAt(0));
        sTable = sTable.replaceAll("\\n", " ");
        return sTable;
    }

    FastVector selectOutCome(Node item) throws Exception {
        FastVector nodelist = this.selectElements(item, "OUTCOME");
        return nodelist;
    }

    FastVector selectName(Node item) throws Exception {
        FastVector nodelist = this.selectElements(item, "NAME");
        return nodelist;
    }

    FastVector selectProperty(Node item) throws Exception {
        FastVector nodelist = this.selectElements(item, "PROPERTY");
        return nodelist;
    }

    FastVector selectElements(Node item, String sElement) throws Exception {
        NodeList children = item.getChildNodes();
        FastVector<Node> nodelist = new FastVector<Node>();
        for (int iNode = 0; iNode < children.getLength(); ++iNode) {
            Node node = children.item(iNode);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(sElement)) continue;
            nodelist.addElement(node);
        }
        return nodelist;
    }

    public int missingArcs(BayesNet other) {
        try {
            this.Sync(other);
            int nMissing = 0;
            for (int iAttribute = 0; iAttribute < this.m_Instances.numAttributes(); ++iAttribute) {
                for (int iParent = 0; iParent < this.m_ParentSets[iAttribute].getNrOfParents(); ++iParent) {
                    int nParent = this.m_ParentSets[iAttribute].getParent(iParent);
                    if (other.getParentSet(this.m_order[iAttribute]).contains(this.m_order[nParent]) || other.getParentSet(this.m_order[nParent]).contains(this.m_order[iAttribute])) continue;
                    ++nMissing;
                }
            }
            return nMissing;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return 0;
        }
    }

    public int extraArcs(BayesNet other) {
        try {
            this.Sync(other);
            int nExtra = 0;
            for (int iAttribute = 0; iAttribute < this.m_Instances.numAttributes(); ++iAttribute) {
                for (int iParent = 0; iParent < other.getParentSet(this.m_order[iAttribute]).getNrOfParents(); ++iParent) {
                    int nParent = this.m_order[other.getParentSet(this.m_order[iAttribute]).getParent(iParent)];
                    if (this.m_ParentSets[iAttribute].contains(nParent) || this.m_ParentSets[nParent].contains(iAttribute)) continue;
                    ++nExtra;
                }
            }
            return nExtra;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return 0;
        }
    }

    public double divergence(BayesNet other) {
        try {
            this.Sync(other);
            double D = 0.0;
            int nNodes = this.m_Instances.numAttributes();
            int[] nCard = new int[nNodes];
            for (int iNode = 0; iNode < nNodes; ++iNode) {
                nCard[iNode] = this.m_Instances.attribute(iNode).numValues();
            }
            int[] x = new int[nNodes];
            int i = 0;
            while (i < nNodes) {
                int n = i;
                x[n] = x[n] + 1;
                while (i < nNodes && x[i] == this.m_Instances.attribute(i).numValues()) {
                    x[i] = 0;
                    if (++i >= nNodes) continue;
                    int n2 = i;
                    x[n2] = x[n2] + 1;
                }
                if (i >= nNodes) continue;
                i = 0;
                double P = 1.0;
                for (int iNode = 0; iNode < nNodes; ++iNode) {
                    int iCPT = 0;
                    for (int iParent = 0; iParent < this.m_ParentSets[iNode].getNrOfParents(); ++iParent) {
                        int nParent = this.m_ParentSets[iNode].getParent(iParent);
                        iCPT = iCPT * nCard[nParent] + x[nParent];
                    }
                    P *= this.m_Distributions[iNode][iCPT].getProbability(x[iNode]);
                }
                double Q = 1.0;
                for (int iNode = 0; iNode < nNodes; ++iNode) {
                    int iCPT = 0;
                    for (int iParent = 0; iParent < other.getParentSet(this.m_order[iNode]).getNrOfParents(); ++iParent) {
                        int nParent = this.m_order[other.getParentSet(this.m_order[iNode]).getParent(iParent)];
                        iCPT = iCPT * nCard[nParent] + x[nParent];
                    }
                    Q *= other.m_Distributions[this.m_order[iNode]][iCPT].getProbability(x[iNode]);
                }
                if (!(P > 0.0) || !(Q > 0.0)) continue;
                D += P * Math.log(Q / P);
            }
            return D;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return 0.0;
        }
    }

    public int reversedArcs(BayesNet other) {
        try {
            this.Sync(other);
            int nReversed = 0;
            for (int iAttribute = 0; iAttribute < this.m_Instances.numAttributes(); ++iAttribute) {
                for (int iParent = 0; iParent < this.m_ParentSets[iAttribute].getNrOfParents(); ++iParent) {
                    int nParent = this.m_ParentSets[iAttribute].getParent(iParent);
                    if (other.getParentSet(this.m_order[iAttribute]).contains(this.m_order[nParent]) || !other.getParentSet(this.m_order[nParent]).contains(this.m_order[iAttribute])) continue;
                    ++nReversed;
                }
            }
            return nReversed;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return 0;
        }
    }

    public int getNode(String sNodeName) throws Exception {
        for (int iNode = 0; iNode < this.m_Instances.numAttributes(); ++iNode) {
            if (!this.m_Instances.attribute(iNode).name().equals(sNodeName)) continue;
            return iNode;
        }
        throw new Exception("Could not find node [[" + sNodeName + "]]");
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.15 $");
    }

    public static void main(String[] args) {
        try {
            BIFReader br = new BIFReader();
            br.processFile(args[0]);
            System.out.println(br.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

