/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stopwords;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.core.stopwords.AbstractStopwords;

public abstract class AbstractFileBasedStopwords
extends AbstractStopwords {
    private static final long serialVersionUID = -8568762652879773063L;
    protected File m_Stopwords = new File(System.getProperty("user.dir"));

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration<Option> enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\t" + this.stopwordsTipText() + "\n" + "\t(default: .)", "stopwords", 1, "-stopwords <file>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("stopwords", options);
        if (tmpStr.isEmpty()) {
            this.setStopwords(new File("."));
        } else {
            this.setStopwords(new File(tmpStr));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> options = new ArrayList<String>(Arrays.asList(super.getOptions()));
        options.add("-stopwords");
        options.add(this.getStopwords().toString());
        return options.toArray(new String[options.size()]);
    }

    public void setStopwords(File value) {
        if (value == null) {
            value = new File(System.getProperty("user.dir"));
        }
        this.m_Stopwords = value;
        this.reset();
    }

    public File getStopwords() {
        return this.m_Stopwords;
    }

    public abstract String stopwordsTipText();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> read() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_Stopwords.exists() && !this.m_Stopwords.isDirectory()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(this.m_Stopwords));
                while ((line = reader.readLine()) != null) {
                    result.add(line.trim());
                }
            }
            catch (Exception e) {
                this.error("Failed to read stopwords file '" + this.m_Stopwords + "'!");
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return result;
    }
}

