/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.Function;
import weka.core.pmml.TransformationDictionary;

public class DefineFunction
extends Function {
    private static final long serialVersionUID = -1976646917527243888L;
    protected ArrayList<ParameterField> m_parameters = new ArrayList();
    FieldMetaInfo.Optype m_optype = FieldMetaInfo.Optype.NONE;
    protected Expression m_expression = null;

    public DefineFunction(Element container, TransformationDictionary transDict) throws Exception {
        this.m_functionName = container.getAttribute("name");
        String opType = container.getAttribute("optype");
        if (opType != null && opType.length() > 0) {
            for (FieldMetaInfo.Optype o : FieldMetaInfo.Optype.values()) {
                if (!o.toString().equals(opType)) continue;
                this.m_optype = o;
                break;
            }
        } else {
            throw new Exception("[DefineFunction] no optype specified!!");
        }
        this.m_parameterDefs = new ArrayList();
        NodeList paramL = container.getElementsByTagName("ParameterField");
        for (int i = 0; i < paramL.getLength(); ++i) {
            Node paramN = paramL.item(i);
            if (paramN.getNodeType() != 1) continue;
            ParameterField newP = new ParameterField((Element)paramN);
            this.m_parameters.add(newP);
            this.m_parameterDefs.add(newP.getFieldAsAttribute());
        }
        this.m_expression = Expression.getExpression(container, this.m_optype, this.m_parameterDefs, transDict);
        if (this.m_optype == FieldMetaInfo.Optype.CONTINUOUS && this.m_expression.getOptype() != this.m_optype) {
            throw new Exception("[DefineFunction] optype is continuous but our Expression's optype is not.");
        }
        if ((this.m_optype == FieldMetaInfo.Optype.CATEGORICAL || this.m_optype == FieldMetaInfo.Optype.ORDINAL) != (this.m_expression.getOptype() == FieldMetaInfo.Optype.CATEGORICAL || this.m_expression.getOptype() == FieldMetaInfo.Optype.ORDINAL)) {
            throw new Exception("[DefineFunction] optype is categorical/ordinal but our Expression's optype is not.");
        }
    }

    public void pushParameterDefs() throws Exception {
        if (this.m_parameterDefs == null) {
            throw new Exception("[DefineFunction] parameter definitions are null! Can't push them to encapsulated expression.");
        }
        this.m_expression.setFieldDefs(this.m_parameterDefs);
    }

    @Override
    public Attribute getOutputDef() {
        return this.m_expression.getOutputDef();
    }

    @Override
    public String[] getParameterNames() {
        String[] result = new String[this.m_parameters.size()];
        for (int i = 0; i < this.m_parameters.size(); ++i) {
            result[i] = this.m_parameters.get(i).getFieldName();
        }
        return result;
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        if (incoming.length != this.m_parameters.size()) {
            throw new IllegalArgumentException("[DefineFunction] wrong number of arguments: expected " + this.m_parameters.size() + ", recieved " + incoming.length);
        }
        return this.m_expression.getResult(incoming);
    }

    @Override
    public void setParameterDefs(ArrayList<Attribute> paramDefs) throws Exception {
        if (paramDefs.size() != this.m_parameters.size()) {
            throw new Exception("[DefineFunction] number of parameter definitions does not match number of parameters!");
        }
        for (int i = 0; i < this.m_parameters.size(); ++i) {
            if (this.m_parameters.get(i).getOptype() == FieldMetaInfo.Optype.CONTINUOUS) {
                if (paramDefs.get(i).isNumeric()) continue;
                throw new Exception("[DefineFunction] parameter " + this.m_parameters.get(i).getFieldName() + " is continuous, but corresponding " + "supplied parameter def " + paramDefs.get(i).name() + " is not!");
            }
            if (paramDefs.get(i).isNominal() || paramDefs.get(i).isString()) continue;
            throw new Exception("[DefineFunction] parameter " + this.m_parameters.get(i).getFieldName() + " is categorical/ordinal, but corresponding " + "supplied parameter def " + paramDefs.get(i).name() + " is not!");
        }
        ArrayList<Attribute> newParamDefs = new ArrayList<Attribute>();
        for (int i = 0; i < paramDefs.size(); ++i) {
            Attribute a = paramDefs.get(i);
            newParamDefs.add(a.copy(this.m_parameters.get(i).getFieldName()));
        }
        this.m_parameterDefs = newParamDefs;
        this.m_expression.setFieldDefs(this.m_parameterDefs);
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String pad) {
        StringBuffer buff = new StringBuffer();
        buff.append(pad + "DefineFunction (" + this.m_functionName + "):\n" + pad + "nparameters:\n");
        for (ParameterField p : this.m_parameters) {
            buff.append(pad + p.getFieldAsAttribute() + "\n");
        }
        buff.append(pad + "expression:\n" + this.m_expression.toString(pad + "  "));
        return buff.toString();
    }

    protected class ParameterField
    extends FieldMetaInfo {
        private static final long serialVersionUID = 3918895902507585558L;

        protected ParameterField(Element field) {
            super(field);
        }

        @Override
        public Attribute getFieldAsAttribute() {
            if (this.m_optype == FieldMetaInfo.Optype.CONTINUOUS) {
                return new Attribute(this.m_fieldName);
            }
            return new Attribute(this.m_fieldName, (List<String>)null);
        }
    }
}

