/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.tokenizers.CharacterDelimitedTokenizer;

public class NGramTokenizer
extends CharacterDelimitedTokenizer {
    private static final long serialVersionUID = -2181896254171647219L;
    protected int m_NMax = 3;
    protected int m_NMin = 1;
    protected int m_N;
    protected int m_MaxPosition;
    protected int m_CurrentPosition;
    protected String[] m_SplitString;

    public String globalInfo() {
        return "Splits a string into an n-gram with min and max grams.";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe max size of the Ngram (default = 3).", "max", 1, "-max <int>"));
        vector.addElement(new Option("\tThe min size of the Ngram (default = 1).", "min", 1, "-min <int>"));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-max");
        vector.add("" + this.getNGramMaxSize());
        vector.add("-min");
        vector.add("" + this.getNGramMinSize());
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption("max", stringArray);
        if (string.length() != 0) {
            this.setNGramMaxSize(Integer.parseInt(string));
        } else {
            this.setNGramMaxSize(3);
        }
        string = Utils.getOption("min", stringArray);
        if (string.length() != 0) {
            this.setNGramMinSize(Integer.parseInt(string));
        } else {
            this.setNGramMinSize(1);
        }
    }

    public int getNGramMaxSize() {
        return this.m_NMax;
    }

    public void setNGramMaxSize(int n) {
        this.m_NMax = n < 1 ? 1 : n;
    }

    public String NGramMaxSizeTipText() {
        return "The max N of the NGram.";
    }

    public void setNGramMinSize(int n) {
        this.m_NMin = n < 1 ? 1 : n;
    }

    public int getNGramMinSize() {
        return this.m_NMin;
    }

    public String NGramMinSizeTipText() {
        return "The min N of the NGram.";
    }

    public boolean hasMoreElements() {
        return this.m_CurrentPosition < this.m_MaxPosition && this.m_N - 1 + this.m_CurrentPosition < this.m_MaxPosition && this.m_N >= this.m_NMin;
    }

    public Object nextElement() {
        String string = "";
        for (int i = 0; i < this.m_N && i + this.m_CurrentPosition < this.m_MaxPosition; ++i) {
            string = string + " " + this.m_SplitString[this.m_CurrentPosition + i];
        }
        ++this.m_CurrentPosition;
        if (this.m_CurrentPosition + this.m_N - 1 == this.m_MaxPosition) {
            this.m_CurrentPosition = 0;
            --this.m_N;
        }
        return string.trim();
    }

    protected void filterOutEmptyStrings() {
        int n;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (n = 0; n < this.m_SplitString.length; ++n) {
            if (this.m_SplitString[n].equals("")) continue;
            linkedList.add(this.m_SplitString[n]);
        }
        String[] stringArray = new String[linkedList.size()];
        for (n = 0; n < linkedList.size(); ++n) {
            stringArray[n] = (String)linkedList.get(n);
        }
        this.m_SplitString = stringArray;
    }

    public void tokenize(String string) {
        this.m_N = this.m_NMax;
        this.m_SplitString = string.split("[" + this.getDelimiters() + "]");
        this.filterOutEmptyStrings();
        this.m_CurrentPosition = 0;
        this.m_MaxPosition = this.m_SplitString.length;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] stringArray) {
        NGramTokenizer.runTokenizer(new NGramTokenizer(), stringArray);
    }
}

