/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.Utils;

public abstract class MultipleClassifiersCombiner
extends Classifier {
    private static final long serialVersionUID = 2776436621129422119L;
    protected Classifier[] m_Classifiers = new Classifier[]{new ZeroR()};

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tFull class name of classifier to include, followed\n\tby scheme options. May be specified multiple times.\n\t(default: \"weka.classifiers.rules.ZeroR\")", "B", 1, "-B <classifier specification>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        Classifier[] classifierArray;
        Vector<Classifier> vector = new Vector<Classifier>();
        while ((classifierArray = Utils.getOption('B', stringArray)).length() != 0) {
            String[] stringArray2 = Utils.splitOptions((String)classifierArray);
            if (stringArray2.length == 0) {
                throw new IllegalArgumentException("Invalid classifier specification string");
            }
            String string = stringArray2[0];
            stringArray2[0] = "";
            vector.addElement(Classifier.forName(string, stringArray2));
        }
        if (vector.size() == 0) {
            vector.addElement(new ZeroR());
        }
        classifierArray = new Classifier[vector.size()];
        for (int i = 0; i < classifierArray.length; ++i) {
            classifierArray[i] = (Classifier)vector.elementAt(i);
        }
        this.setClassifiers(classifierArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        int n = 0;
        String[] stringArray2 = new String[stringArray.length + this.m_Classifiers.length * 2];
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringArray2[n++] = "-B";
            stringArray2[n++] = "" + this.getClassifierSpec(i);
        }
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        return stringArray2;
    }

    public String classifiersTipText() {
        return "The base classifiers to be used.";
    }

    public void setClassifiers(Classifier[] classifierArray) {
        this.m_Classifiers = classifierArray;
    }

    public Classifier[] getClassifiers() {
        return this.m_Classifiers;
    }

    public Classifier getClassifier(int n) {
        return this.m_Classifiers[n];
    }

    protected String getClassifierSpec(int n) {
        if (this.m_Classifiers.length < n) {
            return "";
        }
        Classifier classifier = this.getClassifier(n);
        return classifier.getClass().getName() + " " + Utils.joinOptions(classifier.getOptions());
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities;
        if (this.getClassifiers().length == 0) {
            capabilities = new Capabilities(this);
            capabilities.disableAll();
        } else {
            capabilities = (Capabilities)this.getClassifier(0).getCapabilities().clone();
            for (int i = 1; i < this.getClassifiers().length; ++i) {
                capabilities.and(this.getClassifier(i).getCapabilities());
            }
        }
        for (Capabilities.Capability capability : Capabilities.Capability.values()) {
            capabilities.enableDependency(capability);
        }
        capabilities.setOwner(this);
        return capabilities;
    }
}

