/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Enumeration;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.global.GlobalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class TAN
extends GlobalScoreSearchAlgorithm
implements TechnicalInformationHandler {
    static final long serialVersionUID = 1715277053980895298L;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "N. Friedman and D. Geiger and M. Goldszmidt");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1997");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Bayesian network classifiers");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "29");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "2-3");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "131-163");
        return technicalInformation;
    }

    public void buildStructure(BayesNet bayesNet, Instances instances) throws Exception {
        int n;
        int n2;
        this.m_BayesNet = bayesNet;
        this.m_bInitAsNaiveBayes = true;
        this.m_nMaxNrOfParents = 2;
        super.buildStructure(bayesNet, instances);
        int n3 = instances.numAttributes();
        int n4 = instances.classIndex();
        int[] nArray = new int[n3 - 1];
        int[] nArray2 = new int[n3 - 1];
        boolean[] blArray = new boolean[n3];
        int n5 = -1;
        int n6 = -1;
        double d = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 == n4) continue;
            for (n = 0; n < n3; ++n) {
                if (n2 == n || n == n4) continue;
                double d2 = this.calcScoreWithExtraParent(n2, n);
                if (n5 != -1 && !(d2 > d)) continue;
                d = d2;
                n5 = n;
                n6 = n2;
            }
        }
        nArray[0] = n5;
        nArray2[0] = n6;
        blArray[n5] = true;
        blArray[n6] = true;
        for (n = 1; n < n3 - 2; ++n) {
            n5 = -1;
            for (n2 = 0; n2 < n3; ++n2) {
                if (n2 == n4) continue;
                for (int i = 0; i < n3; ++i) {
                    if (n2 == i || i == n4 || !blArray[n2] && !blArray[i] || blArray[n2] && blArray[i]) continue;
                    double d3 = this.calcScoreWithExtraParent(n2, i);
                    if (n5 != -1 && !(d3 > d)) continue;
                    d = d3;
                    n5 = i;
                    n6 = n2;
                }
            }
            nArray[n] = n5;
            nArray2[n] = n6;
            blArray[n5] = true;
            blArray[n6] = true;
        }
        boolean[] blArray2 = new boolean[n3];
        for (int i = 0; i < n3 - 2; ++i) {
            if (!blArray2[nArray[i]]) {
                bayesNet.getParentSet(nArray[i]).addParent(nArray2[i], instances);
                blArray2[nArray[i]] = true;
                continue;
            }
            if (blArray2[nArray2[i]]) {
                throw new Exception("Bug condition found: too many arrows");
            }
            bayesNet.getParentSet(nArray2[i]).addParent(nArray[i], instances);
            blArray2[nArray2[i]] = true;
        }
    }

    public Enumeration listOptions() {
        return super.listOptions();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        return super.getOptions();
    }

    public String globalInfo() {
        return "This Bayes Network learning algorithm determines the maximum weight spanning tree and returns a Naive Bayes network augmented with a tree.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }
}

