/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Sourcable;
import weka.classifiers.rules.ZeroR;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class REPTree
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
Drawable,
AdditionalMeasureProducer,
Sourcable {
    static final long serialVersionUID = -8562443428621539458L;
    protected ZeroR m_zeroR;
    protected Tree m_Tree = null;
    protected int m_NumFolds = 3;
    protected int m_Seed = 1;
    protected boolean m_NoPruning = false;
    protected double m_MinNum = 2.0;
    protected double m_MinVarianceProp = 0.001;
    protected int m_MaxDepth = -1;
    private static long PRINTED_NODES = 0L;

    public String globalInfo() {
        return "Fast decision tree learner. Builds a decision/regression tree using information gain/variance and prunes it using reduced-error pruning (with backfitting).  Only sorts values for numeric attributes once. Missing values are dealt with by splitting the corresponding instances into pieces (i.e. as in C4.5).";
    }

    public String noPruningTipText() {
        return "Whether pruning is performed.";
    }

    public boolean getNoPruning() {
        return this.m_NoPruning;
    }

    public void setNoPruning(boolean bl) {
        this.m_NoPruning = bl;
    }

    public String minNumTipText() {
        return "The minimum total weight of the instances in a leaf.";
    }

    public double getMinNum() {
        return this.m_MinNum;
    }

    public void setMinNum(double d) {
        this.m_MinNum = d;
    }

    public String minVariancePropTipText() {
        return "The minimum proportion of the variance on all the data that needs to be present at a node in order for splitting to be performed in regression trees.";
    }

    public double getMinVarianceProp() {
        return this.m_MinVarianceProp;
    }

    public void setMinVarianceProp(double d) {
        this.m_MinVarianceProp = d;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data.";
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public String numFoldsTipText() {
        return "Determines the amount of data used for pruning. One fold is used for pruning, the rest for growing the rules.";
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int n) {
        this.m_NumFolds = n;
    }

    public String maxDepthTipText() {
        return "The maximum tree depth (-1 for no restriction).";
    }

    public int getMaxDepth() {
        return this.m_MaxDepth;
    }

    public void setMaxDepth(int n) {
        this.m_MaxDepth = n;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option("\tSet minimum number of instances per leaf (default 2).", "M", 1, "-M <minimum number of instances>"));
        vector.addElement(new Option("\tSet minimum numeric class variance proportion\n\tof train variance for split (default 1e-3).", "V", 1, "-V <minimum variance for split>"));
        vector.addElement(new Option("\tNumber of folds for reduced error pruning (default 3).", "N", 1, "-N <number of folds>"));
        vector.addElement(new Option("\tSeed for random data shuffling (default 1).", "S", 1, "-S <seed>"));
        vector.addElement(new Option("\tNo pruning.", "P", 0, "-P"));
        vector.addElement(new Option("\tMaximum tree depth (default -1, no maximum)", "L", 1, "-L"));
        return vector.elements();
    }

    public String[] getOptions() {
        String[] stringArray = new String[12];
        int n = 0;
        stringArray[n++] = "-M";
        stringArray[n++] = "" + (int)this.getMinNum();
        stringArray[n++] = "-V";
        stringArray[n++] = "" + this.getMinVarianceProp();
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.getNumFolds();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSeed();
        stringArray[n++] = "-L";
        stringArray[n++] = "" + this.getMaxDepth();
        if (this.getNoPruning()) {
            stringArray[n++] = "-P";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('M', stringArray);
        this.m_MinNum = string.length() != 0 ? (double)Integer.parseInt(string) : 2.0;
        String string2 = Utils.getOption('V', stringArray);
        this.m_MinVarianceProp = string2.length() != 0 ? Double.parseDouble(string2) : 0.001;
        String string3 = Utils.getOption('N', stringArray);
        this.m_NumFolds = string3.length() != 0 ? Integer.parseInt(string3) : 3;
        String string4 = Utils.getOption('S', stringArray);
        this.m_Seed = string4.length() != 0 ? Integer.parseInt(string4) : 1;
        this.m_NoPruning = Utils.getFlag('P', stringArray);
        String string5 = Utils.getOption('L', stringArray);
        this.m_MaxDepth = string5.length() != 0 ? Integer.parseInt(string5) : -1;
        Utils.checkForRemainingOptions(stringArray);
    }

    public int numNodes() {
        return this.m_Tree.numNodes();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement("measureTreeSize");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.equalsIgnoreCase("measureTreeSize")) {
            return this.numNodes();
        }
        throw new IllegalArgumentException(string + " not supported (REPTree)");
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        Random random = new Random(this.m_Seed);
        this.m_zeroR = null;
        if (instances.numAttributes() == 1) {
            this.m_zeroR = new ZeroR();
            this.m_zeroR.buildClassifier(instances);
            return;
        }
        instances.randomize(random);
        if (instances.classAttribute().isNominal()) {
            instances.stratify(this.m_NumFolds);
        }
        Instances instances2 = null;
        Instances instances3 = null;
        if (!this.m_NoPruning) {
            instances2 = instances.trainCV(this.m_NumFolds, 0, random);
            instances3 = instances.testCV(this.m_NumFolds, 0);
        } else {
            instances2 = instances;
        }
        int[][] nArray = new int[instances2.numAttributes()][0];
        double[][] dArray = new double[instances2.numAttributes()][0];
        double[] dArray2 = new double[instances2.numInstances()];
        for (int i = 0; i < instances2.numAttributes(); ++i) {
            int n;
            if (i == instances2.classIndex()) continue;
            dArray[i] = new double[instances2.numInstances()];
            if (instances2.attribute(i).isNominal()) {
                Instance instance;
                int n2;
                nArray[i] = new int[instances2.numInstances()];
                n = 0;
                for (n2 = 0; n2 < instances2.numInstances(); ++n2) {
                    instance = instances2.instance(n2);
                    if (instance.isMissing(i)) continue;
                    nArray[i][n] = n2;
                    dArray[i][n] = instance.weight();
                    ++n;
                }
                for (n2 = 0; n2 < instances2.numInstances(); ++n2) {
                    instance = instances2.instance(n2);
                    if (!instance.isMissing(i)) continue;
                    nArray[i][n] = n2;
                    dArray[i][n] = instance.weight();
                    ++n;
                }
                continue;
            }
            for (n = 0; n < instances2.numInstances(); ++n) {
                Instance instance = instances2.instance(n);
                dArray2[n] = instance.value(i);
            }
            nArray[i] = Utils.sort(dArray2);
            for (n = 0; n < instances2.numInstances(); ++n) {
                dArray[i][n] = instances2.instance(nArray[i][n]).weight();
            }
        }
        double[] dArray3 = new double[instances2.numClasses()];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < instances2.numInstances(); ++i) {
            Instance instance = instances2.instance(i);
            if (instances.classAttribute().isNominal()) {
                int n = (int)instance.classValue();
                dArray3[n] = dArray3[n] + instance.weight();
                d += instance.weight();
                continue;
            }
            dArray3[0] = dArray3[0] + instance.classValue() * instance.weight();
            d2 += instance.classValue() * instance.classValue() * instance.weight();
            d += instance.weight();
        }
        this.m_Tree = new Tree();
        double d3 = 0.0;
        if (instances.classAttribute().isNumeric()) {
            d3 = this.m_Tree.singleVariance(dArray3[0], d2, d) / d;
            dArray3[0] = dArray3[0] / d;
        }
        this.m_Tree.buildTree(nArray, dArray, instances2, d, dArray3, new Instances(instances2, 0), this.m_MinNum, this.m_MinVarianceProp * d3, 0, this.m_MaxDepth);
        if (!this.m_NoPruning) {
            this.m_Tree.insertHoldOutSet(instances3);
            this.m_Tree.reducedErrorPrune();
            this.m_Tree.backfitHoldOutSet(instances3);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_zeroR != null) {
            return this.m_zeroR.distributionForInstance(instance);
        }
        return this.m_Tree.distributionForInstance(instance);
    }

    protected static long nextID() {
        return PRINTED_NODES++;
    }

    protected static void resetID() {
        PRINTED_NODES = 0L;
    }

    public String toSource(String string) throws Exception {
        if (this.m_Tree == null) {
            throw new Exception("REPTree: No model built yet.");
        }
        StringBuffer[] stringBufferArray = this.m_Tree.toSource(string, this.m_Tree);
        return "class " + string + " {\n\n" + "  public static double classify(Object [] i)\n" + "    throws Exception {\n\n" + "    double p = Double.NaN;\n" + stringBufferArray[0] + "    return p;\n" + "  }\n" + stringBufferArray[1] + "}\n";
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        if (this.m_Tree == null) {
            throw new Exception("REPTree: No model built yet.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.m_Tree.toGraph(stringBuffer, 0, null);
        String string = "digraph Tree {\nedge [style=bold]\n" + stringBuffer.toString() + "\n}\n";
        return string;
    }

    public String toString() {
        if (this.m_zeroR != null) {
            return "No attributes other than class. Using ZeroR.\n\n" + this.m_zeroR.toString();
        }
        if (this.m_Tree == null) {
            return "REPTree: No model built yet.";
        }
        return "\nREPTree\n============\n" + this.m_Tree.toString(0, null) + "\n" + "\nSize of the tree : " + this.numNodes();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.26 $");
    }

    public static void main(String[] stringArray) {
        REPTree.runClassifier(new REPTree(), stringArray);
    }

    protected class Tree
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -1635481717888437935L;
        protected Instances m_Info = null;
        protected Tree[] m_Successors;
        protected int m_Attribute = -1;
        protected double m_SplitPoint = Double.NaN;
        protected double[] m_Prop = null;
        protected double[] m_ClassProbs = null;
        protected double[] m_Distribution = null;
        protected double[] m_HoldOutDist = null;
        protected double m_HoldOutError = 0.0;

        protected Tree() {
        }

        protected double[] distributionForInstance(Instance instance) throws Exception {
            double[] dArray = null;
            if (this.m_Attribute > -1) {
                if (instance.isMissing(this.m_Attribute)) {
                    dArray = new double[this.m_Info.numClasses()];
                    for (int i = 0; i < this.m_Successors.length; ++i) {
                        double[] dArray2 = this.m_Successors[i].distributionForInstance(instance);
                        if (dArray2 == null) continue;
                        for (int j = 0; j < dArray2.length; ++j) {
                            int n = j;
                            dArray[n] = dArray[n] + this.m_Prop[i] * dArray2[j];
                        }
                    }
                } else {
                    dArray = this.m_Info.attribute(this.m_Attribute).isNominal() ? this.m_Successors[(int)instance.value(this.m_Attribute)].distributionForInstance(instance) : (instance.value(this.m_Attribute) < this.m_SplitPoint ? this.m_Successors[0].distributionForInstance(instance) : this.m_Successors[1].distributionForInstance(instance));
                }
            }
            if (this.m_Attribute == -1 || dArray == null) {
                return this.m_ClassProbs;
            }
            return dArray;
        }

        public final String sourceExpression(int n) {
            StringBuffer stringBuffer = null;
            if (n < 0) {
                return "i[" + this.m_Attribute + "] == null";
            }
            if (this.m_Info.attribute(this.m_Attribute).isNominal()) {
                stringBuffer = new StringBuffer("i[");
                stringBuffer.append(this.m_Attribute).append("]");
                stringBuffer.append(".equals(\"").append(this.m_Info.attribute(this.m_Attribute).value(n)).append("\")");
            } else {
                stringBuffer = new StringBuffer("");
                if (n == 0) {
                    stringBuffer.append("((Double)i[").append(this.m_Attribute).append("]).doubleValue() < ").append(this.m_SplitPoint);
                } else {
                    stringBuffer.append("true");
                }
            }
            return stringBuffer.toString();
        }

        public StringBuffer[] toSource(String string, Tree tree) throws Exception {
            StringBuffer[] stringBufferArray = new StringBuffer[2];
            double[] dArray = this.m_ClassProbs == null ? tree.m_ClassProbs : this.m_ClassProbs;
            long l = REPTree.nextID();
            if (this.m_Attribute == -1) {
                stringBufferArray[0] = new StringBuffer("\tp = ");
                if (this.m_Info.classAttribute().isNumeric()) {
                    stringBufferArray[0].append(dArray[0]);
                } else {
                    stringBufferArray[0].append(Utils.maxIndex(dArray));
                }
                stringBufferArray[0].append(";\n");
                stringBufferArray[1] = new StringBuffer("");
            } else {
                StringBuffer stringBuffer = new StringBuffer("");
                StringBuffer stringBuffer2 = new StringBuffer("");
                stringBuffer.append("  static double N").append(Integer.toHexString(this.hashCode()) + l).append("(Object []i) {\n").append("    double p = Double.NaN;\n");
                stringBuffer.append("    /* " + this.m_Info.attribute(this.m_Attribute).name() + " */\n");
                stringBuffer.append("    if (" + this.sourceExpression(-1) + ") {\n").append("      p = ");
                if (this.m_Info.classAttribute().isNumeric()) {
                    stringBuffer.append(dArray[0] + ";\n");
                } else {
                    stringBuffer.append(Utils.maxIndex(dArray) + ";\n");
                }
                stringBuffer.append("    } ");
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    Object[] objectArray;
                    stringBuffer.append("else if (" + this.sourceExpression(i) + ") {\n");
                    if (this.m_Successors[i].m_Attribute == -1) {
                        objectArray = this.m_Successors[i].m_ClassProbs;
                        if (objectArray == null) {
                            objectArray = this.m_ClassProbs;
                        }
                        stringBuffer.append("      p = ");
                        if (this.m_Info.classAttribute().isNumeric()) {
                            stringBuffer.append(objectArray[0] + ";\n");
                        } else {
                            stringBuffer.append(Utils.maxIndex(objectArray) + ";\n");
                        }
                    } else {
                        objectArray = this.m_Successors[i].toSource(string, this);
                        stringBuffer.append("" + objectArray[0]);
                        stringBuffer2.append("" + objectArray[1]);
                    }
                    stringBuffer.append("    } ");
                    if (i != this.m_Successors.length - 1) continue;
                    stringBuffer.append("\n");
                }
                stringBuffer.append("    return p;\n  }\n");
                stringBufferArray[0] = new StringBuffer("    p = " + string + ".N");
                stringBufferArray[0].append(Integer.toHexString(this.hashCode()) + l).append("(i);\n");
                stringBufferArray[1] = stringBuffer.append("" + stringBuffer2);
            }
            return stringBufferArray;
        }

        protected int toGraph(StringBuffer stringBuffer, int n, Tree tree) throws Exception {
            ++n;
            if (this.m_Attribute == -1) {
                stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + n + this.leafString(tree) + "\"" + "shape=box]\n");
            } else {
                stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + n + ": " + this.m_Info.attribute(this.m_Attribute).name() + "\"]\n");
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + "->" + "N" + Integer.toHexString(this.m_Successors[i].hashCode()) + " [label=\"");
                    if (this.m_Info.attribute(this.m_Attribute).isNumeric()) {
                        if (i == 0) {
                            stringBuffer.append(" < " + Utils.doubleToString(this.m_SplitPoint, 2));
                        } else {
                            stringBuffer.append(" >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                        }
                    } else {
                        stringBuffer.append(" = " + this.m_Info.attribute(this.m_Attribute).value(i));
                    }
                    stringBuffer.append("\"]\n");
                    n = this.m_Successors[i].toGraph(stringBuffer, n, this);
                }
            }
            return n;
        }

        protected String leafString(Tree tree) throws Exception {
            if (this.m_Info.classAttribute().isNumeric()) {
                double d = this.m_ClassProbs == null ? tree.m_ClassProbs[0] : this.m_ClassProbs[0];
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(" : " + Utils.doubleToString(d, 2));
                double d2 = 0.0;
                if (this.m_Distribution[1] > 0.0) {
                    d2 = this.m_Distribution[0] / this.m_Distribution[1];
                }
                stringBuffer.append(" (" + Utils.doubleToString(this.m_Distribution[1], 2) + "/" + Utils.doubleToString(d2, 2) + ")");
                d2 = 0.0;
                if (this.m_HoldOutDist[0] > 0.0) {
                    d2 = this.m_HoldOutError / this.m_HoldOutDist[0];
                }
                stringBuffer.append(" [" + Utils.doubleToString(this.m_HoldOutDist[0], 2) + "/" + Utils.doubleToString(d2, 2) + "]");
                return stringBuffer.toString();
            }
            int n = this.m_ClassProbs == null ? Utils.maxIndex(tree.m_ClassProbs) : Utils.maxIndex(this.m_ClassProbs);
            return " : " + this.m_Info.classAttribute().value(n) + " (" + Utils.doubleToString(Utils.sum(this.m_Distribution), 2) + "/" + Utils.doubleToString(Utils.sum(this.m_Distribution) - this.m_Distribution[n], 2) + ")" + " [" + Utils.doubleToString(Utils.sum(this.m_HoldOutDist), 2) + "/" + Utils.doubleToString(Utils.sum(this.m_HoldOutDist) - this.m_HoldOutDist[n], 2) + "]";
        }

        protected String toString(int n, Tree tree) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.m_Attribute == -1) {
                    return this.leafString(tree);
                }
                if (this.m_Info.attribute(this.m_Attribute).isNominal()) {
                    for (int i = 0; i < this.m_Successors.length; ++i) {
                        stringBuffer.append("\n");
                        for (int j = 0; j < n; ++j) {
                            stringBuffer.append("|   ");
                        }
                        stringBuffer.append(this.m_Info.attribute(this.m_Attribute).name() + " = " + this.m_Info.attribute(this.m_Attribute).value(i));
                        stringBuffer.append(this.m_Successors[i].toString(n + 1, this));
                    }
                } else {
                    int n2;
                    stringBuffer.append("\n");
                    for (n2 = 0; n2 < n; ++n2) {
                        stringBuffer.append("|   ");
                    }
                    stringBuffer.append(this.m_Info.attribute(this.m_Attribute).name() + " < " + Utils.doubleToString(this.m_SplitPoint, 2));
                    stringBuffer.append(this.m_Successors[0].toString(n + 1, this));
                    stringBuffer.append("\n");
                    for (n2 = 0; n2 < n; ++n2) {
                        stringBuffer.append("|   ");
                    }
                    stringBuffer.append(this.m_Info.attribute(this.m_Attribute).name() + " >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                    stringBuffer.append(this.m_Successors[1].toString(n + 1, this));
                }
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "Decision tree: tree can't be printed";
            }
        }

        protected void buildTree(int[][] nArray, double[][] dArray, Instances instances, double d, double[] dArray2, Instances instances2, double d2, double d3, int n, int n2) throws Exception {
            int n3;
            int n4;
            this.m_Info = instances2;
            this.m_HoldOutDist = new double[instances.numClasses()];
            int n5 = 0;
            if (instances.classIndex() == 0) {
                n5 = 1;
            }
            if (nArray[n5].length == 0) {
                this.m_Distribution = instances.classAttribute().isNumeric() ? new double[2] : new double[instances.numClasses()];
                this.m_ClassProbs = null;
                return;
            }
            double d4 = 0.0;
            if (instances.classAttribute().isNumeric()) {
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                for (n4 = 0; n4 < nArray[n5].length; ++n4) {
                    Instance instance = instances.instance(nArray[n5][n4]);
                    d5 += instance.classValue() * dArray[n5][n4];
                    d6 += instance.classValue() * instance.classValue() * dArray[n5][n4];
                    d7 += dArray[n5][n4];
                }
                d4 = this.singleVariance(d5, d6, d7);
            }
            this.m_ClassProbs = new double[dArray2.length];
            System.arraycopy(dArray2, 0, this.m_ClassProbs, 0, dArray2.length);
            if (d < 2.0 * d2 || instances.classAttribute().isNominal() && Utils.eq(this.m_ClassProbs[Utils.maxIndex(this.m_ClassProbs)], Utils.sum(this.m_ClassProbs)) || instances.classAttribute().isNumeric() && d4 / d < d3 || REPTree.this.m_MaxDepth >= 0 && n >= n2) {
                this.m_Attribute = -1;
                if (instances.classAttribute().isNominal()) {
                    this.m_Distribution = new double[this.m_ClassProbs.length];
                    for (int i = 0; i < this.m_ClassProbs.length; ++i) {
                        this.m_Distribution[i] = this.m_ClassProbs[i];
                    }
                    Utils.normalize(this.m_ClassProbs);
                } else {
                    this.m_Distribution = new double[2];
                    this.m_Distribution[0] = d4;
                    this.m_Distribution[1] = d;
                }
                return;
            }
            double[] dArray3 = new double[instances.numAttributes()];
            double[][][] dArray4 = new double[instances.numAttributes()][0][0];
            double[][] dArray5 = new double[instances.numAttributes()][0];
            double[][] dArray6 = new double[instances.numAttributes()][0];
            double[] dArray7 = new double[instances.numAttributes()];
            if (instances.classAttribute().isNominal()) {
                for (n3 = 0; n3 < instances.numAttributes(); ++n3) {
                    if (n3 == instances.classIndex()) continue;
                    dArray7[n3] = this.distribution(dArray5, dArray4, n3, nArray[n3], dArray[n3], dArray6, instances);
                    dArray3[n3] = this.gain(dArray4[n3], this.priorVal(dArray4[n3]));
                }
            } else {
                for (n3 = 0; n3 < instances.numAttributes(); ++n3) {
                    if (n3 == instances.classIndex()) continue;
                    dArray7[n3] = this.numericDistribution(dArray5, dArray4, n3, nArray[n3], dArray[n3], dArray6, instances, dArray3);
                }
            }
            this.m_Attribute = Utils.maxIndex(dArray3);
            n3 = dArray4[this.m_Attribute].length;
            n4 = 0;
            for (int i = 0; i < n3; ++i) {
                if (dArray6[this.m_Attribute][i] >= d2) {
                    ++n4;
                }
                if (n4 > 1) break;
            }
            if (dArray3[this.m_Attribute] > 0.0 && n4 > 1) {
                this.m_SplitPoint = dArray7[this.m_Attribute];
                this.m_Prop = dArray5[this.m_Attribute];
                int[][][] nArray2 = new int[n3][instances.numAttributes()][0];
                double[][][] dArray8 = new double[n3][instances.numAttributes()][0];
                this.splitData(nArray2, dArray8, this.m_Attribute, this.m_SplitPoint, nArray, dArray, instances);
                this.m_Successors = new Tree[n3];
                for (int i = 0; i < n3; ++i) {
                    this.m_Successors[i] = new Tree();
                    this.m_Successors[i].buildTree(nArray2[i], dArray8[i], instances, dArray6[this.m_Attribute][i], dArray4[this.m_Attribute][i], instances2, d2, d3, n + 1, n2);
                }
            } else {
                this.m_Attribute = -1;
            }
            if (instances.classAttribute().isNominal()) {
                this.m_Distribution = new double[this.m_ClassProbs.length];
                for (int i = 0; i < this.m_ClassProbs.length; ++i) {
                    this.m_Distribution[i] = this.m_ClassProbs[i];
                }
                Utils.normalize(this.m_ClassProbs);
            } else {
                this.m_Distribution = new double[2];
                this.m_Distribution[0] = d4;
                this.m_Distribution[1] = d;
            }
        }

        protected int numNodes() {
            if (this.m_Attribute == -1) {
                return 1;
            }
            int n = 1;
            for (int i = 0; i < this.m_Successors.length; ++i) {
                n += this.m_Successors[i].numNodes();
            }
            return n;
        }

        protected void splitData(int[][][] nArray, double[][][] dArray, int n, double d, int[][] nArray2, double[][] dArray2, Instances instances) throws Exception {
            for (int i = 0; i < instances.numAttributes(); ++i) {
                int n2;
                int n3;
                int[] nArray3;
                if (i == instances.classIndex()) continue;
                if (instances.attribute(n).isNominal()) {
                    nArray3 = new int[instances.attribute(n).numValues()];
                    for (n3 = 0; n3 < nArray3.length; ++n3) {
                        nArray[n3][i] = new int[nArray2[i].length];
                        dArray[n3][i] = new double[nArray2[i].length];
                    }
                    for (n2 = 0; n2 < nArray2[i].length; ++n2) {
                        int n4;
                        Instance instance = instances.instance(nArray2[i][n2]);
                        if (instance.isMissing(n)) {
                            for (n4 = 0; n4 < nArray3.length; ++n4) {
                                if (!(this.m_Prop[n4] > 0.0)) continue;
                                nArray[n4][i][nArray3[n4]] = nArray2[i][n2];
                                dArray[n4][i][nArray3[n4]] = this.m_Prop[n4] * dArray2[i][n2];
                                int n5 = n4;
                                nArray3[n5] = nArray3[n5] + 1;
                            }
                            continue;
                        }
                        n4 = (int)instance.value(n);
                        nArray[n4][i][nArray3[n4]] = nArray2[i][n2];
                        dArray[n4][i][nArray3[n4]] = dArray2[i][n2];
                        int n6 = n4;
                        nArray3[n6] = nArray3[n6] + 1;
                    }
                } else {
                    nArray3 = new int[2];
                    for (n3 = 0; n3 < 2; ++n3) {
                        nArray[n3][i] = new int[nArray2[i].length];
                        dArray[n3][i] = new double[dArray2[i].length];
                    }
                    for (n2 = 0; n2 < nArray2[i].length; ++n2) {
                        int n7;
                        Instance instance = instances.instance(nArray2[i][n2]);
                        if (instance.isMissing(n)) {
                            for (n7 = 0; n7 < nArray3.length; ++n7) {
                                if (!(this.m_Prop[n7] > 0.0)) continue;
                                nArray[n7][i][nArray3[n7]] = nArray2[i][n2];
                                dArray[n7][i][nArray3[n7]] = this.m_Prop[n7] * dArray2[i][n2];
                                int n8 = n7;
                                nArray3[n8] = nArray3[n8] + 1;
                            }
                            continue;
                        }
                        n7 = instance.value(n) < d ? 0 : 1;
                        nArray[n7][i][nArray3[n7]] = nArray2[i][n2];
                        dArray[n7][i][nArray3[n7]] = dArray2[i][n2];
                        int n9 = n7;
                        nArray3[n9] = nArray3[n9] + 1;
                    }
                }
                for (n3 = 0; n3 < nArray3.length; ++n3) {
                    int[] nArray4 = new int[nArray3[n3]];
                    System.arraycopy(nArray[n3][i], 0, nArray4, 0, nArray3[n3]);
                    nArray[n3][i] = nArray4;
                    double[] dArray3 = new double[nArray3[n3]];
                    System.arraycopy(dArray[n3][i], 0, dArray3, 0, nArray3[n3]);
                    dArray[n3][i] = dArray3;
                }
            }
        }

        protected double distribution(double[][] dArray, double[][][] dArray2, int n, int[] nArray, double[] dArray3, double[][] dArray4, Instances instances) throws Exception {
            int n2;
            Object object;
            int n3;
            double d = Double.NaN;
            Attribute attribute = instances.attribute(n);
            double[][] dArray5 = null;
            if (attribute.isNominal()) {
                dArray5 = new double[attribute.numValues()][instances.numClasses()];
                for (n3 = 0; n3 < nArray.length && !((Instance)(object = (Object)instances.instance(nArray[n3]))).isMissing(n); ++n3) {
                    double[] dArray6 = dArray5[(int)((Instance)object).value(n)];
                    int n4 = (int)((Instance)object).classValue();
                    dArray6[n4] = dArray6[n4] + dArray3[n3];
                }
            } else {
                Instance instance;
                Instance instance2;
                object = new double[2][instances.numClasses()];
                dArray5 = new double[2][instances.numClasses()];
                for (int i = 0; i < nArray.length && !(instance2 = instances.instance(nArray[i])).isMissing(n); ++i) {
                    Object object2 = object[1];
                    int n5 = (int)instance2.classValue();
                    object2[n5] = object2[n5] + dArray3[i];
                }
                double d2 = this.priorVal((double[][])object);
                System.arraycopy(object[1], 0, dArray5[1], 0, dArray5[1].length);
                double d3 = instances.instance(nArray[0]).value(n);
                double d4 = -1.7976931348623157E308;
                for (n3 = 0; n3 < nArray.length && !(instance = instances.instance(nArray[n3])).isMissing(n); ++n3) {
                    double d5;
                    if (instance.value(n) > d3 && (d5 = this.gain((double[][])object, d2)) > d4) {
                        d4 = d5;
                        d = (instance.value(n) + d3) / 2.0;
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            System.arraycopy(object[i], 0, dArray5[i], 0, dArray5[i].length);
                        }
                    }
                    d3 = instance.value(n);
                    Object object3 = object[0];
                    int n6 = (int)instance.classValue();
                    object3[n6] = object3[n6] + dArray3[n3];
                    Object object4 = object[1];
                    int n7 = (int)instance.classValue();
                    object4[n7] = object4[n7] - dArray3[n3];
                }
            }
            dArray[n] = new double[dArray5.length];
            for (n2 = 0; n2 < dArray[n].length; ++n2) {
                dArray[n][n2] = Utils.sum(dArray5[n2]);
            }
            if (!(Utils.sum(dArray[n]) > 0.0)) {
                for (n2 = 0; n2 < dArray[n].length; ++n2) {
                    dArray[n][n2] = 1.0 / (double)dArray[n].length;
                }
            } else {
                Utils.normalize(dArray[n]);
            }
            while (n3 < nArray.length) {
                Instance instance = instances.instance(nArray[n3]);
                for (int i = 0; i < dArray5.length; ++i) {
                    double[] dArray7 = dArray5[i];
                    int n8 = (int)instance.classValue();
                    dArray7[n8] = dArray7[n8] + dArray[n][i] * dArray3[n3];
                }
                ++n3;
            }
            dArray4[n] = new double[dArray5.length];
            for (int i = 0; i < dArray5.length; ++i) {
                double[] dArray8 = dArray4[n];
                int n9 = i;
                dArray8[n9] = dArray8[n9] + Utils.sum(dArray5[i]);
            }
            dArray2[n] = dArray5;
            return d;
        }

        protected double numericDistribution(double[][] dArray, double[][][] dArray2, int n, int[] nArray, double[] dArray3, double[][] dArray4, Instances instances, double[] dArray5) throws Exception {
            int n2;
            Object object;
            int n3;
            double d = Double.NaN;
            Attribute attribute = instances.attribute(n);
            double[][] dArray6 = null;
            double[] dArray7 = null;
            double[] dArray8 = null;
            double[] dArray9 = null;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            if (attribute.isNominal()) {
                dArray7 = new double[attribute.numValues()];
                dArray8 = new double[attribute.numValues()];
                dArray9 = new double[attribute.numValues()];
                for (n3 = 0; n3 < nArray.length && !((Instance)(object = (Object)instances.instance(nArray[n3]))).isMissing(n); ++n3) {
                    int n4;
                    int n5 = n4 = (int)((Instance)object).value(n);
                    dArray7[n5] = dArray7[n5] + ((Instance)object).classValue() * dArray3[n3];
                    int n6 = n4;
                    dArray8[n6] = dArray8[n6] + ((Instance)object).classValue() * ((Instance)object).classValue() * dArray3[n3];
                    int n7 = n4;
                    dArray9[n7] = dArray9[n7] + dArray3[n3];
                }
                d2 = Utils.sum(dArray7);
                d3 = Utils.sum(dArray8);
                d4 = Utils.sum(dArray9);
            } else {
                Instance instance;
                Instance instance2;
                dArray7 = new double[2];
                dArray8 = new double[2];
                dArray9 = new double[2];
                double[] dArray10 = new double[2];
                object = new double[2];
                double[] dArray11 = new double[2];
                for (int i = 0; i < nArray.length && !(instance2 = instances.instance(nArray[i])).isMissing(n); ++i) {
                    dArray10[1] = dArray10[1] + instance2.classValue() * dArray3[i];
                    Object object2 = object;
                    object2[1] = object2[1] + instance2.classValue() * instance2.classValue() * dArray3[i];
                    dArray11[1] = dArray11[1] + dArray3[i];
                }
                d2 = dArray10[1];
                d3 = (double)object[1];
                d4 = dArray11[1];
                dArray7[1] = dArray10[1];
                dArray8[1] = (double)object[1];
                dArray9[1] = dArray11[1];
                double d5 = instances.instance(nArray[0]).value(n);
                double d6 = Double.MAX_VALUE;
                for (n3 = 0; n3 < nArray.length && !(instance = instances.instance(nArray[n3])).isMissing(n); ++n3) {
                    double d7;
                    if (instance.value(n) > d5 && (d7 = this.variance(dArray10, (double[])object, dArray11)) < d6) {
                        d6 = d7;
                        d = (instance.value(n) + d5) / 2.0;
                        for (int i = 0; i < 2; ++i) {
                            dArray7[i] = dArray10[i];
                            dArray8[i] = (double)object[i];
                            dArray9[i] = dArray11[i];
                        }
                    }
                    d5 = instance.value(n);
                    double d8 = instance.classValue() * dArray3[n3];
                    double d9 = instance.classValue() * d8;
                    dArray10[0] = dArray10[0] + d8;
                    Object object3 = object;
                    object3[0] = object3[0] + d9;
                    dArray11[0] = dArray11[0] + dArray3[n3];
                    dArray10[1] = dArray10[1] - d8;
                    Object object4 = object;
                    object4[1] = object4[1] - d9;
                    dArray11[1] = dArray11[1] - dArray3[n3];
                }
            }
            dArray[n] = new double[dArray7.length];
            for (n2 = 0; n2 < dArray[n].length; ++n2) {
                dArray[n][n2] = dArray9[n2];
            }
            if (!(Utils.sum(dArray[n]) > 0.0)) {
                for (n2 = 0; n2 < dArray[n].length; ++n2) {
                    dArray[n][n2] = 1.0 / (double)dArray[n].length;
                }
            } else {
                Utils.normalize(dArray[n]);
            }
            while (n3 < nArray.length) {
                Instance instance = instances.instance(nArray[n3]);
                for (int i = 0; i < dArray7.length; ++i) {
                    int n8 = i;
                    dArray7[n8] = dArray7[n8] + dArray[n][i] * instance.classValue() * dArray3[n3];
                    int n9 = i;
                    dArray8[n9] = dArray8[n9] + dArray[n][i] * instance.classValue() * instance.classValue() * dArray3[n3];
                    int n10 = i;
                    dArray9[n10] = dArray9[n10] + dArray[n][i] * dArray3[n3];
                }
                d2 += instance.classValue() * dArray3[n3];
                d3 += instance.classValue() * instance.classValue() * dArray3[n3];
                d4 += dArray3[n3];
                ++n3;
            }
            dArray6 = new double[dArray7.length][instances.numClasses()];
            for (int i = 0; i < dArray7.length; ++i) {
                dArray6[i][0] = dArray9[i] > 0.0 ? dArray7[i] / dArray9[i] : d2 / d4;
            }
            double d10 = this.singleVariance(d2, d3, d4);
            double d11 = this.variance(dArray7, dArray8, dArray9);
            double d12 = d10 - d11;
            dArray4[n] = dArray9;
            dArray2[n] = dArray6;
            dArray5[n] = d12;
            return d;
        }

        protected double variance(double[] dArray, double[] dArray2, double[] dArray3) {
            double d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray3[i] > 0.0)) continue;
                d += this.singleVariance(dArray[i], dArray2[i], dArray3[i]);
            }
            return d;
        }

        protected double singleVariance(double d, double d2, double d3) {
            return d2 - d * d / d3;
        }

        protected double priorVal(double[][] dArray) {
            return ContingencyTables.entropyOverColumns(dArray);
        }

        protected double gain(double[][] dArray, double d) {
            return d - ContingencyTables.entropyConditionedOnRows(dArray);
        }

        protected double reducedErrorPrune() throws Exception {
            if (this.m_Attribute == -1) {
                return this.m_HoldOutError;
            }
            double d = 0.0;
            for (int i = 0; i < this.m_Successors.length; ++i) {
                d += this.m_Successors[i].reducedErrorPrune();
            }
            if (d >= this.m_HoldOutError) {
                this.m_Attribute = -1;
                this.m_Successors = null;
                return this.m_HoldOutError;
            }
            return d;
        }

        protected void insertHoldOutSet(Instances instances) throws Exception {
            for (int i = 0; i < instances.numInstances(); ++i) {
                this.insertHoldOutInstance(instances.instance(i), instances.instance(i).weight(), this);
            }
        }

        protected void insertHoldOutInstance(Instance instance, double d, Tree tree) throws Exception {
            if (instance.classAttribute().isNominal()) {
                int n = (int)instance.classValue();
                this.m_HoldOutDist[n] = this.m_HoldOutDist[n] + d;
                int n2 = 0;
                n2 = this.m_ClassProbs == null ? Utils.maxIndex(tree.m_ClassProbs) : Utils.maxIndex(this.m_ClassProbs);
                if (n2 != (int)instance.classValue()) {
                    this.m_HoldOutError += d;
                }
            } else {
                this.m_HoldOutDist[0] = this.m_HoldOutDist[0] + d;
                double d2 = 0.0;
                d2 = this.m_ClassProbs == null ? tree.m_ClassProbs[0] - instance.classValue() : this.m_ClassProbs[0] - instance.classValue();
                this.m_HoldOutError += d2 * d2 * d;
            }
            if (this.m_Attribute != -1) {
                if (instance.isMissing(this.m_Attribute)) {
                    for (int i = 0; i < this.m_Successors.length; ++i) {
                        if (!(this.m_Prop[i] > 0.0)) continue;
                        this.m_Successors[i].insertHoldOutInstance(instance, d * this.m_Prop[i], this);
                    }
                } else if (this.m_Info.attribute(this.m_Attribute).isNominal()) {
                    this.m_Successors[(int)instance.value(this.m_Attribute)].insertHoldOutInstance(instance, d, this);
                } else if (instance.value(this.m_Attribute) < this.m_SplitPoint) {
                    this.m_Successors[0].insertHoldOutInstance(instance, d, this);
                } else {
                    this.m_Successors[1].insertHoldOutInstance(instance, d, this);
                }
            }
        }

        protected void backfitHoldOutSet(Instances instances) throws Exception {
            for (int i = 0; i < instances.numInstances(); ++i) {
                this.backfitHoldOutInstance(instances.instance(i), instances.instance(i).weight(), this);
            }
        }

        protected void backfitHoldOutInstance(Instance instance, double d, Tree tree) throws Exception {
            if (instance.classAttribute().isNominal()) {
                if (this.m_ClassProbs == null) {
                    this.m_ClassProbs = new double[instance.numClasses()];
                }
                System.arraycopy(this.m_Distribution, 0, this.m_ClassProbs, 0, instance.numClasses());
                int n = (int)instance.classValue();
                this.m_ClassProbs[n] = this.m_ClassProbs[n] + d;
                Utils.normalize(this.m_ClassProbs);
            } else {
                if (this.m_ClassProbs == null) {
                    this.m_ClassProbs = new double[1];
                }
                this.m_ClassProbs[0] = this.m_ClassProbs[0] * this.m_Distribution[1];
                this.m_ClassProbs[0] = this.m_ClassProbs[0] + d * instance.classValue();
                this.m_ClassProbs[0] = this.m_ClassProbs[0] / (this.m_Distribution[1] + d);
            }
            if (this.m_Attribute != -1) {
                if (instance.isMissing(this.m_Attribute)) {
                    for (int i = 0; i < this.m_Successors.length; ++i) {
                        if (!(this.m_Prop[i] > 0.0)) continue;
                        this.m_Successors[i].backfitHoldOutInstance(instance, d * this.m_Prop[i], this);
                    }
                } else if (this.m_Info.attribute(this.m_Attribute).isNominal()) {
                    this.m_Successors[(int)instance.value(this.m_Attribute)].backfitHoldOutInstance(instance, d, this);
                } else if (instance.value(this.m_Attribute) < this.m_SplitPoint) {
                    this.m_Successors[0].backfitHoldOutInstance(instance, d, this);
                } else {
                    this.m_Successors[1].backfitHoldOutInstance(instance, d, this);
                }
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.26 $");
        }
    }
}

