/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.beancontext.BeanContext;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ArffLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.DatabaseLoader;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;
import weka.gui.beans.AbstractDataSource;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.Startable;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Loader
extends AbstractDataSource
implements Startable,
UserRequestAcceptor,
WekaWrapper,
EventConstraints {
    private static final long serialVersionUID = 1993738191961163027L;
    private transient Instances m_dataSet;
    private transient Instances m_dataFormat;
    protected String m_globalInfo;
    private LoadThread m_ioThread;
    private static int IDLE = 0;
    private static int BATCH_LOADING = 1;
    private static int INCREMENTAL_LOADING = 2;
    private int m_state = IDLE;
    private weka.core.converters.Loader m_Loader = new ArffLoader();
    private InstanceEvent m_ie = new InstanceEvent(this);
    private int m_instanceEventTargets = 0;
    private int m_dataSetEventTargets = 0;
    private boolean m_dbSet = false;

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Loader() {
        this.setLoader(this.m_Loader);
        this.appearanceFinal();
    }

    public void setDB(boolean bl) {
        this.m_dbSet = bl;
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JButton jButton = new JButton("Start...");
        this.add((Component)jButton, "Center");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Loader.this.startLoading();
            }
        });
    }

    protected void appearanceDesign() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    public void setBeanContext(BeanContext beanContext) {
        super.setBeanContext(beanContext);
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            this.appearanceFinal();
        }
    }

    public void setLoader(weka.core.converters.Loader loader) {
        boolean bl = true;
        if (loader.getClass().getName().compareTo(this.m_Loader.getClass().getName()) == 0) {
            bl = false;
        }
        this.m_Loader = loader;
        String string = loader.getClass().toString();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (bl) {
            if (this.m_Loader instanceof Visible) {
                this.m_visual = ((Visible)((Object)this.m_Loader)).getVisual();
            } else if (!this.m_visual.loadIcons("weka/gui/beans/icons/" + string + ".gif", "weka/gui/beans/icons/" + string + "_animated.gif")) {
                this.useDefaultVisual();
            }
        }
        this.m_visual.setText(string);
        if (!(loader instanceof DatabaseLoader)) {
            try {
                this.m_dataFormat = this.m_Loader.getStructure();
                System.out.println("[Loader] Notifying listeners of instance structure avail.");
                this.notifyStructureAvailable(this.m_dataFormat);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Loader);
    }

    public weka.core.converters.Loader getLoader() {
        return this.m_Loader;
    }

    public void setWrappedAlgorithm(Object object) {
        if (!(object instanceof weka.core.converters.Loader)) {
            throw new IllegalArgumentException(object.getClass() + " : incorrect " + "type of algorithm (Loader)");
        }
        this.setLoader((weka.core.converters.Loader)object);
    }

    public Object getWrappedAlgorithm() {
        return this.getLoader();
    }

    protected void notifyStructureAvailable(Instances instances) {
        if (this.m_dataSetEventTargets > 0 && instances != null) {
            DataSetEvent dataSetEvent = new DataSetEvent(this, instances);
            this.notifyDataSetLoaded(dataSetEvent);
        } else if (this.m_instanceEventTargets > 0 && instances != null) {
            this.m_ie.setStructure(instances);
            this.notifyInstanceLoaded(this.m_ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataSetLoaded(DataSetEvent dataSetEvent) {
        Vector vector;
        Loader loader = this;
        synchronized (loader) {
            vector = (Vector)this.m_listeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((DataSourceListener)vector.elementAt(i)).acceptDataSet(dataSetEvent);
            }
            this.m_dataSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceLoaded(InstanceEvent instanceEvent) {
        Vector vector;
        Loader loader = this;
        synchronized (loader) {
            vector = (Vector)this.m_listeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((InstanceListener)vector.elementAt(i)).acceptInstance(instanceEvent);
            }
            this.m_dataSet = null;
        }
    }

    public void startLoading() {
        if (this.m_ioThread == null) {
            this.m_state = BATCH_LOADING;
            this.m_ioThread = new LoadThread(this);
            this.m_ioThread.setPriority(1);
            this.m_ioThread.start();
        } else {
            this.m_ioThread = null;
            this.m_state = IDLE;
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        boolean bl = true;
        if (this.m_ioThread == null) {
            if (this.m_Loader instanceof FileSourcedConverter && !((FileSourcedConverter)((Object)this.m_Loader)).retrieveFile().isFile()) {
                bl = false;
            }
            String string = "Start loading";
            if (!bl) {
                string = "$" + string;
            }
            vector.addElement(string);
        }
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Start loading") != 0) {
            throw new IllegalArgumentException(string + " not supported (Loader)");
        }
        this.startLoading();
    }

    public void start() throws Exception {
        this.startLoading();
        this.block(true);
    }

    private synchronized void block(boolean bl) {
        if (bl) {
            try {
                if (this.m_ioThread.isAlive() && this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public boolean eventGeneratable(String string) {
        if (string.compareTo("instance") == 0) {
            if (!(this.m_Loader instanceof IncrementalConverter)) {
                return false;
            }
            if (this.m_dataSetEventTargets > 0) {
                return false;
            }
        }
        if (string.compareTo("dataSet") == 0) {
            if (!(this.m_Loader instanceof BatchConverter)) {
                return false;
            }
            if (this.m_instanceEventTargets > 0) {
                return false;
            }
        }
        return true;
    }

    public synchronized void addDataSourceListener(DataSourceListener dataSourceListener) {
        super.addDataSourceListener(dataSourceListener);
        ++this.m_dataSetEventTargets;
        try {
            if (this.m_Loader instanceof DatabaseLoader && this.m_dbSet && this.m_dataFormat == null || !(this.m_Loader instanceof DatabaseLoader) && this.m_dataFormat == null) {
                this.m_dataFormat = this.m_Loader.getStructure();
                this.m_dbSet = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyStructureAvailable(this.m_dataFormat);
    }

    public synchronized void removeDataSourceListener(DataSourceListener dataSourceListener) {
        super.removeDataSourceListener(dataSourceListener);
        --this.m_dataSetEventTargets;
    }

    public synchronized void addInstanceListener(InstanceListener instanceListener) {
        super.addInstanceListener(instanceListener);
        ++this.m_instanceEventTargets;
        try {
            if (this.m_Loader instanceof DatabaseLoader && this.m_dbSet && this.m_dataFormat == null || !(this.m_Loader instanceof DatabaseLoader) && this.m_dataFormat == null) {
                this.m_dataFormat = this.m_Loader.getStructure();
                this.m_dbSet = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyStructureAvailable(this.m_dataFormat);
    }

    public synchronized void removeInstanceListener(InstanceListener instanceListener) {
        super.removeInstanceListener(instanceListener);
        --this.m_instanceEventTargets;
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            Loader loader = new Loader();
            jFrame.getContentPane().add((Component)loader, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.m_Loader != null) {
            try {
                this.m_Loader.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    private class LoadThread
    extends Thread {
        private DataSource m_DP;

        public LoadThread(DataSource dataSource) {
            this.m_DP = dataSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block13: {
                try {
                    Loader.this.m_visual.setAnimated();
                    Loader.this.m_visual.setText("Loading...");
                    boolean bl = true;
                    if (Loader.this.m_dataSetEventTargets > 0) {
                        bl = false;
                        Loader.this.m_state = BATCH_LOADING;
                    }
                    if (bl) {
                        Loader.this.m_state = INCREMENTAL_LOADING;
                        Instance instance = null;
                        Instances instances = null;
                        try {
                            Loader.this.m_Loader.reset();
                            instances = Loader.this.m_Loader.getStructure();
                            Loader.this.notifyStructureAvailable(instances);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        try {
                            instance = Loader.this.m_Loader.getNextInstance(instances);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        int n = 0;
                        while (instance != null) {
                            instance.setDataset(instances);
                            Loader.this.m_ie.setStatus(1);
                            Loader.this.m_ie.setInstance(instance);
                            instance = Loader.this.m_Loader.getNextInstance(instances);
                            if (instance == null) {
                                Loader.this.m_ie.setStatus(2);
                            }
                            Loader.this.notifyInstanceLoaded(Loader.this.m_ie);
                            if (++n % 10000 != 0) continue;
                            Loader.this.m_visual.setText("" + n + " instances...");
                        }
                        Loader.this.m_visual.setStatic();
                        Loader.this.m_visual.setText(instances.relationName());
                        break block13;
                    }
                    Loader.this.m_Loader.reset();
                    Loader.this.m_dataSet = Loader.this.m_Loader.getDataSet();
                    Loader.this.m_visual.setStatic();
                    Loader.this.m_visual.setText(Loader.this.m_dataSet.relationName());
                    Loader.this.notifyDataSetLoaded(new DataSetEvent(this.m_DP, Loader.this.m_dataSet));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    Loader.this.m_ioThread = null;
                    Loader.this.m_visual.setStatic();
                    Loader.this.m_state = IDLE;
                    Loader.this.block(false);
                }
            }
        }
    }
}

