/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.Javadoc;
import weka.core.Option;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class TechnicalInformationHandlerJavadoc
extends Javadoc {
    public static final String PLAINTEXT_STARTTAG = "<!-- technical-plaintext-start -->";
    public static final String PLAINTEXT_ENDTAG = "<!-- technical-plaintext-end -->";
    public static final String BIBTEX_STARTTAG = "<!-- technical-bibtex-start -->";
    public static final String BIBTEX_ENDTAG = "<!-- technical-bibtex-end -->";
    protected boolean m_Prolog = true;

    public TechnicalInformationHandlerJavadoc() {
        this.m_StartTag = new String[2];
        this.m_EndTag = new String[2];
        this.m_StartTag[0] = PLAINTEXT_STARTTAG;
        this.m_EndTag[0] = PLAINTEXT_ENDTAG;
        this.m_StartTag[1] = BIBTEX_STARTTAG;
        this.m_EndTag[1] = BIBTEX_ENDTAG;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tSuppresses the 'BibTex:' prolog in the Javadoc.", "noprolog", 0, "-noprolog"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        this.setProlog(!Utils.getFlag("noprolog", stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (!this.getProlog()) {
            vector.add("-noprolog");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setProlog(boolean bl) {
        this.m_Prolog = bl;
    }

    public boolean getProlog() {
        return this.m_Prolog;
    }

    protected String generateJavadoc(int n) throws Exception {
        String string = "";
        if (!this.canInstantiateClass()) {
            return string;
        }
        if (!ClassDiscovery.hasInterface(TechnicalInformationHandler.class, this.getInstance().getClass())) {
            throw new Exception("Class '" + this.getClassname() + "' is not a TechnicalInformationHandler!");
        }
        TechnicalInformationHandler technicalInformationHandler = (TechnicalInformationHandler)this.getInstance();
        switch (n) {
            case 0: {
                string = this.toHTML(technicalInformationHandler.getTechnicalInformation().toString()) + "\n";
                break;
            }
            case 1: {
                if (this.getProlog()) {
                    string = "BibTeX:\n";
                }
                string = string + "<pre>\n";
                string = string + this.toHTML(technicalInformationHandler.getTechnicalInformation().toBibTex()).replaceAll("<br/>", "") + "\n";
                string = string + "</pre>\n<p/>\n";
            }
        }
        if (this.getUseStars()) {
            string = this.indent(string, 1, "* ");
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            TechnicalInformationHandlerJavadoc technicalInformationHandlerJavadoc = new TechnicalInformationHandlerJavadoc();
            try {
                if (Utils.getFlag('h', stringArray)) {
                    throw new Exception("Help requested");
                }
                ((Javadoc)technicalInformationHandlerJavadoc).setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string = "\n" + exception.getMessage() + "\n\n" + technicalInformationHandlerJavadoc.generateHelp();
                throw new Exception(string);
            }
            System.out.println(technicalInformationHandlerJavadoc.generate() + "\n");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

