/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.Estimator;

public class KernelEstimator
implements Estimator {
    private double[] m_Values = new double[50];
    private double[] m_Weights = new double[50];
    private int m_NumValues = 0;
    private double m_SumOfWeights = 0.0;
    private double m_StandardDev;
    private double m_Precision;
    private boolean m_AllWeightsOne = true;
    private static double MAX_ERROR = 0.01;

    private int findNearestValue(double d) {
        int n = 0;
        int n2 = this.m_NumValues;
        int n3 = 0;
        while (n < n2) {
            n3 = (n + n2) / 2;
            double d2 = this.m_Values[n3];
            if (d2 == d) {
                return n3;
            }
            if (d2 > d) {
                n2 = n3;
                continue;
            }
            if (!(d2 < d)) continue;
            n = n3 + 1;
        }
        return n;
    }

    private double round(double d) {
        return Math.rint(d / this.m_Precision) * this.m_Precision;
    }

    public KernelEstimator(double d) {
        this.m_Precision = d;
        if (this.m_Precision < Utils.SMALL) {
            this.m_Precision = Utils.SMALL;
        }
        this.m_StandardDev = this.m_Precision / 6.0;
    }

    public void addValue(double d, double d2) {
        if (d2 == 0.0) {
            return;
        }
        int n = this.findNearestValue(d = this.round(d));
        if (this.m_NumValues <= n || this.m_Values[n] != d) {
            if (this.m_NumValues < this.m_Values.length) {
                int n2 = this.m_NumValues - n;
                System.arraycopy(this.m_Values, n, this.m_Values, n + 1, n2);
                System.arraycopy(this.m_Weights, n, this.m_Weights, n + 1, n2);
                this.m_Values[n] = d;
                this.m_Weights[n] = d2;
                ++this.m_NumValues;
            } else {
                double[] dArray = new double[this.m_Values.length * 2];
                double[] dArray2 = new double[this.m_Values.length * 2];
                int n3 = this.m_NumValues - n;
                System.arraycopy(this.m_Values, 0, dArray, 0, n);
                System.arraycopy(this.m_Weights, 0, dArray2, 0, n);
                dArray[n] = d;
                dArray2[n] = d2;
                System.arraycopy(this.m_Values, n, dArray, n + 1, n3);
                System.arraycopy(this.m_Weights, n, dArray2, n + 1, n3);
                ++this.m_NumValues;
                this.m_Values = dArray;
                this.m_Weights = dArray2;
            }
            if (d2 != 1.0) {
                this.m_AllWeightsOne = false;
            }
        } else {
            int n4 = n;
            this.m_Weights[n4] = this.m_Weights[n4] + d2;
            this.m_AllWeightsOne = false;
        }
        this.m_SumOfWeights += d2;
        double d3 = this.m_Values[this.m_NumValues - 1] - this.m_Values[0];
        if (d3 > 0.0) {
            this.m_StandardDev = Math.max(d3 / Math.sqrt(this.m_SumOfWeights), this.m_Precision / 6.0);
        }
    }

    public double getProbability(double d) {
        int n;
        int n2;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (this.m_NumValues == 0) {
            d5 = (d - this.m_Precision / 2.0) / this.m_StandardDev;
            d6 = (d + this.m_Precision / 2.0) / this.m_StandardDev;
            return Statistics.normalProbability(d6) - Statistics.normalProbability(d5);
        }
        double d7 = 0.0;
        for (n2 = n = this.findNearestValue(d); n2 < this.m_NumValues; ++n2) {
            d2 = this.m_Values[n2] - d;
            d5 = (d2 - this.m_Precision / 2.0) / this.m_StandardDev;
            d6 = (d2 + this.m_Precision / 2.0) / this.m_StandardDev;
            d4 = Statistics.normalProbability(d6) - Statistics.normalProbability(d5);
            if (d4 * (this.m_SumOfWeights - (d7 += this.m_Weights[n2])) < (d3 += d4 * this.m_Weights[n2]) * MAX_ERROR) break;
        }
        for (n2 = n - 1; n2 >= 0; --n2) {
            d2 = this.m_Values[n2] - d;
            d5 = (d2 - this.m_Precision / 2.0) / this.m_StandardDev;
            d6 = (d2 + this.m_Precision / 2.0) / this.m_StandardDev;
            d4 = Statistics.normalProbability(d6) - Statistics.normalProbability(d5);
            if (d4 * (this.m_SumOfWeights - (d7 += this.m_Weights[n2])) < (d3 += d4 * this.m_Weights[n2]) * MAX_ERROR) break;
        }
        return d3 / this.m_SumOfWeights;
    }

    public String toString() {
        String string = this.m_NumValues + " Normal Kernels. \nStandardDev = " + Utils.doubleToString(this.m_StandardDev, 6, 4) + " Precision = " + this.m_Precision;
        if (this.m_NumValues == 0) {
            string = string + "  \nMean = 0";
        } else {
            int n;
            string = string + "  \nMeans =";
            for (n = 0; n < this.m_NumValues; ++n) {
                string = string + " " + this.m_Values[n];
            }
            if (!this.m_AllWeightsOne) {
                string = string + "\nWeights = ";
                for (n = 0; n < this.m_NumValues; ++n) {
                    string = string + " " + this.m_Weights[n];
                }
            }
        }
        return string + "\n";
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 2) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            KernelEstimator kernelEstimator = new KernelEstimator(0.01);
            for (int i = 0; i < stringArray.length - 3; i += 2) {
                kernelEstimator.addValue(Double.valueOf(stringArray[i]), Double.valueOf(stringArray[i + 1]));
            }
            System.out.println(kernelEstimator);
            double d = Double.valueOf(stringArray[stringArray.length - 2]);
            double d2 = Double.valueOf(stringArray[stringArray.length - 1]);
            for (double d3 = d; d3 < d2; d3 += (d2 - d) / 50.0) {
                System.out.println("Data: " + d3 + " " + kernelEstimator.getProbability(d3));
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

