% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scelestial.R
\name{distance.matrix.scelestial}
\alias{distance.matrix.scelestial}
\title{Calculates distance matrix for result of scelestial}
\usage{
distance.matrix.scelestial(SP, normalize = TRUE)
}
\arguments{
\item{SP}{Output of scelestial function}

\item{normalize}{If true, sum of all elements of resulting
table is added up to one.}
}
\value{
The distance matrix
}
\description{
Calculates distance matrix for result of scelestial
}
\examples{
## Synthesise an evolution
S = synthesis(10, 5, 20, seed=7)
## Run Scelestial
SC = scelestial(as.ten.state.matrix(S$seqeunce))
## Calculate the distance matrix
distance.matrix.scelestial(SC)
#              C1         C10          C2          C3          C4
# C1  0.000000000 0.003512891 0.015222451 0.014051472 0.008196692
# C10 0.003512891 0.000000000 0.011709560 0.010538580 0.004683800
# C2  0.015222451 0.011709560 0.000000000 0.010538627 0.007025759
# C3  0.014051472 0.010538580 0.010538627 0.000000000 0.005854780
# C4  0.008196692 0.004683800 0.007025759 0.005854780 0.000000000
# C5  0.011709560 0.008196668 0.003512891 0.007025736 0.003512868
# C6  0.023419213 0.019906322 0.019906368 0.009367741 0.015222521
# C7  0.018735342 0.015222451 0.015222498 0.004683871 0.010538651
# C8  0.015222474 0.011709583 0.014051542 0.012880562 0.007025783
# C9  0.010538627 0.007025736 0.009367695 0.008196715 0.002341935
# C5          C6          C7          C8          C9
# C1  0.011709560 0.023419213 0.018735342 0.015222474 0.010538627
# C10 0.008196668 0.019906322 0.015222451 0.011709583 0.007025736
# C2  0.003512891 0.019906368 0.015222498 0.014051542 0.009367695
# C3  0.007025736 0.009367741 0.004683871 0.012880562 0.008196715
# C4  0.003512868 0.015222521 0.010538651 0.007025783 0.002341935
# C5  0.000000000 0.016393477 0.011709606 0.010538651 0.005854803
# C6  0.016393477 0.000000000 0.004683871 0.022248304 0.017564457
# C7  0.011709606 0.004683871 0.000000000 0.017564433 0.012880586
# C8  0.010538651 0.022248304 0.017564433 0.000000000 0.004683847
# C9  0.005854803 0.017564457 0.012880586 0.004683847 0.000000000

}
