% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Saha}
\alias{Saha}
\title{Saha model}
\usage{
Saha(z,mu,sigma,pi,type=c("total","mean"),cl,N=NULL,method="srswr")
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{mu}{vector with the means of the scramble variables \eqn{W} and \eqn{U}}

\item{sigma}{vector with the standard deviations of the scramble variables \eqn{W} and \eqn{U}}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{method}{method used to draw the sample: srswr or srswor. By default it is srswr}
}
\value{
Point and confidence estimates of the sensitive characteristics using the Saha model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the Saha model.
The function can also return the transformed variable.
The Saha model was proposed by Saha in 2007.
}
\details{
In the Saha model, each respondent selected is asked to report the randomized response \eqn{z_i=W(y_i+U)} where \eqn{W,U} are scramble variables whose distribution
is assumed to be known.

To estimate \eqn{\bar{Y}} a sample of respondents is selected according to simple random sampling with replacement.
The transformed variable is
\deqn{r_i=\frac{z_i-\mu_W\mu_U}{\mu_W}}
where \eqn{\mu_W,\mu_U} are the means of \eqn{W,U} scramble variables respectively

The estimated variance in this model is
\deqn{\widehat{V}(\widehat{\bar{Y}}_R)=\frac{s_z^2}{n\mu_W^2}}
where \eqn{s_z^2=\sum_{i=1}^n\frac{(z_i-\bar{z})^2}{n-1}}.

If the sample is selected by simple random sampling without replacement, the estimated variance is
\deqn{\widehat{V}(\widehat{\bar{Y}}_R)=\frac{s_z^2}{n\mu_W^2}\left(1-\frac{n}{N}\right)}
}
\examples{
N=228
data(SahaData)
dat=with(SahaData,data.frame(z,Pi))
mu=c(1.5,5.5)
sigma=sqrt(c(1/12,81/12))
cl=0.95
Saha(dat$z,mu,sigma,dat$Pi,"mean",cl,N)
}
\references{
Saha, A. (2007).
\emph{A simple randomized response technique in complex surveys.}
Metron LXV, 59-66.
}
\seealso{
\code{\link{SahaData}}

\code{\link{ResamplingVariance}}
}
\keyword{Confidence_interval}
\keyword{Estimation}
\keyword{Quantitative}
\keyword{Randomized_response}
\keyword{Saha}
\keyword{Transformed_variable}
\keyword{Variance}

