% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamllik.R
\name{gamllik}
\alias{gamllik}
\title{Log likelihood from the gamma distribution}
\usage{
gamllik(structtime,structttot,structdeaths,time_die,ttot,deaths)
}
\arguments{
\item{structtime}{change-point times to be used to compute the likelihood value}

\item{structttot}{total time on test (ttot) between each time point and the previous time point (or 0) corresponding to structtime}

\item{structdeaths}{number of deaths corresponding to structttot}

\item{time_die}{all event and censoring times from small to large}

\item{ttot}{total time on test corresponding to time_die}

\item{deaths}{the number of deaths corresponding to "ttot"}
}
\value{
log of the likelihood
}
\description{
A function computing the log likelihood from the gamma distribution under an order restriction reduction
}
\examples{
time_die <- c(0.05,0.08,0.38,0.41,0.64)
ttot <- c(9.2,5.8,52.1,5.8,40.0)
deaths <- c(1,1,1,1,1)
structtime <- c(0.05,0.64)
structttot <- c(9.2, 40.0)
structdeaths = c(1, 5)
gamllik(structtime,structttot,structdeaths,time_die,ttot,deaths)
}
