% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi.R
\name{ROI_available_solvers}
\alias{ROI_available_solvers}
\title{Available Solvers}
\usage{
ROI_available_solvers(x = NULL, method = getOption("download.file.method"))
}
\arguments{
\item{x}{an object used to select a method. It can be either 
an object of class \code{"OP"} or an object of class \code{"ROI_signature"}
or \code{NULL}.}

\item{method}{a character string giving the method to be used for downloading files.
For more information see \code{\link[utils]{download.file}}.}
}
\value{
a data.frame with one row per package and repository.
}
\description{
ROI_available_solvers returns a data.frame of details corresponding to 
  solvers currently available at one or more repositories. 
  The current list of packages is downloaded over the Internet.
}
\details{
To get an overview about the available solvers 
  \code{ROI_available_solvers()} can be used.
  If a signature or an object of class \code{"OP"}
  is provided \pkg{ROI} will only return the solvers
  applicable the optimization problem. Note since NLP solver
  are also applicable for LP and QP they will also be listed.
}
\examples{
\dontrun{
ROI_available_solvers()
op <- OP(1:2)
ROI_available_solvers(op)
ROI_available_solvers(OP_signature(op))
}
}
