% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odbcSetQueryTimeout.R
\name{odbcSetQueryTimeout}
\alias{odbcSetQueryTimeout}
\title{Sets the query timeout of a prepared query}
\usage{
odbcSetQueryTimeout(channel, timeout = 0)
}
\arguments{
\item{channel}{an open RODBC channel (connection)}

\item{timeout}{the new query timeout value in seconds (0 means "no timeout")}
}
\value{
0 = success, 1 = success but with an info message,
}
\description{
A query has to be already prepared using SQLPrepare()

Throws an error if any error occured
}
\note{
Not all drivers will support a query timeout. You may get an error then
  or the query timeout values remains unchanged silently.
}
\examples{
\dontrun{
  conn = odbcConnect('MyDataSource')
  
  sqlPrepare(conn, "SELECT * FROM myTable WHERE column = ?")
  odbcSetQueryTimeout(conn, 120)   # sets the query timeout of the prepared statement
  sqlExecute(conn, 'myValue')
  sqlFetchMore(conn)
}

}
\seealso{
\code{\link{odbcGetQueryTimeout}}, \code{\link{odbcConnect}},
  \code{\link{odbcDriverConnect}}
}
