% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DirectMethod.R
\name{DINT}
\alias{DINT}
\title{Direct-INT}
\usage{
DINT(y, G, X, S, k = 3/8, parallel = F, check = T)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Obs by snp genotype matrix.}

\item{X}{Model matrix of covariates.}

\item{S}{Model matrix of structure adjustments.}

\item{k}{Offset applied during rank-normalization. See 
\code{\link{rankNormal}}.}

\item{parallel}{Logical indicating whether to run in parallel. Must register
parallel backend first.}

\item{check}{Logical indicating whether to check input formatting.}
}
\value{
A numeric matrix of score statistics and p-values, one for each locus
  (column) in \code{G}, assessing the null hypothesis that genotype is
  unrelated to the phenotype.
}
\description{
Tests of association between genotype and the rank normalized phenotype, 
adjusting for covariates and population structure.
}
\examples{
# Direct INT on the normal phenotype 
p = RNOmni::DINT(y=RNOmni::Y[,1],G=RNOmni::G[,1:10],X=RNOmni::X,S=RNOmni::S);
}
