% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset02}
\alias{dataset02}
\title{Van Dyke ROC dataset}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1:2, 1:5, 1:114, 1], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1:2, 1:5, 1:45, 1], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:45], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:45, 1], numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:45, 1], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "dataset02", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "ROC", the data type}
\item{\code{descriptions$name}}{, chr "VAN-DYKE", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, num [1:2, 1:5, 1:114, 1:2] 1 1 1 1 ..., truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr [1:2] "0" "1", treatment labels}
\item{\code{descriptions$readerID}}{, chr [1:5] "0" "1" "2" ..., reader labels}
}
}
\usage{
dataset02
}
\description{
This is referred to in the book as the "VD" dataset. It consists of 114 cases,
   45 of which are diseased, interpreted in two treatments ("0" = single spin echo 
   MRI, "1" = cine-MRI) by five radiologists using the ROC 
   paradigm. Each diseased cases had an aortic dissection; the ROC paradigm 
   generates one rating per case.  Often referred to in the ROC literature as the 
   Van Dyke dataset, which, along with the Franken dataset, has been widely 
   used to illustrate advances in ROC methodology. The example below displays 
   the ROC plot for the first treatment and first reader.
}
\examples{
str(dataset02)
PlotEmpiricalOperatingCharacteristics(dataset = dataset02, opChType = "ROC")$Plot



}
\references{
Van Dyke CW, et al. Cine MRI in the diagnosis of thoracic 
aortic dissection. 79th RSNA Meetings. 1993.
}
\keyword{datasets}
