% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfExtractCorCbmDataset.R
\name{DfExtractCorCbmDataset}
\alias{DfExtractCorCbmDataset}
\title{Extract two arms of a pairing from an MRMC ROC dataset}
\usage{
DfExtractCorCbmDataset(dataset, trts = 1, rdrs = 1)
}
\arguments{
\item{dataset}{The original dataset from which the pairing is to be extracted}

\item{trts}{A vector, maximum length 2, contains the indices of the treatment
or treatments to be extracted}

\item{rdrs}{A vector, maximum length 2, contains the indices of the reader or
readers to be extracted}
}
\value{
A new dataset in which the number of treatments is one and the number of readers is two
}
\description{
Extract a paired dataset from a larger dataset. The pairing could be
two readers in the same
treatment, or different readers in different treatments, or the same reader
in different treatments. If necessary
The data is binned to 5 bins in each condition.
}
\details{
The desired pairing is contained in the vectors \code{trts} and \code{rdrs}.
If either has length one, the other must
have length two and the pairing is implicit. If both are length two, then the pairing
is that implied by the first treatement
and the second reader, which is one arm, and the other arm is that implied by the second
treatment paired with the first
reader. Using this method any allowed pairing can be extracted and analyzed by \code{\link{FitCorCbm}}.
The utility of this software is
in designing a ratings simulator that is statistically matched to a real dataset.
}
\examples{

\donttest{
## Extract the paired data corresponding to the second and third readers in the first treatment
## from the included ROC dataset
dataset11_23 <- DfExtractCorCbmDataset(dataset05, trts = 1, rdrs = c(2,3))

## Extract the paired data corresponding to the third reader in the first and second treatments
dataset12_33 <- DfExtractCorCbmDataset(dataset05, trts = c(1,2), rdrs = 3)

## Extract the data corresponding to the first reader in the first
## treatment paired with the data
## from the third reader in the second treatment
## (the bin indices are at different positions in the two arrays)
dataset12_13 <- DfExtractCorCbmDataset(dataset05,
trts = c(1,2), rdrs = c(1,3))
}
}
