% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateCorCbmDataset.R
\name{SimulateCorCbmDataset}
\alias{SimulateCorCbmDataset}
\title{Simulate paired binned data for testing FitCorCbm}
\usage{
SimulateCorCbmDataset(seed = 123, K1 = 50, K2 = 50,
  desiredNumBins = 5, muX = 1.5, muY = 3, alphaX = 0.4,
  alphaY = 0.7, rhoNor = 0.3, rhoAbn2 = 0.8)
}
\arguments{
\item{seed}{The seed variable, default is 123; set to NULL for truly random seed}

\item{K1}{The number of non-diseased cases, default is 50}

\item{K2}{The number of diseased cases, default is 50}

\item{desiredNumBins}{The desired number of bins; default is 5}

\item{muX}{The CBM mu parameter in condition X}

\item{muY}{The CBM mu parameter in condition Y}

\item{alphaX}{The CBM alpha parameter in condition X}

\item{alphaY}{The CBM alpha parameter in condition Y}

\item{rhoNor}{The correlation of non-diseased case z-samples}

\item{rhoAbn2}{The correlation of diseased case z-samples, when disease is visible in both conditions}
}
\value{
The return value is the desired dataset, suitable for testing FitCorCbm
}
\description{
Simulates single treatment 2-reader binned ROC dataset, simulated according to the CORCBM model,
for the purpose of testing the fitting program \code{\link{FitCorCbm}}.
}
\details{
X and Y refer to the two arms of the pairing. \code{muX} and \code{alphaX} refer to the univariate CBM parameters
in condition X, \code{rhoNor} is the correlation of ratings of non-diseased cases and \code{rhoAbn2} is the correlation of ratings of
diseased cases when disease is visible in both conditions. The ROC data is bined to 5 bins in each condition.
See referenced publication.
}
\examples{

dataset <- SimulateCorCbmDataset()

\dontrun{
## this takes very long
dataset <- SimulateCorCbmDataset(K1 = 5000, K2 = 5000)

}


}
\references{
Zhai X, Chakraborty DP (2017) A bivariate contaminated binormal model for robust fitting of proper ROC
curves to a pair of correlated, possibly degenerate, ROC datasets. Medical Physics. 44(6):2207--2222.
}
