/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.api.SDMXVersion;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.event.DataFooterMessageEvent;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v30.AvailabilityParser;
import it.bancaditalia.oss.sdmx.parser.v30.Sdmx30Queries;
import it.bancaditalia.oss.sdmx.parser.v30.SeriesCountParser;
import it.bancaditalia.oss.sdmx.util.QueryRunner;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class RestSdmx30Client
extends RestSdmxClient {
    protected final String LATEST_VERSION = "+";

    public RestSdmx30Client(Provider provider) {
        super(provider);
        this.sdmxVersion = SDMXVersion.V3;
        this.latestKeyword = this.LATEST_VERSION;
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        return this.getTimeSeries(dataflow, dataFlowStructure, string, null, string2, string3, bl ? "none" : "all", bl ? "none" : "all", string4, bl2);
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws SdmxException {
        return this.postProcess(this.getData(dataflow, dataFlowStructure, string, string2, string3, string4, string5, string6, string7, bl));
    }

    @Override
    public Map<String, List<String>> getAvailableCubeRegion(Dataflow dataflow, String string, String string2) throws SdmxException {
        URL uRL = this.buildAvailabilityQuery(dataflow, string, string2);
        return QueryRunner.runQuery(new AvailabilityParser(), uRL, this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1"));
    }

    @Override
    public Integer getAvailableTimeSeriesNumber(Dataflow dataflow, String string) throws SdmxException {
        URL uRL = this.buildAvailabilityQuery(dataflow, string, "exact");
        return QueryRunner.runQuery(new SeriesCountParser(), uRL, this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1"));
    }

    protected DataParsingResult getData(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String object, String string2, String string3, String string4, String string5, String string6, boolean bl) throws SdmxException {
        Object object2;
        if (string != null && !string.isEmpty()) {
            if (string.contains("+")) {
                object2 = this.mapSDMX2KeytoSDMX3FIlter(string, dataFlowStructure);
                object = object != null && !((String)object).isEmpty() ? (String)object + "&" + (String)object2 : object2;
                string = null;
            } else {
                string = string.replace("..", ".*.").replace("..", ".*.");
            }
        }
        object2 = this.buildDataQuery(dataflow, string, (String)object, string2, string3, string4, string5, string6, bl);
        String string7 = "data_" + dataflow.getId() + "_" + (String)object;
        DataParsingResult dataParsingResult = QueryRunner.runQuery(new CompactDataParser(dataFlowStructure, dataflow, !"none".equals(string4) || !"none".equals(string5)), (URL)object2, this.getName(), string7, this.handleHttpHeaders("application/vnd.sdmx.structurespecificdata+xml;version=2.1"));
        Message message = dataParsingResult.getMessage();
        if (message != null) {
            LOGGER.log(Level.INFO, "The sdmx call returned messages in the footer:\n {0}", message);
            DataFooterMessageEvent dataFooterMessageEvent = new DataFooterMessageEvent((URL)object2, message);
            QueryRunner.getDataFooterMessageEventListener().onSdmxEvent(dataFooterMessageEvent);
        }
        return dataParsingResult;
    }

    private String mapSDMX2KeytoSDMX3FIlter(String string, DataFlowStructure dataFlowStructure) throws SdmxInvalidParameterException {
        String string2 = "";
        Dimension[] dimensionArray = (Dimension[])dataFlowStructure.getDimensions().toArray();
        String string3 = "[.]";
        String[] stringArray = string.split(string3);
        if (stringArray.length > dimensionArray.length) {
            throw new SdmxInvalidParameterException("The ts key is not valid: the dataflow does not contain so many dimensions.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].isEmpty() || stringArray[i].equals("*")) continue;
            string2 = string2 + (!string2.isEmpty() ? "&" : "") + "c[" + dimensionArray[i].getId() + "]=" + stringArray[i].replace("+", ",");
        }
        return string2;
    }

    protected URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws SdmxException {
        if (this.provider.getEndpoint() != null && dataflow != null) {
            return Sdmx30Queries.createDataQuery(this.provider.getEndpoint(), dataflow.getFullIdentifier(), string, string2, string3, string4, string5, string6, string7, bl).buildQuery();
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " endpoint=" + this.provider.getEndpoint());
    }

    @Override
    protected URL buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        if (this.provider.getEndpoint() != null && string2 != null && !string2.isEmpty() && string != null && !string.isEmpty()) {
            return Sdmx30Queries.createStructureQuery(this.provider.getEndpoint(), string, string2, string3, bl).buildQuery();
        }
        throw new RuntimeException("Invalid query parameters: agency=" + string2 + " dsd=" + string + " endpoint=" + this.provider.getEndpoint());
    }

    @Override
    protected URL buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        return Sdmx30Queries.createDataflowQuery(this.provider.getEndpoint(), string, string2, string3).buildQuery();
    }

    @Override
    protected URL buildCodelistQuery(String string, String string2, String string3) throws SdmxException {
        return Sdmx30Queries.createCodelistQuery(this.provider.getEndpoint(), string, string2, string3).buildQuery();
    }

    protected URL buildAvailabilityQuery(Dataflow dataflow, String string, String string2) throws SdmxException {
        return Sdmx30Queries.createAvailabilityQuery(this.provider.getEndpoint(), dataflow.getFullIdentifier(), string, string2).buildQuery();
    }

    protected URL buildAvailabilityQueryByKey(Dataflow dataflow, String string, String string2) throws SdmxException {
        return Sdmx30Queries.createAvailabilityQueryByKey(this.provider.getEndpoint(), dataflow.getFullIdentifier(), string, string2).buildQuery();
    }
}

