/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.DSDIdentifier;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.GenericSDMXClient;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.parser.v21.CodelistParser;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataflowParser;
import it.bancaditalia.oss.sdmx.parser.v21.RestQueryBuilder;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.DatatypeConverter;

public class RestSdmxClient
implements GenericSDMXClient {
    protected boolean dotStat = false;
    protected URL endpoint = null;
    protected String name = null;
    protected boolean needsCredentials = false;
    protected boolean needsURLEncoding = false;
    protected boolean supportsCompression = false;
    protected boolean containsCredentials = false;
    protected String user = null;
    protected String pw = null;
    protected HttpURLConnection conn = null;
    private static final String sourceClass = RestSdmxClient.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();

    public RestSdmxClient(String string, URL uRL, boolean bl, boolean bl2, boolean bl3) {
        this.endpoint = uRL;
        this.name = string;
        this.needsCredentials = bl;
        this.needsURLEncoding = bl2;
        this.supportsCompression = bl3;
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap;
        block14: {
            String string = null;
            InputStreamReader inputStreamReader = null;
            hashMap = null;
            string = this.buildFlowQuery("all", "all", "latest");
            try {
                inputStreamReader = this.runQuery(string, null);
                if (inputStreamReader != null) {
                    List<Dataflow> list = DataflowParser.parse(inputStreamReader);
                    if (list.size() > 0) {
                        hashMap = new HashMap<String, Dataflow>();
                        for (Dataflow dataflow : list) {
                            hashMap.put(dataflow.getId(), dataflow);
                        }
                        break block14;
                    }
                    throw new SdmxException("The query returned zero dataflows");
                }
                throw new SdmxException("The query returned a null stream");
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
                if (this.conn != null) {
                    this.conn.disconnect();
                }
            }
        }
        return hashMap;
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        Dataflow dataflow;
        block13: {
            String string4 = null;
            InputStreamReader inputStreamReader = null;
            dataflow = null;
            string4 = this.buildFlowQuery(string, string2, string3);
            try {
                inputStreamReader = this.runQuery(string4, null);
                if (inputStreamReader != null) {
                    List<Dataflow> list = DataflowParser.parse(inputStreamReader);
                    if (list.size() >= 1) {
                        dataflow = list.get(0);
                        break block13;
                    }
                    throw new SdmxException("The query returned zero dataflows");
                }
                throw new SdmxException("The query returned a null stream");
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
                if (this.conn != null) {
                    this.conn.disconnect();
                }
            }
        }
        return dataflow;
    }

    @Override
    public DataFlowStructure getDataFlowStructure(DSDIdentifier dSDIdentifier, boolean bl) throws SdmxException {
        DataFlowStructure dataFlowStructure;
        block13: {
            String string = null;
            InputStreamReader inputStreamReader = null;
            dataFlowStructure = null;
            if (dSDIdentifier != null) {
                string = this.buildDSDQuery(dSDIdentifier.getId(), dSDIdentifier.getAgency(), dSDIdentifier.getVersion(), bl);
                try {
                    inputStreamReader = this.runQuery(string, null);
                    if (inputStreamReader != null) {
                        dataFlowStructure = DataStructureParser.parse(inputStreamReader).get(0);
                        break block13;
                    }
                    throw new SdmxException("The query returned a null stream");
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
                finally {
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException) {
                            logger.severe("Exception caught closing stream.");
                        }
                    }
                    if (this.conn != null) {
                        this.conn.disconnect();
                    }
                }
            }
            throw new SdmxException("Null dsd in input");
        }
        return dataFlowStructure;
    }

    @Override
    public Map<String, String> getCodes(String string, String string2, String string3) throws SdmxException {
        Map<String, String> map;
        block12: {
            String string4 = null;
            InputStreamReader inputStreamReader = null;
            map = null;
            string4 = this.buildCodelistQuery(string, string2, string3);
            try {
                inputStreamReader = this.runQuery(string4, null);
                if (inputStreamReader != null) {
                    map = CodelistParser.parse(inputStreamReader);
                    break block12;
                }
                throw new SdmxException("The query returned a null stream");
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
                if (this.conn != null) {
                    this.conn.disconnect();
                }
            }
        }
        return map;
    }

    @Override
    public List<PortableTimeSeries> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        List<PortableTimeSeries> list;
        block12: {
            String string5 = null;
            InputStreamReader inputStreamReader = null;
            list = null;
            string5 = this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2);
            try {
                inputStreamReader = this.runQuery(string5, "application/vnd.sdmx.structurespecificdata+xml;version=2.1");
                if (inputStreamReader != null) {
                    list = CompactDataParser.parse(inputStreamReader, dataFlowStructure, dataflow.getId(), !bl);
                    break block12;
                }
                throw new SdmxException("The query returned a null stream");
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
                if (this.conn != null) {
                    this.conn.disconnect();
                }
            }
        }
        return list;
    }

    @Override
    public boolean needsCredentials() {
        return this.needsCredentials;
    }

    @Override
    public void setCredentials(String string, String string2) {
        this.user = string;
        this.pw = string2;
        this.needsCredentials = false;
        this.containsCredentials = true;
    }

    @Override
    public URL getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String buildDataURL(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        return this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2);
    }

    protected InputStreamReader runQuery(String string, String string2) throws SdmxException {
        logger.entering(sourceClass, "runQuery");
        if (this.needsURLEncoding) {
            string = string.replace("|", "%2B");
            string = string.replace("+", "%2B");
        }
        logger.info("Contacting web service with query: " + string);
        try {
            URL uRL = new URL(string);
            this.conn = (HttpURLConnection)uRL.openConnection();
            this.conn.setRequestMethod("GET");
            this.handleHttpHeaders(this.conn, string2);
            int n = this.conn.getResponseCode();
            if (n == 200) {
                logger.fine("Connection opened. Code: " + n);
                if (this.supportsCompression) {
                    return new InputStreamReader((InputStream)new GZIPInputStream(this.conn.getInputStream()), "UTF-8");
                }
                return new InputStreamReader(this.conn.getInputStream(), "UTF-8");
            }
            String string3 = "Connection failed. HTTP error code : " + n + ", message: " + this.conn.getResponseMessage() + "\n";
            switch (n) {
                case 304: {
                    string3 = string3 + "SDMX meaning: No change since the timestamp supplied in the If-Modified-Since header";
                    logger.severe(string3);
                    throw new SdmxException(string3);
                }
                case 400: {
                    string3 = string3 + "SDMX meaning: There is a problem with the syntax of the query";
                    logger.severe(string3);
                    throw new SdmxException(string3);
                }
                case 401: {
                    string3 = string3 + "SDMX meaning: Credentials needed";
                    logger.severe(string3);
                    throw new SdmxException(string3);
                }
                case 403: {
                    string3 = string3 + "SDMX meaning: The syntax of the query is OK but it has no meaning";
                    logger.severe(string3);
                    throw new SdmxException(string3);
                }
                case 404: {
                    string3 = string3 + "SDMX meaning: No results matching the query.";
                    logger.severe(string3);
                    throw new SdmxException(string3);
                }
                case 406: {
                    string3 = string3 + "SDMX meaning: Not a supported format.";
                    logger.severe(string3);
                    throw new SdmxException(string3);
                }
                case 413: {
                    string3 = string3 + "SDMX meaning: Results too large.";
                    logger.severe(string3);
                    throw new SdmxException(string3);
                }
                case 500: {
                    string3 = string3 + "SDMX meaning: Error on the provider side.";
                    logger.severe(string3);
                    throw new SdmxException(string3);
                }
                case 501: {
                    string3 = string3 + "SDMX meaning: Feature not supported.";
                    logger.severe(string3);
                    throw new SdmxException(string3);
                }
                case 503: {
                    string3 = string3 + "SDMX meaning: Service temporarily unavailable. Please try again later..";
                    logger.severe(string3);
                    throw new SdmxException(string3);
                }
            }
            logger.severe(string3);
            throw new SdmxException(string3);
        }
        catch (IOException iOException) {
            logger.severe("Exception. Class: " + iOException.getClass().getName() + " .Message: " + iOException.getMessage());
            logger.log(Level.FINER, "Exception: ", iOException);
            throw new SdmxException("Exception. Class: " + iOException.getClass().getName() + " .Message: " + iOException.getMessage());
        }
    }

    protected void handleHttpHeaders(HttpURLConnection httpURLConnection, String string) {
        if (this.containsCredentials) {
            logger.fine("Setting http authorization");
            String string2 = DatatypeConverter.printBase64Binary((byte[])(this.user + ":" + this.pw).getBytes());
            httpURLConnection.setRequestProperty("Authorization", "Basic " + string2);
        }
        if (this.supportsCompression) {
            httpURLConnection.addRequestProperty("Accept-Encoding", "gzip");
        }
        if (string != null) {
            httpURLConnection.setRequestProperty("Accept", string);
        }
    }

    protected String buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        if (this.endpoint != null && dataflow != null && string != null && !string.isEmpty()) {
            String string5 = RestQueryBuilder.getDataQuery(this.endpoint, dataflow.getFullIdentifier(), string, string2, string3, bl, string4, bl2, null);
            return string5;
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.endpoint);
    }

    protected String buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        if (this.endpoint != null && string2 != null && !string2.isEmpty() && string != null && !string.isEmpty()) {
            String string4 = RestQueryBuilder.getStructureQuery(this.endpoint, string, string2, string3, bl);
            return string4;
        }
        throw new RuntimeException("Invalid query parameters: agency=" + string2 + " dsd=" + string + " endpoint=" + this.endpoint);
    }

    protected String buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        String string4 = RestQueryBuilder.getDataflowQuery(this.endpoint, string, string2, string3);
        return string4;
    }

    protected String buildCodelistQuery(String string, String string2, String string3) throws SdmxException {
        String string4 = RestQueryBuilder.getCodelistQuery(this.endpoint, string, string2, string3);
        return string4;
    }
}

